/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.render.internal.style;

import com.ibm.etools.webedit.render.internal.style.DefaultContainerStyle;
import com.ibm.etools.webedit.render.internal.style.HTMLContainerStyle;
import com.ibm.etools.xve.renderer.internal.style.ColorPool;
import com.ibm.etools.xve.renderer.style.RenderOption;
import com.ibm.etools.xve.renderer.style.StyleChangeListener;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Scrollable;

public class StandardContainerStyle
extends DefaultContainerStyle
implements HTMLContainerStyle {
    private StyleChangeListener[] changeListeners = null;
    private int numChangeListeners = 0;
    private boolean gridMode = false;
    private Color gridColor = null;
    private int gridHolizontal = -1;
    private int gridVertical = -1;
    private int hmargin = 0;
    private int vmargin = 0;
    private boolean hmargin_specified = false;
    private boolean vmargin_specified = false;
    private Color systemFg = null;
    private Color systemBg = null;
    private Color pageBGColor;
    private RenderOption option;

    public StandardContainerStyle(Scrollable scrollable, RenderOption o) {
        super(scrollable);
        this.option = o;
    }

    @Override
    public final void addStyleChangeListener(StyleChangeListener listener) {
        int currentLength;
        if (this.changeListeners == null) {
            this.changeListeners = new StyleChangeListener[2];
        }
        if (this.numChangeListeners == (currentLength = this.changeListeners.length)) {
            StyleChangeListener[] newArray = new StyleChangeListener[currentLength * 2];
            System.arraycopy(this.changeListeners, 0, newArray, 0, currentLength);
            this.changeListeners = newArray;
        }
        this.changeListeners[this.numChangeListeners] = listener;
        ++this.numChangeListeners;
    }

    @Override
    public final void removeStyleChangeListener(StyleChangeListener listener) {
        int i = this.numChangeListeners - 1;
        while (i >= 0) {
            if (this.changeListeners[i].equals(listener)) {
                int numCopy = this.numChangeListeners - 1 - i;
                if (numCopy > 0) {
                    System.arraycopy(this.changeListeners, i + 1, this.changeListeners, i, numCopy);
                }
                --this.numChangeListeners;
            }
            --i;
        }
    }

    private void notifyListeners(int hint) {
        int i = 0;
        while (i < this.numChangeListeners) {
            this.changeListeners[i].styleChanged(hint);
            ++i;
        }
    }

    @Override
    public void dispose() {
        ColorPool.getInstance().releaseColor(this.gridColor);
        this.gridColor = null;
        ColorPool.getInstance().releaseColor(this.systemFg);
        ColorPool.getInstance().releaseColor(this.systemBg);
        ColorPool.getInstance().releaseColor(this.pageBGColor);
        this.systemFg = null;
        this.systemBg = null;
        this.pageBGColor = null;
        ColorPool.getInstance().dispose();
    }

    @Override
    public void update(boolean refresh) {
        ColorPool.getInstance().refresh();
        this.notifyListeners(1);
    }

    @Override
    public Color getGridColor() {
        return this.gridColor == null ? ColorConstants.cyan : this.gridColor;
    }

    @Override
    public int getGridHorizontalPixel() {
        return this.gridHolizontal;
    }

    @Override
    public int getGridVerticalPixel() {
        return this.gridVertical;
    }

    @Override
    public int getHorizontalMarginPixel() {
        return this.hmargin;
    }

    @Override
    public int getVerticalMarginPixel() {
        return this.vmargin;
    }

    @Override
    public boolean isHorizontalMarginSpecified() {
        return this.hmargin_specified;
    }

    @Override
    public boolean isVerticalMarginSpecified() {
        return this.vmargin_specified;
    }

    @Override
    public boolean isGrid() {
        return this.gridMode;
    }

    @Override
    public void setGrid(boolean grid) {
        this.gridMode = grid;
    }

    @Override
    public void setGridColor(RGB rgb) {
        if (this.gridColor != null) {
            ColorPool.getInstance().releaseColor(this.gridColor);
            this.gridColor = null;
        }
        if (rgb != null) {
            this.gridColor = ColorPool.getInstance().createColor(rgb.red, rgb.green, rgb.blue);
        }
    }

    @Override
    public void setGridHorizontalPixel(int interval) {
        this.gridHolizontal = interval;
    }

    @Override
    public void setGridVerticalPixel(int interval) {
        this.gridVertical = interval;
    }

    @Override
    public void setHorizontalMarginPixel(int pixel, boolean specified) {
        this.hmargin = pixel;
        this.hmargin_specified = specified;
    }

    @Override
    public void setVerticalMarginPixel(int pixel, boolean specified) {
        this.vmargin = pixel;
        this.vmargin_specified = specified;
    }

    @Override
    public Color getForegroundColor() {
        Color c = ColorPool.getInstance().getDefaultColor(0);
        ColorPool.getInstance().releaseColor(this.systemFg);
        this.systemFg = c;
        return c;
    }

    @Override
    public Color getBackgroundColor() {
        Color c = ColorPool.getInstance().getDefaultColor(1);
        ColorPool.getInstance().releaseColor(this.systemBg);
        this.systemBg = c;
        return c;
    }

    @Override
    public int getVisualCue() {
        if (this.option != null) {
            switch (this.option.getVisualCueMask()) {
                case 2: {
                    return 2;
                }
                case 1: {
                    return 1;
                }
            }
            return 0;
        }
        return 0;
    }

    @Override
    public void setPageBackgroundColor(boolean isWML) {
        ColorPool.getInstance().releaseColor(this.pageBGColor);
        this.pageBGColor = isWML ? ColorPool.getInstance().getDefaultColor(2) : null;
    }

    @Override
    public Color getPageBackgroundColor() {
        return this.pageBGColor;
    }
}

