/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.render.internal.style;

import com.ibm.etools.webedit.viewer.WebEditViewerPlugin;
import com.ibm.etools.webedit.viewer.internal.utils.Logger;
import com.ibm.etools.xve.renderer.internal.style.ImageObjectImpl;
import com.ibm.etools.xve.renderer.style.ImageObject;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import java.util.Map;

public final class IconFactory {
    private static final String ICON_PATH = "icons/full/obj16/";
    static IconFactory instance = new IconFactory();
    private Map map = new Hashtable();

    protected IconFactory() {
    }

    public static IconFactory getInstance() {
        return instance;
    }

    public ImageObject getObject(String iconFileName) {
        ImageObject obj = (ImageObject)this.map.get(iconFileName);
        if (obj == null) {
            try {
                URL url = WebEditViewerPlugin.getDefault().getBundle().getEntry(ICON_PATH + iconFileName);
                obj = new ImageObjectImpl(url.openStream());
                obj.setData((Object)iconFileName);
                this.map.put(iconFileName, obj);
            }
            catch (MalformedURLException e) {
                Logger.log(e);
                return null;
            }
            catch (IOException e) {
                Logger.log(e);
                return null;
            }
        }
        obj.addRef();
        return obj;
    }

    public ImageObject getObject(InputStream is) {
        ImageObjectImpl obj = new ImageObjectImpl(is);
        if (obj != null) {
            obj.setData(null);
        }
        return obj;
    }

    public void releaseObject(ImageObject object) {
        Object o;
        if (object == null) {
            return;
        }
        if (object.releaseRef() <= 0 && (o = object.getData()) != null) {
            this.map.remove(o);
        }
    }
}

