/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.render.internal.layout;

import com.ibm.etools.xve.renderer.figures.IElementFigure;
import com.ibm.etools.xve.renderer.internal.figures.FlowUtilities;
import com.ibm.etools.xve.renderer.internal.figures.LengthUtil;
import com.ibm.etools.xve.renderer.layout.box.LayoutBox;
import com.ibm.etools.xve.renderer.layout.box.LineBox;
import com.ibm.etools.xve.renderer.layout.html.TextfieldLayout;
import com.ibm.etools.xve.renderer.style.CSSFont;
import com.ibm.etools.xve.renderer.style.Length;
import com.ibm.etools.xve.renderer.style.Style;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;

public class WMLTextfieldLayout
extends TextfieldLayout {
    protected void endBlock() {
        Rectangle clipRect;
        FontMetrics fm;
        Font font;
        IElementFigure cssFigure;
        if (this.flowFigure == null || this.context == null) {
            return;
        }
        Style style = this.flowFigure.getStyle();
        if (style == null) {
            return;
        }
        try {
            cssFigure = (IElementFigure)this.flowFigure;
        }
        catch (ClassCastException classCastException) {
            cssFigure = null;
        }
        if (cssFigure == null) {
            return;
        }
        int align = this.getAlign(71);
        int topMargin = cssFigure.getTopMargin();
        int bottomMargin = cssFigure.getBottomMargin();
        int leftMargin = cssFigure.getLeftMargin();
        int rightMargin = cssFigure.getRightMargin();
        int topSpacing = cssFigure.getTopSpacing();
        int bottomSpacing = cssFigure.getBottomSpacing();
        int leftSpacing = cssFigure.getLeftSpacing();
        int rightSpacing = cssFigure.getRightSpacing();
        int nrows = style.getInteger(120);
        int ncols = style.getInteger(121);
        int availableWidth = LengthUtil.convPixelToEn((int)Math.min(this.fixedWidth, this.getCurrentLine().getRemainingWidth()), (CSSFont)cssFigure.getCSSFont());
        if (ncols <= 0) {
            ncols = availableWidth;
        } else if (ncols > availableWidth) {
            if (nrows == 12345678) {
                nrows = ncols / (availableWidth + 1);
                nrows += ncols % (availableWidth + 1) != 0 ? 1 : 0;
            }
            ncols = availableWidth + (nrows <= 1 ? 1 : 0);
        }
        if ((nrows != 12345678 && nrows > 0 || ncols != 12345678 && ncols > 0) && (font = cssFigure.getFont()) != null && (fm = FlowUtilities.getFontMetrics((Font)font)) != null) {
            if (nrows != 12345678 && nrows > 0) {
                int rowHeight = fm.getHeight() + fm.getLeading();
                nrows = Math.min(nrows, (Integer.MAX_VALUE - this.blockBox.y - (topSpacing + bottomSpacing)) / rowHeight);
                this.blockBox.height = rowHeight * nrows;
            }
            if (ncols != 12345678 && ncols > 0) {
                this.blockBox.width = LengthUtil.getLengthByPixel((int)121, (int)0, (int)this.blockBox.width, (Length)new Length((float)ncols, 12), (CSSFont)cssFigure.getCSSFont());
                this.blockBox.width = Math.min(this.blockBox.width, Integer.MAX_VALUE - this.blockBox.x - (leftSpacing + rightSpacing + cssFigure.getVScrollBarWidth()));
            }
        }
        cssFigure.setDropDownButton(false);
        cssFigure.setVerticalResizer(false);
        int hResizer = style.getUIType(103);
        if (hResizer == 4 || hResizer == 2 || hResizer == 1) {
            boolean scrollbar = true;
            if (hResizer == 1) {
                if (nrows == 1 && this.allowDropDown()) {
                    this.blockBox.width += cssFigure.getVScrollBarWidth();
                    cssFigure.setDropDownButton(true);
                    scrollbar = false;
                } else {
                    Rectangle r = this.blockBox.getCopy();
                    List children = this.blockBox.getChildren();
                    if (children != null) {
                        int max = children.size();
                        int i = 0;
                        while (i < max) {
                            Rectangle rect;
                            try {
                                rect = (Rectangle)children.get(i);
                            }
                            catch (ClassCastException classCastException) {
                                rect = null;
                            }
                            if (rect != null) {
                                r.union(rect);
                            }
                            ++i;
                        }
                    }
                    if (r.height <= this.blockBox.height) {
                        scrollbar = false;
                        this.blockBox.width += cssFigure.getVScrollBarWidth();
                    }
                }
            }
            if (scrollbar) {
                this.blockBox.width += cssFigure.getVScrollBarWidth();
                cssFigure.setVerticalResizer(true);
            }
        }
        if (this.expandBlock()) {
            this.blockBox.width = this.blockBox.getInnerWidth();
        }
        int w = this.getPixelWidth(style, cssFigure) - (leftSpacing - leftMargin + (rightSpacing - rightMargin));
        int h = this.getPixelHeight(style, cssFigure) - (topSpacing - topMargin + (bottomSpacing - bottomMargin));
        if (w >= 0 && this.blockBox.width > w) {
            this.blockBox.width = w;
        }
        if (h >= 0 && this.blockBox.height > h) {
            this.blockBox.height = h;
        }
        if (this.blockBox.width < w) {
            this.blockBox.width = w;
        }
        if (this.blockBox.height < h) {
            this.blockBox.height = h;
        }
        this.prevExpand = this.context.expandWidth();
        this.alignHorizontal(style, align);
        this.blockBox.y -= topSpacing - topMargin;
        this.blockBox.x = this.blockBox.getRecommendedX() - (leftSpacing - leftMargin);
        this.blockBox.width += leftSpacing - leftMargin + (rightSpacing - rightMargin);
        this.blockBox.height += topSpacing - topMargin + (bottomSpacing - bottomMargin);
        this.marginBox.clear();
        this.marginBox.x = this.blockBox.x - leftMargin;
        this.marginBox.y = this.blockBox.y - topMargin;
        this.marginBox.width = this.blockBox.width + leftMargin + rightMargin;
        this.marginBox.height = this.blockBox.height + topMargin + bottomMargin;
        this.marginBox.setOwner((IFigure)this.flowFigure);
        this.marginBox.add((LayoutBox)this.blockBox);
        LineBox lineBox = this.context.getCurrentLine();
        if (lineBox.getRemainingWidth() < this.marginBox.width) {
            this.context.endLine();
            this.checkLineWithFloatingObject(this.marginBox.width);
            lineBox = this.context.getCurrentLine();
            int dy = lineBox.y - this.blockBox.y;
            int x = this.calcRecommendedX(style, cssFigure, this.blockBox.y + dy, leftSpacing, rightSpacing);
            int dx = x - (leftSpacing - leftMargin) - this.blockBox.x;
            this.marginBox.translateRecursive(dx, dy);
        }
        if ((clipRect = this.blockBox.getCopy()) != null) {
            clipRect.x += leftSpacing - leftMargin;
            clipRect.width -= leftSpacing - leftMargin + (rightSpacing - rightMargin);
            if (cssFigure.getVerticalResizer() || cssFigure.getDropDownButton()) {
                clipRect.width -= cssFigure.getVScrollBarWidth();
            }
            clipRect.y += topSpacing - topMargin;
            clipRect.height -= topSpacing - topMargin + (topSpacing - topMargin);
            if (cssFigure.getHorizontalResizer()) {
                clipRect.height -= cssFigure.getHScrollBarHeight();
            }
            List children = this.blockBox.getChildren();
            int nChildren = children.size();
            int i = 0;
            while (i < nChildren) {
                try {
                    LayoutBox child = (LayoutBox)children.get(i);
                    child.intersect(clipRect);
                }
                catch (ClassCastException classCastException) {}
                ++i;
            }
        }
        this.marginBox.setAlign(this.getAlign(70));
        this.context.addToCurrentLine((LayoutBox)this.marginBox);
        this.context.allowLeadingSpace(true);
        List v = this.flowFigure.getFragments();
        v.clear();
        v.add(this.blockBox);
        List ov = cssFigure.getOptionalFragments();
        ov.clear();
        ov.add(this.marginBox);
        if (this.textBox != null) {
            if (clipRect != null) {
                this.textBox.intersect((Rectangle)this.blockBox);
            }
            ov.add(this.textBox);
        }
        boolean disabled = style.getUIType(191) == 1;
        cssFigure.setDisabled(disabled);
    }
}

