/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.render.internal.layout;

import com.ibm.etools.webedit.render.internal.layout.IWmlListBoxContext;
import com.ibm.etools.webedit.render.internal.layout.IWmlListBoxItem;
import com.ibm.etools.xve.renderer.figures.IElementFigure;
import com.ibm.etools.xve.renderer.figures.IFlowFigure;
import com.ibm.etools.xve.renderer.layout.html.IListBoxContext;
import com.ibm.etools.xve.renderer.layout.html.IListBoxItem;
import com.ibm.etools.xve.renderer.layout.html.TextfieldLayout;
import com.ibm.etools.xve.renderer.style.Style;
import com.ibm.icu.util.StringTokenizer;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;

public class WMLListBoxLayout
extends TextfieldLayout
implements IWmlListBoxContext {
    private int recommendedBulletPointSize = -1;
    private final List items = new ArrayList();
    private final List selected_items = new ArrayList();
    private String indices;

    protected void setupBlock() {
        this.calcRecommendedBulletPointSize();
        Style style = this.flowFigure.getStyle();
        this.indices = style.getText(100);
        if (this.items != null) {
            this.items.clear();
        }
        if (this.selected_items != null) {
            this.selected_items.clear();
        }
        super.setupBlock();
    }

    private void calcRecommendedBulletPointSize() {
        List children = this.flowFigure.getChildren();
        this.recommendedBulletPointSize = -1;
        int i = 0;
        while (i < children.size()) {
            IFigure child = (IFigure)children.get(i);
            LayoutManager layout = child.getLayoutManager();
            if (layout instanceof IWmlListBoxItem) {
                int size = ((IWmlListBoxItem)layout).getBulletPointSize(child);
                this.recommendedBulletPointSize = Math.max(this.recommendedBulletPointSize, size);
            }
            ++i;
        }
    }

    @Override
    public int getListBoxItemIndexOf(IFlowFigure figure) {
        List children = this.flowFigure.getChildren();
        int index = 1;
        int i = 0;
        while (i < children.size()) {
            IFigure fig = (IFigure)children.get(i);
            if (figure == fig) break;
            LayoutManager layout = fig.getLayoutManager();
            if (layout instanceof IWmlListBoxItem) {
                index += ((IWmlListBoxItem)layout).getListBoxItemCount(fig);
            }
            ++i;
        }
        return index;
    }

    @Override
    public int getRecommendedBulletPointSize() {
        return this.recommendedBulletPointSize;
    }

    public void addListBoxItem(IListBoxItem item) {
        if (this.items != null) {
            this.items.add(item);
        }
    }

    protected void endBlock() {
        super.endBlock();
        this.expandAllItems();
        this.choseSelected();
    }

    public IListBoxContext getListBoxContext() {
        return this;
    }

    public boolean isDisabled() {
        Style style;
        boolean disabled = false;
        try {
            style = this.flowFigure.getStyle();
        }
        catch (NullPointerException nullPointerException) {
            style = null;
        }
        if (style != null && style.getUIType(191) == 1) {
            disabled = true;
        }
        return disabled;
    }

    public boolean isDropDownButton() {
        Style style;
        try {
            style = this.flowFigure.getStyle();
        }
        catch (NullPointerException nullPointerException) {
            style = null;
        }
        return style != null && style.getUIType(103) == 1 && style.getInteger(120) == 1 && this.allowDropDown();
    }

    public boolean isMultiple() {
        Style style;
        boolean multiple = false;
        try {
            style = this.flowFigure.getStyle();
        }
        catch (NullPointerException nullPointerException) {
            style = null;
        }
        if (style != null && style.getUIType(193) == 1) {
            multiple = true;
        }
        return multiple;
    }

    public void requestInversed(IListBoxItem item) {
        if (this.selected_items != null) {
            this.selected_items.add(item);
        }
    }

    private void expandAllItems() {
        IElementFigure cssFigure;
        if (this.blockBox == null || this.items == null) {
            return;
        }
        int nItems = this.items.size();
        if (nItems <= 0) {
            return;
        }
        try {
            cssFigure = (IElementFigure)this.flowFigure;
        }
        catch (ClassCastException classCastException) {
            cssFigure = null;
        }
        if (cssFigure != null) {
            int width = this.blockBox.width - (cssFigure.getLeftSpacing() + cssFigure.getRightSpacing());
            if (cssFigure.getVerticalResizer() || cssFigure.getDropDownButton()) {
                width = Math.max(0, width - cssFigure.getVScrollBarWidth());
            }
            width = Math.max(0, width);
            int i = 0;
            while (i < nItems) {
                IListBoxItem item;
                try {
                    item = (IListBoxItem)this.items.get(i);
                }
                catch (ClassCastException classCastException) {
                    item = null;
                }
                if (item != null) {
                    item.expandListBoxItem(width);
                }
                ++i;
            }
        }
    }

    private void choseSelected() {
        int nItems;
        if (this.selected_items != null && (nItems = this.selected_items.size()) > 0) {
            int i = 0;
            while (i < nItems) {
                try {
                    ((IWmlListBoxItem)this.selected_items.get(i)).setSelectedOption(true);
                }
                catch (ClassCastException classCastException) {
                }
                catch (NullPointerException nullPointerException) {}
                ++i;
            }
        }
    }

    @Override
    public void requestSelectedOption(IWmlListBoxItem item) {
        if (this.selected_items != null) {
            this.selected_items.add(item);
        }
    }

    @Override
    public boolean askSelected(int itemIndex) {
        if (this.indices == null || this.indices.length() == 0) {
            if (this.flowFigure == null) {
                return false;
            }
            if (this.flowFigure.getStyle() == null) {
                return false;
            }
            return itemIndex == 1 && this.flowFigure.getStyle().getUIType(193) != 1;
        }
        StringTokenizer tokenizer = new StringTokenizer(this.indices, ";");
        int length = tokenizer.countTokens();
        int i = 0;
        while (i < length) {
            String index = tokenizer.nextToken();
            try {
                if (itemIndex == Integer.valueOf(index)) {
                    return true;
                }
            }
            catch (NumberFormatException numberFormatException) {}
            ++i;
        }
        return false;
    }
}

