/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.render.internal.layout;

import com.ibm.etools.webedit.render.internal.layout.IWmlListBoxContext;
import com.ibm.etools.webedit.render.internal.layout.IWmlListBoxItem;
import com.ibm.etools.xve.renderer.figures.IElementFigure;
import com.ibm.etools.xve.renderer.figures.IFlowFigure;
import com.ibm.etools.xve.renderer.internal.figures.FlowUtilities;
import com.ibm.etools.xve.renderer.layout.box.LayoutBox;
import com.ibm.etools.xve.renderer.layout.box.LineBox;
import com.ibm.etools.xve.renderer.layout.box.SpacingBox;
import com.ibm.etools.xve.renderer.layout.html.BlockFlowLayout;
import com.ibm.etools.xve.renderer.layout.html.IListBoxContext;
import com.ibm.etools.xve.renderer.layout.html.IListBoxItem;
import com.ibm.etools.xve.renderer.style.Style;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;

public class WMLListBoxItemGroupLayout
extends BlockFlowLayout
implements IWmlListBoxContext,
IWmlListBoxItem {
    private final List items = new ArrayList();
    private final SpacingBox spacing_box = new SpacingBox();
    private boolean isDropDown = false;

    protected final void setupBlock() {
        if (this.items != null) {
            this.items.clear();
        }
        super.setupBlock();
        Style style = this.flowFigure.getStyle();
        boolean isWML = false;
        if (style != null) {
            isWML = style.getUIType(110) == 48;
        }
        this.isDropDown = this.isDropDownButton();
        if (!this.isDropDown || isWML) {
            this.createEmptyLine();
        }
    }

    protected final void endBlock() {
        IListBoxContext lbContext;
        try {
            lbContext = this.context.getListBoxContext();
        }
        catch (NullPointerException nullPointerException) {
            lbContext = null;
        }
        if (lbContext != null) {
            lbContext.addListBoxItem((IListBoxItem)this);
        }
        super.endBlock();
        if (!this.isDropDown) {
            List ov;
            IElementFigure cssFigure;
            try {
                cssFigure = (IElementFigure)this.flowFigure;
            }
            catch (ClassCastException classCastException) {
                cssFigure = null;
            }
            if (cssFigure != null && (ov = cssFigure.getOptionalFragments()) != null) {
                ov.add(this.spacing_box);
            }
        }
    }

    public void addToCurrentLine(LayoutBox block) {
        if (this.isDropDown && block != null && this.textIndent != 0) {
            block.translateRecursive(-this.textIndent, 0);
            block.x += this.textIndent;
        }
        super.addToCurrentLine(block);
    }

    private void createEmptyLine() {
        FontMetrics fm;
        if (this.spacing_box == null) {
            return;
        }
        if (this.flowFigure == null) {
            return;
        }
        try {
            fm = FlowUtilities.getFontMetrics((Font)this.flowFigure.getFont());
        }
        catch (NullPointerException nullPointerException) {
            fm = null;
        }
        if (fm == null) {
            return;
        }
        LineBox line = this.getCurrentLine();
        if (line == null) {
            return;
        }
        this.spacing_box.x = line.x;
        this.spacing_box.y = line.y;
        this.spacing_box.width = 0;
        Style style = this.flowFigure.getStyle();
        boolean isWML = false;
        if (style != null) {
            isWML = style.getUIType(110) == 48;
        }
        this.spacing_box.height = isWML ? 1 + fm.getLeading() : fm.getHeight() + fm.getLeading();
        this.spacing_box.setOwner((IFigure)this.flowFigure);
        this.addToCurrentLine((LayoutBox)this.spacing_box);
        this.endLine();
    }

    public IListBoxContext getListBoxContext() {
        return this;
    }

    public void addListBoxItem(IListBoxItem item) {
        if (this.items != null) {
            this.items.add(item);
        }
    }

    public boolean isDropDownButton() {
        IListBoxContext lbc;
        if (this.context != null && (lbc = this.context.getListBoxContext()) != null) {
            return lbc.isDropDownButton();
        }
        return false;
    }

    public boolean isDisabled() {
        Style style;
        boolean disabled = false;
        try {
            style = this.flowFigure.getStyle();
        }
        catch (NullPointerException nullPointerException) {
            style = null;
        }
        if (style != null) {
            if (style.getUIType(191) == 1) {
                disabled = true;
            } else {
                IListBoxContext lbContext;
                try {
                    lbContext = this.context.getListBoxContext();
                }
                catch (NullPointerException nullPointerException) {
                    lbContext = null;
                }
                if (lbContext != null) {
                    disabled = lbContext.isDisabled();
                }
            }
        }
        return disabled;
    }

    public void requestInversed(IListBoxItem item) {
        IListBoxContext lbContext;
        try {
            lbContext = this.context.getListBoxContext();
        }
        catch (NullPointerException nullPointerException) {
            lbContext = null;
        }
        if (lbContext != null) {
            lbContext.addListBoxItem(item);
        }
    }

    public void setInversed() {
    }

    public void expandListBoxItem(int width) {
        if (this.blockBox != null) {
            this.blockBox.width = width;
        }
        if (this.items == null) {
            return;
        }
        int nItems = this.items.size();
        int i = 0;
        while (i < nItems) {
            IListBoxItem item;
            try {
                item = (IListBoxItem)this.items.get(i);
            }
            catch (ClassCastException classCastException) {
                item = null;
            }
            if (item != null) {
                item.expandListBoxItem(width);
            }
            ++i;
        }
    }

    @Override
    public int getListBoxItemCount(IFigure figure) {
        if (figure == null) {
            figure = this.flowFigure;
        }
        if (figure == null) {
            return 0;
        }
        List children = figure.getChildren();
        if (children == null) {
            return 0;
        }
        int count = 0;
        int i = 0;
        while (i < children.size()) {
            IFlowFigure fig = (IFlowFigure)children.get(i);
            LayoutManager layout = fig.getLayoutManager();
            if (layout instanceof IWmlListBoxItem) {
                count += ((IWmlListBoxItem)layout).getListBoxItemCount((IFigure)fig);
            }
            ++i;
        }
        return count;
    }

    @Override
    public int getListBoxItemIndexOf(IFlowFigure figure) {
        int index = 1;
        Object fig = this.flowFigure == null ? figure.getParent() : this.flowFigure;
        LayoutManager layout = fig.getParent().getLayoutManager();
        if (layout instanceof IWmlListBoxContext) {
            index = ((IWmlListBoxContext)layout).getListBoxItemIndexOf((IFlowFigure)fig);
        }
        List children = fig.getChildren();
        int i = 0;
        while (i < children.size()) {
            IFlowFigure child = (IFlowFigure)children.get(i);
            if (figure == child) break;
            layout = child.getLayoutManager();
            if (layout instanceof IWmlListBoxItem) {
                index += ((IWmlListBoxItem)layout).getListBoxItemCount((IFigure)child);
            }
            ++i;
        }
        return index;
    }

    @Override
    public int getBulletPointSize(IFigure figure) {
        List children = figure.getChildren();
        int max = -1;
        int i = 0;
        while (i < children.size()) {
            IFigure child = (IFigure)children.get(i);
            LayoutManager layout = child.getLayoutManager();
            if (layout instanceof IWmlListBoxItem) {
                int size = ((IWmlListBoxItem)layout).getBulletPointSize(child);
                max = Math.max(max, size);
            }
            ++i;
        }
        return max;
    }

    @Override
    public int getRecommendedBulletPointSize() {
        if (this.flowFigure == null) {
            return -1;
        }
        IFigure parent = this.flowFigure.getParent();
        LayoutManager layout = parent.getLayoutManager();
        if (layout instanceof IWmlListBoxContext) {
            return ((IWmlListBoxContext)layout).getRecommendedBulletPointSize();
        }
        return -1;
    }

    protected final boolean checkLayout() {
        return true;
    }

    @Override
    public void setSelectedOption(boolean preSelected) {
    }

    @Override
    public void requestSelectedOption(IWmlListBoxItem item) {
        IFigure parent = this.flowFigure.getParent();
        if (parent == null) {
            return;
        }
        LayoutManager layout = parent.getLayoutManager();
        if (layout instanceof IWmlListBoxContext) {
            ((IWmlListBoxContext)layout).requestSelectedOption(item);
        }
    }

    @Override
    public boolean askSelected(int itemIndex) {
        IFigure parent = this.flowFigure.getParent();
        if (parent == null) {
            return false;
        }
        LayoutManager layout = parent.getLayoutManager();
        if (layout instanceof IWmlListBoxContext) {
            return ((IWmlListBoxContext)layout).askSelected(itemIndex);
        }
        return false;
    }
}

