/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.render.internal.layout;

import com.ibm.etools.xve.renderer.figures.IElementFigure;
import com.ibm.etools.xve.renderer.layout.AbstractLayoutManagerClassProvider;
import com.ibm.etools.xve.renderer.style.Style;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.draw2d.IFigure;

public class HTMLLayoutManagerClassProvider
extends AbstractLayoutManagerClassProvider {
    private static final String classNamePrefix = "com.ibm.etools.webedit.render.internal.layout.";
    private Map mapClass = new HashMap();

    public Class getLayoutManagerClass(IElementFigure figure) {
        Class<?> cl;
        String name = this.getLayoutManagerName(figure);
        if (name == null) {
            return null;
        }
        if (name.equals("VctInlineLayout") && this.isRoleOfTableModel((IFigure)figure)) {
            name = "VctTableModelLayout";
        }
        if ((cl = (Class<?>)this.mapClass.get(name)) == null) {
            try {
                cl = Class.forName(classNamePrefix + name);
                this.mapClass.put(name, cl);
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
        return cl;
    }

    private String getLayoutManagerName(IElementFigure figure) {
        if (figure == null) {
            return null;
        }
        Style style = figure.getStyle();
        if (style == null) {
            return null;
        }
        String layout = null;
        int display = style.getDisplayType();
        switch (style.getPositionType()) {
            case 2: 
            case 3: {
                if (display != 31) break;
                layout = "VctAbsoluteLayout";
                break;
            }
            case 5: 
            case 6: {
                break;
            }
            default: {
                if (display == 32) {
                    layout = "WMLCardLayout";
                    break;
                }
                if (display == 23) {
                    int uiType = style.getUIType(110);
                    if (uiType == 46) {
                        layout = "WMLTextfieldLayout";
                        break;
                    }
                    if (uiType == 47) {
                        layout = "WMLListBoxItemLayout";
                        break;
                    }
                    if (uiType == 48) {
                        layout = "WMLListBoxItemGroupLayout";
                        break;
                    }
                    if (uiType != 49) break;
                    layout = "WMLListBoxLayout";
                    break;
                }
                if (display != 31) break;
                layout = "VctInlineLayout";
            }
        }
        return layout;
    }
}

