/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.imagetool.internal.wbmp;

import com.ibm.etools.webedit.imagetool.internal.image.HandyImage;
import com.ibm.etools.webedit.imagetool.internal.image.RasterImage;
import com.ibm.etools.webedit.imagetool.internal.wbmp.WBMPImageReader;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;
import java.io.IOException;
import java.io.InputStream;

public class WBMPImageReaderDirect
extends WBMPImageReader {
    private InputStream myInput = null;

    public WBMPImageReaderDirect(InputStream input) {
        this.myInput = input;
        this.myImage = null;
    }

    @Override
    public HandyImage getImage() throws IOException {
        return this.getRaster();
    }

    @Override
    public RasterImage getRaster() throws IOException {
        if (this.myImage == null && this.myInput != null && this.myInput.available() > 4) {
            byte[] src = new byte[this.myInput.available()];
            this.myInput.mark(src.length);
            this.myInput.read(src);
            this.myInput.close();
            int offset = 2;
            int width = 0;
            int height = 0;
            while (src[offset] < 0) {
                width += 128 + src[offset];
                width *= 128;
                ++offset;
            }
            width += src[offset];
            ++offset;
            while (src[offset] < 0) {
                height += 128 + src[offset];
                height *= 128;
                ++offset;
            }
            height += src[offset];
            ++offset;
            int octetWidth = width / 8;
            if (width != 0 && height != 0) {
                int[] cmap = new int[]{-16777216, -1};
                IndexColorModel cm = new IndexColorModel(1, 2, cmap, 0, true, -1, 0);
                BufferedImage bi = new BufferedImage(width, height, 13, cm);
                DataBufferByte dbb = (DataBufferByte)bi.getRaster().getDataBuffer();
                int dp = 0;
                byte[] dst = dbb.getData();
                int ro = 0;
                while (ro < height) {
                    int co;
                    int soffset = octetWidth;
                    byte tempsrc = src[offset];
                    while (soffset > 0) {
                        tempsrc = src[offset];
                        co = 0;
                        while (co < 8) {
                            dst[dp++] = (byte)((tempsrc & 0x80) / 128);
                            tempsrc = (byte)(tempsrc << 1);
                            ++co;
                        }
                        --soffset;
                        ++offset;
                    }
                    if (src.length > offset) {
                        tempsrc = src[offset];
                    }
                    co = 0;
                    while (co < width % 8) {
                        dst[dp++] = (byte)((tempsrc & 0x80) / 128);
                        tempsrc = (byte)(tempsrc << 1);
                        ++co;
                    }
                    if (width % 8 != 0) {
                        ++offset;
                    }
                    ++ro;
                }
                this.myImage = new RasterImage(bi);
            } else {
                this.myImage = null;
            }
        }
        return this.myImage;
    }
}

