/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.imagetool.internal.mif;

import com.ibm.etools.webedit.imagetool.internal.image.ImageProperties;
import com.ibm.etools.webedit.imagetool.internal.image.RasterImage;
import com.ibm.etools.webedit.imagetool.internal.io.HandyImageReader;
import com.ibm.etools.webedit.imagetool.internal.tools.BigEndian;

public abstract class MIFSubReader
extends HandyImageReader {
    static final int myFormat = 305;
    static final int MIFPNG_CHECK_BYTES = 8;
    static final byte[] MIFPNG_MARK;

    static {
        byte[] byArray = new byte[8];
        byArray[4] = 73;
        byArray[5] = 80;
        byArray[6] = 78;
        byArray[7] = 71;
        MIFPNG_MARK = byArray;
    }

    public static boolean checkFormat(byte[] input) {
        if (input.length < 8) {
            return false;
        }
        int length = BigEndian.getInteger(input, 0);
        return length > 0 && input[4] == MIFPNG_MARK[4] && input[5] == MIFPNG_MARK[5] && input[6] == MIFPNG_MARK[6] && input[7] == MIFPNG_MARK[7];
    }

    @Override
    public int getImageFormat() {
        return 305;
    }

    @Override
    public ImageProperties getImageProperties() {
        return this.getMIFSubProperties();
    }

    public abstract ImageProperties getMIFSubProperties();

    public abstract RasterImage getRaster();
}

