/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.imagetool.internal.mif;

import com.ibm.etools.webedit.imagetool.ImageException;
import com.ibm.etools.webedit.imagetool.internal.image.HandyImage;
import com.ibm.etools.webedit.imagetool.internal.image.ImageProperties;
import com.ibm.etools.webedit.imagetool.internal.io.MIFImageReader;
import com.ibm.etools.webedit.imagetool.internal.mif.MIFImageProperties;
import com.ibm.etools.webedit.imagetool.internal.mif.MIFSubReader;
import com.ibm.etools.webedit.imagetool.internal.mif.MIFSubReaderPng;
import com.ibm.etools.webedit.imagetool.internal.tools.BigEndian;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;

public class MIFImageReaderImpl
extends MIFImageReader {
    HandyImage myImage = null;
    private MIFImageProperties myProperties = null;
    private int numObjects = 0;
    private MIFSubReader[] myObjects = null;

    public MIFImageReaderImpl(InputStream input) throws IOException, ImageException {
        int npages = MIFImageReaderImpl.getNumPages(input, false);
        if (npages < 0) {
            return;
        }
        Vector<MIFSubReader> vector = new Vector<MIFSubReader>();
        MIFSubReader sub = MIFImageReaderImpl.createSubReader(input);
        while (sub != null) {
            vector.addElement(sub);
            sub = MIFImageReaderImpl.createSubReader(input);
        }
        int nsize = vector.size();
        if (npages != 0 && npages != nsize) {
            ImageException.error(100);
        }
        this.myObjects = new MIFSubReader[nsize];
        int i = 0;
        while (i < nsize) {
            this.myObjects[i] = (MIFSubReader)vector.get(i);
            ++i;
        }
        this.numObjects = this.myObjects.length;
    }

    @Override
    public boolean ableToGetPropOnly() {
        return true;
    }

    static MIFSubReader createSubReader(InputStream input) throws IOException {
        byte[] buffer = new byte[8];
        int read = input.read(buffer);
        if (read != buffer.length) {
            return null;
        }
        int length = BigEndian.getInteger(buffer, 0);
        byte[] data = new byte[length];
        while (length > 0) {
            read = input.read(data, data.length - length, length);
            length -= read;
        }
        MIFSubReaderPng sub = null;
        if (MIFSubReaderPng.checkFormat(buffer)) {
            sub = new MIFSubReaderPng(data);
        }
        return sub;
    }

    @Override
    public HandyImage getImage() throws IOException, ImageException {
        if (this.myImage == null && this.myObjects != null) {
            this.myImage = this.myObjects[0].getImage();
        }
        return this.myImage;
    }

    @Override
    public ImageProperties getImageProperties() {
        return this.getMIFImageProperties();
    }

    public MIFImageProperties getMIFImageProperties() {
        ImageProperties subprop;
        if (this.myProperties == null && this.myObjects != null && (subprop = this.getSubProperties(0)) != null) {
            this.myProperties = new MIFImageProperties(subprop);
        }
        return this.myProperties;
    }

    @Override
    public int getNumObjects() {
        return this.numObjects;
    }

    public static int getNumPages(InputStream input, boolean reset) {
        byte[] buffer = new byte[20];
        int read = 0;
        try {
            if (reset) {
                input.mark(20);
                read = input.read(buffer);
                input.reset();
            } else {
                read = input.read(buffer);
            }
        }
        catch (IOException iOException) {
            return -1;
        }
        if (read != buffer.length || !MIFImageReaderImpl.checkFormat(buffer)) {
            return -1;
        }
        return BigEndian.getInteger(buffer, 16);
    }

    public HandyImage getSubImage(int index) throws IOException, ImageException {
        if (index < 0 || index >= this.numObjects) {
            return null;
        }
        return this.myObjects[index].getImage();
    }

    public ImageProperties getSubProperties(int index) {
        if (index < 0 || index >= this.numObjects) {
            return null;
        }
        return this.myObjects[index].getMIFSubProperties();
    }
}

