/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.imagetool.internal.jpeg;

import com.sun.image.codec.jpeg.JPEGQTable;

public class JPEGQArray {
    protected int[] myQArray = null;

    JPEGQArray(int[] qarray) {
        this.myQArray = qarray;
    }

    JPEGQArray(int[] refqarray, double magic, boolean forcebaseline) {
        this.myQArray = new int[64];
        int i = 0;
        while (i < this.myQArray.length) {
            int val = (int)((double)refqarray[i] * magic + 0.5);
            if (val <= 0) {
                val = 1;
            }
            if (val > 255 && forcebaseline) {
                val = 255;
            }
            this.myQArray[i] = val;
            ++i;
        }
    }

    JPEGQArray(JPEGQTable qtable) {
        this.myQArray = JPEGQArray.convertZigZagTo2D(qtable.getTable());
    }

    public static int[] convert2DToZigZag(int[] td) {
        return new int[]{td[0], td[1], td[8], td[16], td[9], td[2], td[3], td[10], td[17], td[24], td[32], td[25], td[18], td[11], td[4], td[5], td[12], td[19], td[26], td[33], td[40], td[48], td[41], td[34], td[27], td[20], td[13], td[6], td[7], td[14], td[21], td[28], td[35], td[42], td[49], td[56], td[57], td[50], td[43], td[36], td[29], td[22], td[15], td[23], td[30], td[37], td[44], td[51], td[58], td[59], td[52], td[45], td[38], td[31], td[39], td[46], td[53], td[60], td[61], td[54], td[47], td[55], td[62], td[63]};
    }

    public static int[] convertZigZagTo2D(int[] td) {
        return new int[]{td[0], td[1], td[5], td[6], td[14], td[15], td[27], td[28], td[2], td[4], td[7], td[13], td[16], td[26], td[29], td[42], td[3], td[8], td[12], td[17], td[25], td[30], td[41], td[43], td[9], td[11], td[18], td[24], td[31], td[40], td[44], td[53], td[10], td[19], td[23], td[32], td[39], td[45], td[52], td[54], td[20], td[22], td[33], td[38], td[46], td[51], td[55], td[60], td[21], td[34], td[37], td[47], td[50], td[56], td[59], td[61], td[35], td[36], td[48], td[49], td[57], td[58], td[62], td[63]};
    }

    public int[] createZigZagArray() {
        return JPEGQArray.convert2DToZigZag(this.myQArray);
    }

    protected int getBareQLevel() {
        int[] weight = new int[]{2, 2, 2, 2, 1, 1, 1, 1, 2, 2, 2, 2, 1, 1, 1, 1, 2, 2, 2, 2, 1, 1, 1, 1, 2, 2, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1};
        int level = 0;
        double qprod = 1.0;
        int i = 0;
        while (i < 64) {
            int j = 0;
            while (j < weight[i]) {
                qprod *= (double)this.myQArray[i];
                ++j;
            }
            while (qprod >= 2.0) {
                qprod *= 0.5;
                ++level;
            }
            ++i;
        }
        return level;
    }

    public static int getBareQLevel(int[] qarray, double magic, boolean forcebaseline) {
        JPEGQArray qtable = new JPEGQArray(qarray, magic, forcebaseline);
        return qtable.getBareQLevel();
    }

    public int[] getQArray() {
        return this.myQArray;
    }
}

