/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.imagetool.internal.jpeg;

import com.ibm.etools.webedit.imagetool.internal.image.ImageProperties;
import com.ibm.etools.webedit.imagetool.internal.image.Resolution;
import com.sun.image.codec.jpeg.JPEGDecodeParam;

public class JPEGImageProperties
extends ImageProperties {
    static final int myFormat = 4;
    private int decHSubsampling = 0;
    private int decVSubsampling = 0;
    private int decColorMode = 0;
    private boolean isProgressive = false;

    public JPEGImageProperties(JPEGDecodeParam p) {
        boolean haschroma;
        boolean valid = p.isImageInfoValid();
        if (!valid) {
            return;
        }
        this.imgEncodedWidth = p.getWidth();
        this.imgEncodedHeight = p.getHeight();
        this.imgEncodedNumComponents = p.getNumComponents();
        int type = 1;
        int bits = 24;
        this.decColorMode = p.getEncodedColorID();
        switch (this.decColorMode) {
            case 1: {
                type = 10;
                bits = 8;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 11: {
                type = 1;
                bits = 24;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                type = 2;
                bits = 32;
            }
        }
        this.imgEncodedBitCount = bits;
        this.imgOutputType = type;
        int resX = p.getXDensity();
        int resY = p.getYDensity();
        int unit = p.getDensityUnit();
        switch (unit) {
            case 1: {
                unit = 2;
                break;
            }
            case 2: {
                unit = 3;
                break;
            }
            default: {
                unit = 1;
            }
        }
        this.imgEncodedResolution = new Resolution(resX, resY, unit);
        boolean bl = haschroma = this.imgEncodedNumComponents > 1;
        if (haschroma) {
            this.decHSubsampling = p.getHorizontalSubsampling(1);
            this.decVSubsampling = p.getVerticalSubsampling(1);
        }
    }

    public int getHSubsampling() {
        return this.decHSubsampling;
    }

    @Override
    public int getImageFormat() {
        return 4;
    }

    public int getVSubsampling() {
        return this.decVSubsampling;
    }

    public boolean isProgressive() {
        return this.isProgressive;
    }
}

