/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.imagetool.internal.jpeg;

import com.ibm.etools.webedit.imagetool.internal.io.EncodingOptions;
import com.ibm.etools.webedit.imagetool.internal.jpeg.HandyJPEGQTable;
import com.ibm.etools.webedit.imagetool.internal.jpeg.JPEGImageProperties;

public class JPEGEncodingOptions
extends EncodingOptions {
    static final int myFormat = 4;
    private int encHSubsampling = 2;
    private int encVSubsampling = 1;
    private HandyJPEGQTable encLumaQTable = HandyJPEGQTable.STD_LUMA_QTABLE;
    private HandyJPEGQTable encChromaQTable = HandyJPEGQTable.STD_CHROMA_QTABLE;
    private HandyJPEGQTable refLumaQTable = HandyJPEGQTable.STD_LUMA_QTABLE;
    private HandyJPEGQTable refChromaQTable = HandyJPEGQTable.STD_CHROMA_QTABLE;
    private int encColorMode = 3;

    public JPEGEncodingOptions() {
    }

    public JPEGEncodingOptions(JPEGImageProperties prop) {
    }

    public void adjustChromaQuality(int quality, boolean forcebaseline) {
        this.encChromaQTable = this.refChromaQTable.createChromaQTable(quality, forcebaseline);
    }

    public void adjustLumaQuality(int quality, boolean forcebaseline) {
        this.encLumaQTable = this.refLumaQTable.createLumaQTable(quality, forcebaseline);
    }

    public void adjustQuality(int quality, boolean forcebaseline) {
        this.adjustLumaQuality(quality, forcebaseline);
        this.adjustChromaQuality(quality, forcebaseline);
    }

    public int[] createZigZagArray(boolean ischroma) {
        HandyJPEGQTable qtable = ischroma ? this.encChromaQTable : this.encLumaQTable;
        return qtable.createZigZagArray();
    }

    public HandyJPEGQTable getChromaQTable() {
        return this.encChromaQTable;
    }

    public int getChromaQuality() {
        return this.encChromaQTable.getQuality();
    }

    public int getEncColorMode() {
        return this.encColorMode;
    }

    public int getHSubsampling() {
        return this.encHSubsampling;
    }

    @Override
    public int getImageFormat() {
        return 4;
    }

    public HandyJPEGQTable getLumaQTable() {
        return this.encLumaQTable;
    }

    public int getLumaQuality() {
        return this.encChromaQTable.getQuality();
    }

    public int getQuality() {
        int luma = this.encLumaQTable.getQuality();
        int chroma = this.encChromaQTable.getQuality();
        int mcusize = this.encHSubsampling * this.encVSubsampling;
        switch (this.encColorMode) {
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 8: {
                return luma;
            }
        }
        return (int)((double)(luma * mcusize + chroma) / ((double)mcusize + 2.0) + 0.5);
    }

    public int getVSubsampling() {
        return this.encVSubsampling;
    }

    public void setChromaQTable(HandyJPEGQTable qtable) {
        if (qtable == null) {
            qtable = HandyJPEGQTable.STD_CHROMA_QTABLE;
        }
        this.encChromaQTable = qtable;
        this.refChromaQTable = qtable;
    }

    public void setEncColorMode(int newEncColorMode) {
        this.encColorMode = newEncColorMode;
    }

    public void setHSubsampling(int subsamp) {
        this.encHSubsampling = subsamp;
    }

    public void setLumaQTable(HandyJPEGQTable qtable) {
        if (qtable == null) {
            qtable = HandyJPEGQTable.STD_LUMA_QTABLE;
        }
        this.encLumaQTable = qtable;
        this.refLumaQTable = qtable;
    }

    public void setVSubsampling(int subsamp) {
        this.encVSubsampling = subsamp;
    }
}

