/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.imagetool.internal.image;

import com.ibm.etools.webedit.imagetool.internal.tools.DebugTool;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;

public final class ImageTool {
    public static BufferedImage blend(BufferedImage bid, int dx, int dy, int dw, int dh, BufferedImage bis, int sx, int sy, double alpha) {
        int supported = 2;
        DebugTool.assertError(supported == bid.getType());
        DebugTool.assertError(supported == bis.getType());
        DataBufferInt dbid = (DataBufferInt)bid.getRaster().getDataBuffer();
        DataBufferInt dbis = (DataBufferInt)bis.getRaster().getDataBuffer();
        int[] dst = dbid.getData();
        int[] src = dbis.getData();
        int dfw = bid.getWidth();
        int dfh = bid.getHeight();
        int sfw = bis.getWidth();
        int sfh = bis.getHeight();
        int dys = Math.max(Math.max(0, dy), dy - sy);
        int dye = Math.min(Math.min(dfh, dy + dh), sfh + dy - sy);
        int dxs = Math.max(Math.max(0, dx), dx - sx);
        int dxe = Math.min(Math.min(dfw, dx + dw), sfw + dx - sx);
        int y = dys;
        while (y < dye) {
            int doffset = y * dfw;
            int soffset = (y + dy - sy) * sfw + dx - sx;
            int x = dxs;
            while (x < dxe) {
                int result;
                int dpix = dst[doffset + x];
                int spix = src[soffset + x];
                dst[doffset + x] = result = ImageTool.blendPixel(dpix, spix, alpha);
                ++x;
            }
            ++y;
        }
        return bid;
    }

    static int blendPixel(int dpix, int spix, double alpha) {
        int ra;
        int sa = spix >> 24 & 0xFF;
        int sr = spix >> 16 & 0xFF;
        int sg = spix >> 8 & 0xFF;
        int sb = spix & 0xFF;
        int da = dpix >> 24 & 0xFF;
        int dr = dpix >> 16 & 0xFF;
        int dg = dpix >> 8 & 0xFF;
        int db = dpix & 0xFF;
        if ((sa = (int)(alpha * (double)sa + 0.5)) < 0) {
            sa = 0;
        }
        if (sa > 255) {
            sa = 255;
        }
        if ((ra = da + sa * (255 - da) / 255) <= 0) {
            return 0xFFFFFF;
        }
        int rr = dr + (sr - dr) * sa / ra;
        int rg = dg + (sg - dg) * sa / ra;
        int rb = db + (sb - db) * sa / ra;
        return ra << 24 | rr << 16 | rg << 8 | rb;
    }
}

