/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.imagetool.internal.image;

import com.ibm.etools.webedit.imagetool.internal.filter.ImageOp;
import com.ibm.etools.webedit.imagetool.internal.image.AnimContext;
import com.ibm.etools.webedit.imagetool.internal.image.Frame;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.IndexColorModel;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Display;

public abstract class HandyImage {
    public abstract HandyImage create(ImageOp var1);

    public AnimContext createAnimContext() {
        return null;
    }

    public abstract void draw(GC var1, Display var2, int var3, int var4, float var5, float var6, boolean var7);

    public int getBackgroundPixel() {
        return -1;
    }

    public BufferedImage getBufferedImage() {
        Frame hi = this.getFrame();
        return hi != null ? hi.getBufferedImage() : null;
    }

    public int getBytesPerLine() {
        switch (this.getType()) {
            case 1: 
            case 2: {
                return this.getImageWidth() * 4;
            }
            case 13: {
                return this.getImageWidth();
            }
            case 12: {
                return (this.getImageWidth() + 7) / 8;
            }
        }
        return 0;
    }

    public static int getColor(int r, int g, int b) {
        return 0xFF000000 | r << 16 | g << 8 | b;
    }

    protected int getElem(int index) {
        BufferedImage bi = this.getBufferedImage();
        int type = this.getType();
        if (type == 1 || type == 2) {
            DataBufferInt dbi = (DataBufferInt)bi.getRaster().getDataBuffer();
            return dbi.getElem(index);
        }
        if (type == 13 || type == 12) {
            DataBufferByte dbb = (DataBufferByte)bi.getRaster().getDataBuffer();
            return dbb.getElem(index);
        }
        return 0;
    }

    public abstract Frame getFrame();

    public int getHeight() {
        return this.getScreenHeight();
    }

    public int getImageHeight() {
        BufferedImage bi = this.getBufferedImage();
        return bi != null ? bi.getHeight() : 0;
    }

    public int getImageWidth() {
        BufferedImage bi = this.getBufferedImage();
        return bi != null ? bi.getWidth() : 0;
    }

    public IndexColorModel getIndexColorModel() {
        BufferedImage bi = this.getBufferedImage();
        ColorModel cm = bi != null ? bi.getColorModel() : null;
        return cm instanceof IndexColorModel ? (IndexColorModel)cm : null;
    }

    public int getMapSize() {
        IndexColorModel icm = this.getIndexColorModel();
        return icm == null ? 0 : icm.getMapSize();
    }

    public int getOffsetX() {
        Frame hi = this.getFrame();
        return hi.getOffsetX();
    }

    public int getOffsetY() {
        Frame hi = this.getFrame();
        return hi.getOffsetY();
    }

    public int getPixel(int x, int y) {
        int type = this.getType();
        int width = this.getImageWidth();
        int height = this.getImageHeight();
        BufferedImage bi = this.getBufferedImage();
        if (x < 0 || x >= width || y < 0 || y >= height) {
            return 0;
        }
        if (type == 1) {
            DataBufferInt dbi = (DataBufferInt)bi.getRaster().getDataBuffer();
            return dbi.getElem(width * y + x);
        }
        if (type == 13) {
            DataBufferByte dbb = (DataBufferByte)bi.getRaster().getDataBuffer();
            return dbb.getElem(width * y + x);
        }
        if (type == 12) {
            DataBufferByte dbb = (DataBufferByte)bi.getRaster().getDataBuffer();
            int widthbytes = (width + 7) / 8;
            int elem = dbb.getElem(widthbytes * y + x / 8);
            return elem >> 7 - x % 8 & 1;
        }
        return 0;
    }

    public int getPixelBits() {
        BufferedImage bi = this.getBufferedImage();
        if (bi != null) {
            switch (bi.getType()) {
                case 1: 
                case 2: {
                    return 32;
                }
                case 13: {
                    return 8;
                }
                case 12: {
                    return 1;
                }
            }
        }
        return 0;
    }

    public int getRepeatCount() {
        return 0;
    }

    public int getRGB(int pixel) {
        BufferedImage bi = this.getBufferedImage();
        return bi != null ? bi.getColorModel().getRGB(pixel) : 0;
    }

    protected int getScreenHeight() {
        return this.getOffsetY() + this.getImageHeight();
    }

    protected int getScreenWidth() {
        return this.getOffsetX() + this.getImageWidth();
    }

    public int getTransparentPixel() {
        IndexColorModel icm = this.getIndexColorModel();
        return icm != null ? icm.getTransparentPixel() : -1;
    }

    public int getType() {
        BufferedImage bi = this.getBufferedImage();
        return bi != null ? bi.getType() : 0;
    }

    public int getWidth() {
        return this.getScreenWidth();
    }

    public boolean isAnimation() {
        return false;
    }

    public boolean isIndexColor() {
        return this.getIndexColorModel() != null;
    }

    public void shrink() {
    }
}

