/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.imagetool.internal.image;

import com.ibm.etools.webedit.imagetool.internal.color.HeckbertQuantizer;
import com.ibm.etools.webedit.imagetool.internal.image.HandyImage;
import com.ibm.etools.webedit.imagetool.internal.image.ImageConverter;
import java.awt.image.BufferedImage;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.widgets.Display;

public abstract class Frame
extends HandyImage {
    public static final int DM_UNSPECIFIED = 0;
    public static final int DM_FILL_NONE = 1;
    public static final int DM_FILL_BACKGROUND = 2;
    public static final int DM_FILL_PREVIOUS = 3;
    private ImageData myCache = null;

    void clearCache() {
        this.myCache = null;
    }

    public ImageData createImageData() {
        ImageData image = ImageConverter.createImageData(this.getBufferedImage());
        if (image != null) {
            image.x = this.getOffsetX();
            image.y = this.getOffsetY();
            image.disposalMethod = this.getDisposalMethod();
            image.delayTime = this.getDelayTime();
        }
        return image;
    }

    @Override
    public void draw(GC gc, Display display, int ix, int iy, float xscale, float yscale, boolean transparent) {
        ImageData imageData = this.createImageData();
        if (imageData == null) {
            return;
        }
        Image paintImage = null;
        int transparentPixel = imageData.transparentPixel;
        if (transparentPixel != -1 && !transparent) {
            imageData.transparentPixel = -1;
        }
        paintImage = new Image((Device)display, imageData);
        gc.drawImage(paintImage, 0, 0, imageData.width, imageData.height, ix + Math.round((float)imageData.x * xscale), iy + Math.round((float)imageData.y * yscale), Math.round((float)imageData.width * xscale), Math.round((float)imageData.height * yscale));
        if (transparentPixel != -1 && !transparent) {
            imageData.transparentPixel = transparentPixel;
        }
        paintImage.dispose();
    }

    public void draw(GC gc, Display display, int ix, int iy, int clipx, int clipy, int clipw, int cliph, double xzoom, double yzoom, boolean forceOpaque) {
        if (this.myCache == null) {
            this.myCache = this.createImageData();
        }
        if (this.myCache == null) {
            return;
        }
        int sx = 0;
        int sy = 0;
        int sw = this.myCache.width;
        int sh = this.myCache.height;
        int dx = ix + (int)Math.round((double)this.myCache.x * xzoom);
        int dy = iy + (int)Math.round((double)this.myCache.y * yzoom);
        int dw = (int)Math.round((double)sw * xzoom);
        int dh = (int)Math.round((double)sh * yzoom);
        if (dx < clipx) {
            sx = (int)Math.round((double)(clipx - dx) / xzoom);
            dx = clipx;
            dw = (int)Math.round((double)(sw -= sx) * xzoom);
        }
        if (dy < clipy) {
            sy = (int)Math.round((double)(clipy - dy) / yzoom);
            dy = clipy;
            dh = (int)Math.round((double)(sh -= sy) * yzoom);
        }
        if (clipw > 0 && dw > clipw) {
            sw -= (int)Math.round((double)(dw - clipw) / xzoom);
            dw = clipw;
        }
        if (cliph > 0 && dh > cliph) {
            sh -= (int)Math.round((double)(dh - cliph) / yzoom);
            dh = cliph;
        }
        if (sw <= 0 || sh <= 0) {
            return;
        }
        int transparentPixel = this.myCache.transparentPixel;
        int alpha = this.myCache.alpha;
        byte[] alphaData = this.myCache.alphaData;
        if (forceOpaque) {
            this.myCache.transparentPixel = -1;
            this.myCache.alpha = -1;
            this.myCache.alphaData = null;
        }
        Image paintImage = new Image((Device)display, this.myCache);
        gc.drawImage(paintImage, sx, sy, sw, sh, dx, dy, dw, dh);
        if (forceOpaque) {
            this.myCache.transparentPixel = transparentPixel;
            this.myCache.alpha = alpha;
            this.myCache.alphaData = alphaData;
        }
        paintImage.dispose();
    }

    public int getAverageColor() {
        BufferedImage bi = this.getBufferedImage();
        HeckbertQuantizer hq = new HeckbertQuantizer();
        hq.reset();
        hq.prescan(bi, null);
        int[] colors = hq.selectColors(1);
        return colors[0];
    }

    public int getDelayTime() {
        return 0;
    }

    public int getDisposalMethod() {
        return 0;
    }

    public boolean hasTransparentPart() {
        return false;
    }

    public boolean isOpaque() {
        return false;
    }
}

