/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.imagetool.internal.image;

import com.ibm.etools.webedit.imagetool.internal.filter.ImageOp;
import com.ibm.etools.webedit.imagetool.internal.image.AnimContext;
import com.ibm.etools.webedit.imagetool.internal.image.Frame;
import com.ibm.etools.webedit.imagetool.internal.image.HandyImage;
import com.ibm.etools.webedit.imagetool.internal.image.IAnimation;
import com.ibm.etools.webedit.imagetool.internal.image.RasterImage;
import java.awt.Dimension;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.widgets.Display;

public class AnimImage
extends HandyImage
implements IAnimation {
    private RasterImage[] animFrames = null;
    private int animIndex = 0;
    private int fBgPixIndex = -1;
    private int screenWidth = 0;
    private int screenHeight = 0;
    private int fRepeatCnt = 0;

    public AnimImage(RasterImage[] frames, Dimension2D scrnsize, int bkIndex, int repeat) {
        this.animFrames = frames;
        this.fBgPixIndex = bkIndex;
        this.screenWidth = (int)scrnsize.getWidth();
        this.screenHeight = (int)scrnsize.getHeight();
        this.fRepeatCnt = repeat;
    }

    public AnimImage(ImageData[] image, ImageLoader loader) {
        int num = image == null ? 0 : image.length;
        this.animFrames = new RasterImage[num];
        int i = 0;
        while (i < num) {
            this.animFrames[i] = new RasterImage(image[i]);
            ++i;
        }
        if (loader != null) {
            this.fBgPixIndex = loader.backgroundPixel;
            this.screenWidth = loader.logicalScreenWidth;
            this.screenHeight = loader.logicalScreenHeight;
            this.fRepeatCnt = loader.repeatCount;
        }
    }

    @Override
    public HandyImage create(ImageOp operation) {
        int n = this.getNumFrames();
        int scrw = this.getScreenWidth();
        int scrh = this.getScreenHeight();
        Dimension scrnSize = new Dimension(scrw, scrh);
        RasterImage[] fia = new RasterImage[n];
        int i = 0;
        while (i < n) {
            RasterImage fi = this.getRaster(i);
            fia[i] = operation.create(fi, scrnSize);
            ++i;
        }
        Dimension2D dsize = operation.getOperatedSize(scrnSize);
        return new AnimImage(fia, dsize, this.getBackgroundPixel(), this.getRepeatCount());
    }

    @Override
    public AnimContext createAnimContext() {
        return new AnimContext(this);
    }

    @Override
    public void draw(GC gc, Display display, int ix, int iy, float xscale, float yscale, boolean transparent) {
        Frame fi = this.getFrame();
        fi.draw(gc, display, ix, iy, xscale, yscale, transparent);
    }

    @Override
    public int getBackgroundPixel() {
        return this.fBgPixIndex;
    }

    public Rectangle2D getBoundsRect() {
        int n = this.getNumFrames();
        RasterImage fi = this.getRaster(0);
        Rectangle2D bounds = fi.getImageRect();
        int i = 1;
        while (i < n) {
            fi = this.getRaster(i);
            bounds = bounds.createUnion(fi.getImageRect());
            ++i;
        }
        return bounds;
    }

    @Override
    public Frame getFrame() {
        return this.getRaster();
    }

    public Frame getFrame(int index) {
        if (this.animFrames == null || index >= this.animFrames.length) {
            return null;
        }
        return this.animFrames[index];
    }

    @Override
    public int getFrameIndex() {
        return this.animIndex;
    }

    @Override
    public int getNumFrames() {
        return this.animFrames == null ? 0 : this.animFrames.length;
    }

    public RasterImage getRaster() {
        return this.getRaster(this.getFrameIndex());
    }

    public RasterImage getRaster(int index) {
        if (this.animFrames == null || index >= this.animFrames.length) {
            return null;
        }
        return this.animFrames[index];
    }

    @Override
    public int getRepeatCount() {
        return this.fRepeatCnt;
    }

    @Override
    public int getScreenHeight() {
        return this.screenHeight;
    }

    @Override
    public int getScreenWidth() {
        return this.screenWidth;
    }

    @Override
    public boolean isAnimation() {
        return this.getNumFrames() > 1;
    }

    public synchronized void seekFrame(int index) {
        this.animIndex = index >= 0 && index < this.getNumFrames() ? index : 0;
    }

    public synchronized void seekFrameNext() {
        ++this.animIndex;
        if (this.animIndex >= this.animFrames.length) {
            this.animIndex = 0;
        }
    }

    public synchronized void seekFramePrevious() {
        --this.animIndex;
        if (this.animIndex < 0) {
            this.animIndex = this.animFrames.length - 1;
        }
    }

    @Override
    public void shrink() {
        Rectangle2D bounds = this.getBoundsRect();
        double bl = bounds.getMinX();
        double bt = bounds.getMinY();
        double br = bounds.getMaxX();
        double bb = bounds.getMaxY();
        this.translate((int)(-bl), (int)(-bt));
        this.screenWidth = (int)(br - bl);
        this.screenHeight = (int)(bb - bt);
    }

    public void translate(int x, int y) {
        int n = this.getNumFrames();
        int i = 0;
        while (i < n) {
            RasterImage fi = this.getRaster(i);
            fi.translate(x, y);
            ++i;
        }
    }
}

