/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.imagetool.internal.image;

import com.ibm.etools.webedit.imagetool.internal.image.AnimImage;
import com.ibm.etools.webedit.imagetool.internal.image.AnimListener;
import com.ibm.etools.webedit.imagetool.internal.image.Frame;
import com.ibm.etools.webedit.imagetool.internal.image.HandyImageObserver;
import com.ibm.etools.webedit.imagetool.internal.image.RasterImage;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Display;

public class AnimContext {
    private Thread fThread = null;
    private AnimImage fAnimImage = null;
    private boolean fAnimate = false;
    private int fIndex = 0;
    private GC fGC = null;
    private Display fDisplay = null;
    private int fX = 0;
    private int fY = 0;
    private int fBgRgb = -1;
    private AnimListener fAnimListener = null;

    public AnimContext(AnimImage anim) {
        this.fAnimImage = anim;
    }

    public int getBackgroundPixel() {
        return this.fAnimImage != null ? this.fAnimImage.getBackgroundPixel() : 0;
    }

    public BufferedImage getBufferedImage() {
        Frame hi = this.getCurrentFrame();
        return hi.getBufferedImage();
    }

    public Frame getCurrentFrame() {
        return this.getFrame(this.fIndex);
    }

    public int getDelayTime() {
        Frame fi = this.getCurrentFrame();
        return fi.getDelayTime();
    }

    public int getDisposalMethod() {
        Frame fi = this.getCurrentFrame();
        return fi.getDisposalMethod();
    }

    public Frame getFrame(int index) {
        return this.fAnimImage != null ? this.fAnimImage.getFrame(index) : null;
    }

    public int getFrameIndex() {
        return this.fIndex;
    }

    public int getImageHeight() {
        Frame hi = this.getCurrentFrame();
        return hi.getImageHeight();
    }

    public int getImageWidth() {
        Frame hi = this.getCurrentFrame();
        return hi.getImageWidth();
    }

    public IndexColorModel getIndexColorModel() {
        Frame hi = this.getCurrentFrame();
        return hi != null ? hi.getIndexColorModel() : null;
    }

    public int getNumFrames() {
        return this.fAnimImage != null ? this.fAnimImage.getNumFrames() : 0;
    }

    public int getOffsetX() {
        Frame hi = this.getCurrentFrame();
        return hi.getOffsetX();
    }

    public int getOffsetY() {
        Frame hi = this.getCurrentFrame();
        return hi.getOffsetY();
    }

    public int getRepeatCount() {
        return this.fAnimImage != null ? this.fAnimImage.getRepeatCount() : 0;
    }

    public int getScreenHeight() {
        return this.fAnimImage != null ? this.fAnimImage.getScreenHeight() : 0;
    }

    public int getScreenWidth() {
        return this.fAnimImage != null ? this.fAnimImage.getScreenWidth() : 0;
    }

    public synchronized void seekFrame(int index) {
        this.fIndex = index >= 0 && index < this.getNumFrames() ? index : 0;
    }

    public synchronized void seekFrameNext() {
        ++this.fIndex;
        if (this.fIndex >= this.getNumFrames()) {
            this.fIndex = 0;
        }
    }

    public synchronized void seekFramePrevious() {
        --this.fIndex;
        if (this.fIndex < 0) {
            this.fIndex = this.getNumFrames() - 1;
        }
    }

    public void startAnimate(HandyImageObserver observer, int bgRgb) {
        if (this.fAnimImage == null) {
            return;
        }
        this.fAnimate = true;
        this.fIndex = this.fAnimImage.getFrameIndex();
        int screenW = this.getScreenWidth();
        int screenH = this.getScreenHeight();
        BufferedImage offScreenBuf = new BufferedImage(screenW, screenH, 2);
        Graphics2D offScreenGC = offScreenBuf.createGraphics();
        RasterImage offScreenImage = new RasterImage(offScreenBuf, false);
        BufferedImage prevBuf = new BufferedImage(screenW, screenH, 2);
        Graphics2D prevGC = prevBuf.createGraphics();
        offScreenGC.setBackground(new Color(bgRgb));
        offScreenGC.clearRect(0, 0, screenW, screenH);
        int repeatCount = this.getRepeatCount();
        while (this.fAnimate && (this.getRepeatCount() == 0 || repeatCount > 0)) {
            int disposalMethod = this.getDisposalMethod();
            if (disposalMethod == 3) {
                prevGC.drawImage(offScreenBuf, null, 0, 0);
            }
            offScreenGC.drawImage(this.getBufferedImage(), null, this.getOffsetX(), this.getOffsetY());
            observer.updateImage(offScreenImage);
            try {
                int msDelay = this.getDelayTime() * 10;
                msDelay = msDelay < 30 ? 30 : msDelay;
                Thread.sleep(msDelay);
            }
            catch (InterruptedException interruptedException) {
                this.fAnimate = false;
            }
            if (disposalMethod == 2) {
                int bgPixel = this.getBackgroundPixel();
                IndexColorModel icm = this.getIndexColorModel();
                int bgColor = bgPixel >= 0 && icm != null ? icm.getRGB(bgPixel) : bgRgb;
                offScreenGC.setBackground(new Color(bgColor));
                offScreenGC.clearRect(this.getOffsetX(), this.getOffsetY(), this.getImageWidth(), this.getImageHeight());
            } else if (disposalMethod == 3) {
                offScreenGC.drawImage(prevBuf, null, 0, 0);
            }
            this.seekFrameNext();
            if (this.getFrameIndex() != 0) continue;
            --repeatCount;
        }
        if (this.fAnimListener != null) {
            this.fAnimListener.terminated();
            this.fAnimListener = null;
        }
    }

    public synchronized void startPlay(GC gc, Display display, int x, int y, int bgRgb, AnimListener listener) {
        if (this.fAnimImage == null) {
            return;
        }
        this.fGC = gc;
        this.fDisplay = display;
        this.fX = x;
        this.fY = y;
        this.fBgRgb = bgRgb;
        this.fAnimListener = listener;
        this.fThread = new Thread("Animation"){

            @Override
            public void run() {
                HandyImageObserver observer = new HandyImageObserver(){

                    @Override
                    public void updateImage(Frame fi) {
                        fi.draw(AnimContext.this.fGC, AnimContext.this.fDisplay, AnimContext.this.fX, AnimContext.this.fY, 1.0f, 1.0f, false);
                    }
                };
                AnimContext.this.startAnimate(observer, AnimContext.this.fBgRgb);
            }
        };
        this.fThread.start();
    }

    public synchronized void stopAnimate(boolean syncFrame) {
        this.fAnimate = false;
        if (syncFrame && this.fAnimImage != null) {
            this.fAnimImage.seekFrame(this.fIndex);
        }
    }

    public synchronized void stopPlay(boolean syncFrame) {
        this.stopAnimate(syncFrame);
        this.fThread = null;
    }
}

