/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.imagetool.internal.filter;

import com.ibm.etools.webedit.imagetool.internal.filter.TransformOp;
import com.ibm.etools.webedit.imagetool.internal.image.ImageError;
import com.ibm.etools.webedit.imagetool.internal.image.RasterImage;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;

public class TranslateOp
extends TransformOp {
    private Point2D scrollVector = null;

    public TranslateOp() {
        this(0.0, 0.0);
    }

    public TranslateOp(double sx, double sy) {
        super(0);
        this.scrollVector = new Point2D.Double(sx, sy);
    }

    public TranslateOp(Point2D vec) {
        this(vec.getX(), vec.getY());
    }

    @Override
    public RasterImage create(RasterImage fi, Dimension2D scrnSize) {
        BufferedImage bi;
        BufferedImage bid = bi = fi.getBufferedImage();
        double x = this.scrollVector.getX() + (double)fi.getOffsetX();
        double y = this.scrollVector.getY() + (double)fi.getOffsetY();
        Point2D.Double pos = new Point2D.Double(x, y);
        return new RasterImage(bid, pos, fi.getDelayTime(), fi.getDisposalMethod(), fi.isGray());
    }

    public BufferedImage create(BufferedImage bi) {
        int bw = bi.getWidth();
        int bh = bi.getHeight();
        BufferedImage bid = this.createCompatible(bi, bw, bh);
        return this.filter(bi, bid);
    }

    public BufferedImage filter(BufferedImage bi, BufferedImage bid) {
        if (bi == bid) {
            ImageError.error(1);
        }
        double sx = this.scrollVector.getX();
        double sy = this.scrollVector.getY();
        AffineTransform scroll = AffineTransform.getTranslateInstance(sx, sy);
        AffineTransformOp op = new AffineTransformOp(scroll, 1);
        return op.filter(bi, bid);
    }
}

