/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.imagetool.internal.filter;

import com.ibm.etools.webedit.imagetool.internal.filter.TransformOp;
import com.ibm.etools.webedit.imagetool.internal.image.ImageError;
import com.ibm.etools.webedit.imagetool.internal.image.RasterImage;
import java.awt.Dimension;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;

public class OrientOp
extends TransformOp {
    public static final int ROTATE_NONE_EVEN = 0;
    public static final int ROTATE_LEFT_EVEN = 1;
    public static final int ROTATE_180_EVEN = 2;
    public static final int ROTATE_RIGHT_EVEN = 3;
    public static final int ROTATE_NONE_ODD = 4;
    public static final int ROTATE_LEFT_ODD = 5;
    public static final int ROTATE_180_ODD = 6;
    public static final int ROTATE_RIGHT_ODD = 7;
    private int orientType = 0;

    public OrientOp(int orientation) {
        super(0);
        this.orientType = orientation;
    }

    @Override
    public RasterImage create(RasterImage fi, Dimension2D scrnSize) {
        BufferedImage bis = fi.getBufferedImage();
        BufferedImage bid = this.create(bis);
        Rectangle2D rect = this.getImageRect(fi.getImageRect(), scrnSize);
        Point2D.Double pos = new Point2D.Double(rect.getX(), rect.getY());
        return new RasterImage(bid, pos, fi.getDelayTime(), fi.getDisposalMethod(), fi.isGray());
    }

    public BufferedImage create(BufferedImage bi) {
        int w = bi.getWidth();
        int h = bi.getHeight();
        double[] matrix = OrientOp.getOrientMatrix(w, h, this.orientType);
        AffineTransform at = new AffineTransform(matrix);
        AffineTransformOp ato = new AffineTransformOp(at, 1);
        BufferedImage bid = ato.filter(bi, null);
        bid.getType();
        return bid;
    }

    public Rectangle2D getImageRect(Rectangle2D rect, Dimension2D scrnSize) {
        double x = rect.getX();
        double y = rect.getY();
        double w = rect.getWidth();
        double h = rect.getHeight();
        double scrnw = x + w;
        double scrnh = y + h;
        if (scrnSize != null) {
            scrnw = scrnSize.getWidth();
            scrnh = scrnSize.getHeight();
        }
        double rx = x;
        double ry = y;
        double rw = w;
        double rh = h;
        switch (this.orientType) {
            case 0: {
                break;
            }
            case 4: {
                rx = scrnw - x - w;
                break;
            }
            case 2: {
                rx = scrnw - x - w;
                ry = scrnh - y - h;
                break;
            }
            case 6: {
                y = scrnh - y - h;
                break;
            }
            case 1: {
                rx = y;
                ry = scrnw - x - w;
                break;
            }
            case 5: {
                rx = y;
                ry = x;
                break;
            }
            case 3: {
                rx = scrnh - y - h;
                ry = x;
                break;
            }
            case 7: {
                rx = scrnh - y - h;
                ry = scrnw - x - w;
                break;
            }
            default: {
                ImageError.error(1);
            }
        }
        switch (this.orientType) {
            case 1: 
            case 3: 
            case 5: 
            case 7: {
                rw = h;
                rh = w;
            }
        }
        return new Rectangle2D.Double(rx, ry, rw, rh);
    }

    @Override
    public Dimension2D getOperatedSize(int width, int height) {
        boolean swap = false;
        switch (this.orientType) {
            case 0: 
            case 2: 
            case 4: 
            case 6: {
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: {
                swap = true;
                break;
            }
            default: {
                ImageError.error(1);
            }
        }
        return swap ? new Dimension(height, width) : new Dimension(width, height);
    }

    static double[] getOrientMatrix(int width, int height, int orientation) {
        double[] matrix = null;
        switch (orientation) {
            case 0: {
                matrix = new double[]{1.0, 0.0, 0.0, 1.0, 0.0, 0.0};
                break;
            }
            case 1: {
                matrix = new double[]{0.0, -1.0, 1.0, 0.0, 0.0, width};
                break;
            }
            case 2: {
                matrix = new double[]{-1.0, 0.0, 0.0, -1.0, width, height};
                break;
            }
            case 3: {
                matrix = new double[]{0.0, 1.0, -1.0, 0.0, height, 0.0};
                break;
            }
            case 4: {
                matrix = new double[]{-1.0, 0.0, 0.0, 1.0, width, 0.0};
                break;
            }
            case 5: {
                matrix = new double[]{0.0, 1.0, 1.0, 0.0, 0.0, 0.0};
                break;
            }
            case 6: {
                matrix = new double[]{1.0, 0.0, 0.0, -1.0, 0.0, height};
                break;
            }
            case 7: {
                matrix = new double[]{0.0, -1.0, -1.0, 0.0, height, width};
            }
        }
        return matrix;
    }
}

