/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.imagetool.internal.filter;

import com.ibm.etools.webedit.imagetool.internal.filter.IndexImageOp;
import com.ibm.etools.webedit.imagetool.internal.filter.LineOp;
import com.ibm.etools.webedit.imagetool.internal.filter.PixelA;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.IndexColorModel;
import java.awt.image.Kernel;

class LineOpI
implements LineOp {
    private boolean isDstOpaq = false;

    LineOpI(boolean opaqdst) {
        this.isDstOpaq = opaqdst;
    }

    @Override
    public void filterBiCubic(BufferedImage bi, BufferedImage bid, int dx, int dw, int dy, double[] fx, double[] fy, int[] ix, int[] iy) {
        IndexColorModel icm = (IndexColorModel)bi.getColorModel();
        DataBufferByte sdbb = (DataBufferByte)bi.getRaster().getDataBuffer();
        DataBufferInt ddbi = (DataBufferInt)bid.getRaster().getDataBuffer();
        byte[] src = sdbb.getData();
        int[] dst = ddbi.getData();
        int srcw = bi.getWidth();
        int dstw = bid.getWidth();
        int is = ix[0];
        int ie = ix[dw * 4 - 1] + 1;
        PixelA[] work = new PixelA[ie - is];
        int x = is;
        while (x < ie) {
            PixelA v = new PixelA();
            v.addI(icm, src[iy[0] * srcw + x] & 0xFF, fy[0]);
            v.addI(icm, src[iy[1] * srcw + x] & 0xFF, fy[1]);
            v.addI(icm, src[iy[2] * srcw + x] & 0xFF, fy[2]);
            v.addI(icm, src[iy[3] * srcw + x] & 0xFF, fy[3]);
            work[x - is] = v;
            ++x;
        }
        int de = dx + dw;
        int x2 = dx;
        while (x2 < de) {
            PixelA sum = new PixelA();
            int x4 = x2 * 4;
            sum.addA(work[ix[x4 + 0] - is], fx[x2 * 4 + 0]);
            sum.addA(work[ix[x4 + 1] - is], fx[x2 * 4 + 1]);
            sum.addA(work[ix[x4 + 2] - is], fx[x2 * 4 + 2]);
            sum.addA(work[ix[x4 + 3] - is], fx[x2 * 4 + 3]);
            dst[dy * dstw + x2] = this.isDstOpaq ? sum.getR() : sum.getA();
            ++x2;
        }
    }

    @Override
    public void filterBiLinear(BufferedImage bi, BufferedImage bid, int dx, int dw, int dy, double[] fx, double[] fy, int[] ix, int[] iy) {
        IndexColorModel icm = (IndexColorModel)bi.getColorModel();
        DataBufferByte sdbb = (DataBufferByte)bi.getRaster().getDataBuffer();
        DataBufferInt ddbi = (DataBufferInt)bid.getRaster().getDataBuffer();
        byte[] src = sdbb.getData();
        int[] dst = ddbi.getData();
        int srcw = bi.getWidth();
        int dstw = bid.getWidth();
        int is = ix[0];
        int ie = ix[dw * 2 - 1] + 1;
        PixelA[] work = new PixelA[ie - is];
        int x = is;
        while (x < ie) {
            PixelA v = new PixelA();
            v.addI(icm, src[iy[0] * srcw + x] & 0xFF, fy[0]);
            v.addI(icm, src[iy[1] * srcw + x] & 0xFF, fy[1]);
            work[x - is] = v;
            ++x;
        }
        int de = dx + dw;
        int x2 = dx;
        while (x2 < de) {
            PixelA sum = new PixelA();
            int x22 = x2 * 2;
            sum.addA(work[ix[x22 + 0] - is], fx[x22 + 0]);
            sum.addA(work[ix[x22 + 1] - is], fx[x22 + 1]);
            dst[dy * dstw + x2] = this.isDstOpaq ? sum.getR() : sum.getA();
            ++x2;
        }
    }

    @Override
    public void filterConvolute(BufferedImage bi, BufferedImage bid, int dx, int dw, int dy, double[] hk, double[] vk) {
        PixelA sum;
        int kw = hk.length;
        int kh = vk.length;
        int cx = kw / 2;
        int cy = kh / 2;
        IndexColorModel icm = (IndexColorModel)bi.getColorModel();
        DataBufferByte sdbb = (DataBufferByte)bi.getRaster().getDataBuffer();
        DataBufferInt ddbi = (DataBufferInt)bid.getRaster().getDataBuffer();
        byte[] src = sdbb.getData();
        int[] dst = ddbi.getData();
        int srcw = bi.getWidth();
        int dstw = bid.getWidth();
        int srch = bi.getHeight();
        PixelA[] tmp = new PixelA[dstw];
        int de = dx + dw;
        int co = dx;
        while (co < de) {
            sum = new PixelA();
            int y = 0;
            while (y < kh) {
                int sy = dy + y - cy;
                if (sy >= 0) {
                    if (sy >= srch) break;
                    sum.addI(icm, src[sy * srcw + co], vk[y]);
                }
                ++y;
            }
            tmp[co] = sum;
            ++co;
        }
        co = dx;
        while (co < de) {
            sum = new PixelA();
            int x = 0;
            while (x < kw) {
                int sx = co + x - cx;
                if (sx >= 0) {
                    if (sx >= srcw) break;
                    sum.addA(tmp[sx], hk[x]);
                }
                ++x;
            }
            dst[dy * dstw + co] = this.isDstOpaq ? sum.getR() : sum.getA();
            ++co;
        }
    }

    @Override
    public void filterConvolute(BufferedImage bi, BufferedImage bid, int dx, int dw, int dy, Kernel k) {
        IndexColorModel icm = (IndexColorModel)bi.getColorModel();
        DataBufferByte sdbb = (DataBufferByte)bi.getRaster().getDataBuffer();
        DataBufferInt ddbi = (DataBufferInt)bid.getRaster().getDataBuffer();
        byte[] src = sdbb.getData();
        int[] dst = ddbi.getData();
        int srcw = bi.getWidth();
        int dstw = bid.getWidth();
        int srch = bi.getHeight();
        int cx = k.getXOrigin();
        int cy = k.getYOrigin();
        int kw = k.getWidth();
        int kh = k.getHeight();
        float[] data = k.getKernelData(null);
        int de = dx + dw;
        int co = dx;
        while (co < de) {
            PixelA sum = new PixelA();
            int y = 0;
            int i = 0;
            while (y < kh) {
                int sy = dy + y - cy;
                if (sy >= 0) {
                    if (sy >= srch) break;
                    int x = 0;
                    while (x < kw) {
                        int sx = co + x - cx;
                        if (sx >= 0) {
                            if (sx >= srcw) break;
                            sum.addI(icm, src[sy * srcw + sx], data[y * kw + x]);
                        }
                        ++x;
                    }
                }
                ++y;
                ++i;
            }
            dst[dy * dstw + co] = this.isDstOpaq ? sum.getR() : sum.getA();
            ++co;
        }
    }

    @Override
    public void filterZoomDown(BufferedImage bi, BufferedImage bid, int dx, int dw, int dy, double[] fx, double[] fy, int[] ix, int[] iy, double zx, double zy) {
        IndexColorModel icm = (IndexColorModel)bi.getColorModel();
        new IndexImageOp(icm);
        DataBufferByte sdbb = (DataBufferByte)bi.getRaster().getDataBuffer();
        DataBufferInt ddbi = (DataBufferInt)bid.getRaster().getDataBuffer();
        byte[] src = sdbb.getData();
        int[] dst = ddbi.getData();
        int srcw = bi.getWidth();
        int dstw = bid.getWidth();
        double ww = zx * zy;
        int de = dx + dw;
        int x = dx;
        while (x < de) {
            PixelA sum = new PixelA();
            int j = iy[0] + 1;
            while (j < iy[1]) {
                int i = ix[x * 2] + 1;
                while (i < ix[x * 2 + 1]) {
                    sum.addI(icm, src[j * srcw + i] & 0xFF, ww);
                    ++i;
                }
                sum.addI(icm, src[j * srcw + ix[x * 2]] & 0xFF, fx[x * 2] * zy);
                sum.addI(icm, src[j * srcw + ix[x * 2 + 1]] & 0xFF, fx[x * 2 + 1] * zy);
                ++j;
            }
            int i = ix[x * 2] + 1;
            while (i < ix[x * 2 + 1]) {
                sum.addI(icm, src[iy[0] * srcw + i] & 0xFF, fy[0] * zx);
                sum.addI(icm, src[iy[1] * srcw + i] & 0xFF, fy[1] * zx);
                ++i;
            }
            sum.addI(icm, src[iy[0] * srcw + ix[x * 2]] & 0xFF, fy[0] * fx[x * 2]);
            sum.addI(icm, src[iy[0] * srcw + ix[x * 2 + 1]] & 0xFF, fy[0] * fx[x * 2 + 1]);
            sum.addI(icm, src[iy[1] * srcw + ix[x * 2]] & 0xFF, fy[1] * fx[x * 2]);
            sum.addI(icm, src[iy[1] * srcw + ix[x * 2 + 1]] & 0xFF, fy[1] * fx[x * 2 + 1]);
            dst[dy * dstw + x] = this.isDstOpaq ? sum.getR() : sum.getA();
            ++x;
        }
    }

    @Override
    public int[] getLeftRightEdge(BufferedImage bi, int y) {
        DataBufferByte sdbb = (DataBufferByte)bi.getRaster().getDataBuffer();
        IndexColorModel icm = (IndexColorModel)bi.getColorModel();
        byte[] src = sdbb.getData();
        int srcw = bi.getWidth();
        int x = 0;
        while (x < srcw) {
            int alpha = icm.getAlpha(src[y * srcw + x] & 0xFF);
            if (alpha != 0) break;
            ++x;
        }
        if (x >= srcw) {
            return new int[2];
        }
        int left = x;
        int right = x;
        while (x < srcw) {
            int alpha = icm.getAlpha(src[y * srcw + x] & 0xFF);
            if (alpha != 0) {
                right = x;
            }
            ++x;
        }
        return new int[]{left, right + 1};
    }
}

