/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.imagetool.internal.filter;

import com.ibm.etools.webedit.imagetool.internal.filter.LineOp;
import com.ibm.etools.webedit.imagetool.internal.filter.PixelA;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.Kernel;

public class LineOpA
implements LineOp {
    private boolean isDstOpaq = false;

    LineOpA(boolean opaqdst) {
        this.isDstOpaq = opaqdst;
    }

    @Override
    public void filterBiCubic(BufferedImage bi, BufferedImage bid, int dx, int dw, int dy, double[] fx, double[] fy, int[] ix, int[] iy) {
        DataBufferInt sdbi = (DataBufferInt)bi.getRaster().getDataBuffer();
        DataBufferInt ddbi = (DataBufferInt)bid.getRaster().getDataBuffer();
        int[] src = sdbi.getData();
        int[] dst = ddbi.getData();
        int srcw = bi.getWidth();
        int dstw = bid.getWidth();
        int is = ix[0];
        int ie = ix[dw * 4 - 1] + 1;
        PixelA[] work = new PixelA[ie - is];
        int x = is;
        while (x < ie) {
            PixelA v = new PixelA();
            v.addA(src[iy[0] * srcw + x], fy[0]);
            v.addA(src[iy[1] * srcw + x], fy[1]);
            v.addA(src[iy[2] * srcw + x], fy[2]);
            v.addA(src[iy[3] * srcw + x], fy[3]);
            work[x - is] = v;
            ++x;
        }
        int de = dx + dw;
        int x2 = dx;
        while (x2 < de) {
            PixelA sum = new PixelA();
            int x4 = x2 * 4;
            sum.addA(work[ix[x4 + 0] - is], fx[x2 * 4 + 0]);
            sum.addA(work[ix[x4 + 1] - is], fx[x2 * 4 + 1]);
            sum.addA(work[ix[x4 + 2] - is], fx[x2 * 4 + 2]);
            sum.addA(work[ix[x4 + 3] - is], fx[x2 * 4 + 3]);
            dst[dy * dstw + x2] = this.isDstOpaq ? sum.getR() : sum.getA();
            ++x2;
        }
    }

    @Override
    public void filterBiLinear(BufferedImage bi, BufferedImage bid, int dx, int dw, int dy, double[] fx, double[] fy, int[] ix, int[] iy) {
        DataBufferInt sdbi = (DataBufferInt)bi.getRaster().getDataBuffer();
        DataBufferInt ddbi = (DataBufferInt)bid.getRaster().getDataBuffer();
        int[] src = sdbi.getData();
        int[] dst = ddbi.getData();
        int srcw = bi.getWidth();
        int dstw = bid.getWidth();
        int is = ix[0];
        int ie = ix[dw * 2 - 1] + 1;
        PixelA[] work = new PixelA[ie - is];
        int x = is;
        while (x < ie) {
            PixelA v = new PixelA();
            v.addA(src[iy[0] * srcw + x], fy[0]);
            v.addA(src[iy[1] * srcw + x], fy[1]);
            work[x - is] = v;
            ++x;
        }
        int de = dx + dw;
        int x2 = dx;
        while (x2 < de) {
            PixelA sum = new PixelA();
            int x22 = x2 * 2;
            sum.addA(work[ix[x22 + 0] - is], fx[x22 + 0]);
            sum.addA(work[ix[x22 + 1] - is], fx[x22 + 1]);
            dst[dy * dstw + x2] = this.isDstOpaq ? sum.getR() : sum.getA();
            ++x2;
        }
    }

    @Override
    public void filterConvolute(BufferedImage bi, BufferedImage bid, int dx, int dw, int dy, double[] hk, double[] vk) {
        int kw = hk.length;
        int kh = vk.length;
        int cx = kw / 2;
        int cy = kh / 2;
        DataBufferInt sdbi = (DataBufferInt)bi.getRaster().getDataBuffer();
        DataBufferInt ddbi = (DataBufferInt)bid.getRaster().getDataBuffer();
        int[] src = sdbi.getData();
        int[] dst = ddbi.getData();
        int srcw = bi.getWidth();
        int dstw = bid.getWidth();
        int srch = bi.getHeight();
        PixelA[] tmp = new PixelA[dstw];
        int co = 0;
        while (co < dstw) {
            PixelA sum = new PixelA();
            int y = 0;
            while (y < kh) {
                int sy = dy + y - cy;
                if (sy >= 0) {
                    if (sy >= srch) break;
                    sum.addA(src[sy * srcw + co], vk[y]);
                }
                ++y;
            }
            tmp[co] = sum;
            ++co;
        }
        int de = dx + dw;
        int co2 = dx;
        while (co2 < de) {
            PixelA sum = new PixelA();
            int x = 0;
            while (x < kw) {
                int sx = co2 + x - cx;
                if (sx >= 0) {
                    if (sx >= srcw) break;
                    sum.addA(tmp[sx], hk[x]);
                }
                ++x;
            }
            dst[dy * dstw + co2] = this.isDstOpaq ? sum.getR() : sum.getA();
            ++co2;
        }
    }

    @Override
    public void filterConvolute(BufferedImage bi, BufferedImage bid, int dx, int dw, int dy, Kernel k) {
        DataBufferInt sdbi = (DataBufferInt)bi.getRaster().getDataBuffer();
        DataBufferInt ddbi = (DataBufferInt)bid.getRaster().getDataBuffer();
        int[] src = sdbi.getData();
        int[] dst = ddbi.getData();
        int srcw = bi.getWidth();
        int dstw = bid.getWidth();
        int srch = bi.getHeight();
        int cx = k.getXOrigin();
        int cy = k.getYOrigin();
        int kw = k.getWidth();
        int kh = k.getHeight();
        float[] data = k.getKernelData(null);
        int de = dx + dw;
        if (cy <= dy && dy < srch + cy + 1 - kh) {
            int sx;
            int x;
            int sy;
            int i;
            int y;
            PixelA sum;
            int dr = Math.min(de, srcw + cx + 1 - kw);
            int co = dx;
            while (co < cy) {
                sum = new PixelA();
                y = 0;
                i = 0;
                while (y < kh) {
                    sy = dy + y - cy;
                    x = 0;
                    while (x < kw) {
                        sx = co + x - cx;
                        if (sx >= 0) {
                            if (sx >= srcw) break;
                            sum.addA(src[sy * srcw + sx], (double)data[y * kw + x]);
                        }
                        ++x;
                    }
                    ++y;
                    ++i;
                }
                dst[dy * dstw + co] = this.isDstOpaq ? sum.getR() : sum.getA();
                ++co;
            }
            while (co < dr) {
                sum = new PixelA();
                y = 0;
                i = 0;
                while (y < kh) {
                    sy = dy + y - cy;
                    x = 0;
                    while (x < kw) {
                        sx = co + x - cx;
                        sum.addA(src[sy * srcw + sx], (double)data[y * kw + x]);
                        ++x;
                    }
                    ++y;
                    ++i;
                }
                dst[dy * dstw + co] = this.isDstOpaq ? sum.getR() : sum.getA();
                ++co;
            }
            while (co < de) {
                sum = new PixelA();
                y = 0;
                i = 0;
                while (y < kh) {
                    sy = dy + y - cy;
                    x = 0;
                    while (x < kw) {
                        sx = co + x - cx;
                        if (sx >= srcw) break;
                        sum.addA(src[sy * srcw + sx], (double)data[y * kw + x]);
                        ++x;
                    }
                    ++y;
                    ++i;
                }
                dst[dy * dstw + co] = this.isDstOpaq ? sum.getR() : sum.getA();
                ++co;
            }
        } else {
            int co = dx;
            while (co < de) {
                PixelA sum = new PixelA();
                int y = 0;
                int i = 0;
                while (y < kh) {
                    int sy = dy + y - cy;
                    if (sy >= 0) {
                        if (sy >= srch) break;
                        int x = 0;
                        while (x < kw) {
                            int sx = co + x - cx;
                            if (sx >= 0) {
                                if (sx >= srcw) break;
                                sum.addA(src[sy * srcw + sx], (double)data[y * kw + x]);
                            }
                            ++x;
                        }
                    }
                    ++y;
                    ++i;
                }
                dst[dy * dstw + co] = this.isDstOpaq ? sum.getR() : sum.getA();
                ++co;
            }
        }
    }

    @Override
    public void filterZoomDown(BufferedImage bi, BufferedImage bid, int dx, int dw, int dy, double[] fx, double[] fy, int[] ix, int[] iy, double zx, double zy) {
        DataBufferInt sdbi = (DataBufferInt)bi.getRaster().getDataBuffer();
        DataBufferInt ddbi = (DataBufferInt)bid.getRaster().getDataBuffer();
        int[] src = sdbi.getData();
        int[] dst = ddbi.getData();
        int srcw = bi.getWidth();
        int dstw = bid.getWidth();
        double ww = zx * zy;
        int de = dx + dw;
        int x = dx;
        while (x < de) {
            PixelA sum = new PixelA();
            int j = iy[0] + 1;
            while (j < iy[1]) {
                int i = ix[x * 2] + 1;
                while (i < ix[x * 2 + 1]) {
                    sum.addA(src[j * srcw + i], ww);
                    ++i;
                }
                sum.addA(src[j * srcw + ix[x * 2]], fx[x * 2] * zy);
                sum.addA(src[j * srcw + ix[x * 2 + 1]], fx[x * 2 + 1] * zy);
                ++j;
            }
            int i = ix[x * 2] + 1;
            while (i < ix[x * 2 + 1]) {
                sum.addA(src[iy[0] * srcw + i], fy[0] * zx);
                sum.addA(src[iy[1] * srcw + i], fy[1] * zx);
                ++i;
            }
            sum.addA(src[iy[0] * srcw + ix[x * 2]], fy[0] * fx[x * 2]);
            sum.addA(src[iy[0] * srcw + ix[x * 2 + 1]], fy[0] * fx[x * 2 + 1]);
            sum.addA(src[iy[1] * srcw + ix[x * 2]], fy[1] * fx[x * 2]);
            sum.addA(src[iy[1] * srcw + ix[x * 2 + 1]], fy[1] * fx[x * 2 + 1]);
            dst[dy * dstw + x] = this.isDstOpaq ? sum.getR() : sum.getA();
            ++x;
        }
    }

    @Override
    public int[] getLeftRightEdge(BufferedImage bi, int y) {
        DataBufferInt sdbi = (DataBufferInt)bi.getRaster().getDataBuffer();
        int[] src = sdbi.getData();
        int srcw = bi.getWidth();
        int x = 0;
        while (x < srcw) {
            int argb = src[y * srcw + x];
            if ((argb >> 24 & 0xFF) != 0) break;
            ++x;
        }
        if (x >= srcw) {
            return new int[2];
        }
        int left = x;
        int right = x;
        while (x < srcw) {
            int argb = src[y * srcw + x];
            if ((argb >> 24 & 0xFF) != 0) {
                right = x;
            }
            ++x;
        }
        return new int[]{left, right + 1};
    }
}

