/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.imagetool.internal.filter;

import com.ibm.etools.webedit.imagetool.internal.filter.ConvoluteHVOp;
import com.ibm.etools.webedit.imagetool.internal.filter.HVKernel;
import com.ibm.etools.webedit.imagetool.internal.filter.LineOp;
import com.ibm.etools.webedit.imagetool.internal.filter.LineOpA;
import com.ibm.etools.webedit.imagetool.internal.filter.LineOpG;
import com.ibm.etools.webedit.imagetool.internal.filter.LineOpI;
import com.ibm.etools.webedit.imagetool.internal.filter.LineOpR;
import com.ibm.etools.webedit.imagetool.internal.image.ImageError;
import com.ibm.etools.webedit.imagetool.internal.image.RasterImage;
import java.awt.image.BufferedImage;

public class HandyConvoluteHVOp
extends ConvoluteHVOp {
    public HandyConvoluteHVOp(HVKernel kernel) {
        super(kernel);
    }

    public BufferedImage createDestination(BufferedImage bi) {
        int w = bi.getWidth();
        int h = bi.getHeight();
        int stype = bi.getType();
        int dtype = this.getDestinationType(stype);
        return new BufferedImage(w, h, dtype);
    }

    @Override
    public BufferedImage filter(BufferedImage bi) {
        BufferedImage bid = this.createDestination(bi);
        if (bid == null) {
            return null;
        }
        return this.filter(bi, bid);
    }

    @Override
    public BufferedImage filter(BufferedImage bi, BufferedImage bid) {
        boolean isDstOpaq;
        int stype;
        if (bid == null) {
            return this.filter(bi);
        }
        if (bid == bi) {
            ImageError.error(1);
        }
        if ((stype = bi.getType()) == 12) {
            bi = RasterImage.convertImage(bi, 10);
            stype = bi.getType();
        }
        int dtype = bid.getType();
        LineOp operator = null;
        boolean bl = isDstOpaq = dtype == 1 || dtype == 10;
        if (stype == 2) {
            operator = new LineOpA(isDstOpaq);
        } else if (stype == 1) {
            operator = new LineOpR(isDstOpaq);
        } else if (stype == 13) {
            operator = new LineOpI(isDstOpaq);
        } else if (stype == 10) {
            operator = new LineOpG(isDstOpaq);
        }
        if (operator == null) {
            return super.filter(bi, bid);
        }
        int dsth = bid.getHeight();
        int dstw = bid.getWidth();
        double[] hk = this.myKernel.getHKernel();
        double[] vk = this.myKernel.getVKernel();
        int y = 0;
        while (y < dsth) {
            operator.filterConvolute(bi, bid, 0, dstw, y, hk, vk);
            ++y;
        }
        return bid;
    }

    public int getDestinationType(int type) {
        if (type == 12) {
            type = 1;
        } else if (type == 13) {
            type = 2;
        } else if (type == 10) {
            type = 1;
        }
        return type;
    }
}

