/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.imagetool.internal.filter;

import com.ibm.etools.webedit.imagetool.internal.filter.TransformOp;
import com.ibm.etools.webedit.imagetool.internal.filter.TranslateOp;
import com.ibm.etools.webedit.imagetool.internal.image.RasterImage;
import java.awt.Dimension;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;

public class CropOp
extends TransformOp {
    private Rectangle2D cropRect = null;

    public CropOp(Rectangle2D rect) {
        super(0);
        double x = rect.getMinX();
        double y = rect.getMinY();
        double w = rect.getMaxX() - x;
        double h = rect.getMaxY() - y;
        this.cropRect = new Rectangle2D.Double(x, y, w, h);
    }

    @Override
    public RasterImage create(RasterImage fi, Dimension2D scrnSize) {
        BufferedImage bi = fi.getBufferedImage();
        int fx = fi.getOffsetX();
        int fy = fi.getOffsetY();
        int fw = bi.getWidth();
        int fh = bi.getHeight();
        Rectangle2D frect = this.cropRect.createIntersection(new Rectangle2D.Double(fx, fy, fw, fh));
        double fl = frect.getMinX();
        double ft = frect.getMinY();
        double fr = frect.getMaxX();
        double fb = frect.getMaxY();
        Rectangle2D.Double cutrect = new Rectangle2D.Double(fl - (double)fx, ft - (double)fy, fr - fl, fb - ft);
        CropOp crop = new CropOp(cutrect);
        BufferedImage bid = crop.create(bi);
        double sw = scrnSize.getWidth();
        double sh = scrnSize.getHeight();
        Rectangle2D srect = this.cropRect.createIntersection(new Rectangle2D.Double(0.0, 0.0, sw, sh));
        double sl = srect.getMinX();
        double st = srect.getMinY();
        Point2D.Double pos = new Point2D.Double(fl - sl, ft - st);
        return new RasterImage(bid, pos, fi.getDelayTime(), fi.getDisposalMethod(), fi.isGray());
    }

    public BufferedImage create(BufferedImage bi) {
        int bw = bi.getWidth();
        int bh = bi.getHeight();
        Rectangle2D brect = this.cropRect.createIntersection(new Rectangle2D.Double(0.0, 0.0, bw, bh));
        double bl = brect.getMinX();
        double bt = brect.getMinY();
        double br = brect.getMaxX();
        double bb = brect.getMaxY();
        int dw = (int)(br - bl);
        int dh = (int)(bb - bt);
        BufferedImage bid = this.createCompatible(bi, dw, dh);
        TranslateOp scroll = new TranslateOp(-bl, -bt);
        return scroll.filter(bi, bid);
    }

    @Override
    public Dimension2D getOperatedSize(int width, int height) {
        return new Dimension((int)this.cropRect.getWidth(), (int)this.cropRect.getHeight());
    }
}

