/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.imagetool.internal.color;

import com.ibm.etools.webedit.imagetool.internal.color.ReversibleColormap;
import com.ibm.etools.webedit.imagetool.internal.image.ImageError;

public class LatticeColormap
extends ReversibleColormap {
    private int levelR = 0;
    private int levelG = 0;
    private int levelB = 0;
    private int factorR = 0;
    private int factorG = 0;
    private double spanR = 0.0;
    private double spanG = 0.0;
    private double spanB = 0.0;

    public LatticeColormap(int levelR, int levelG, int levelB, boolean transparent) {
        this.myColormap = LatticeColormap.createColorArray(levelR, levelG, levelB, transparent, 0xFFFFFF);
        this.levelR = levelR;
        this.levelG = levelG;
        this.levelB = levelB;
        this.factorR = levelG * levelB;
        this.factorG = levelB;
        this.spanR = 255.0 / (double)(levelR - 1);
        this.spanG = 255.0 / (double)(levelG - 1);
        this.spanB = 255.0 / (double)(levelB - 1);
    }

    public static int[] createColorArray(int levelR, int levelG, int levelB, boolean transparent, int tcolor) {
        int ncolors = levelR * levelG * levelB;
        if (transparent) {
            ++ncolors;
        }
        if (levelR < 2 || levelG < 2 || levelB < 2 || ncolors > 256) {
            ImageError.error(1);
        }
        int[] cmap = new int[ncolors];
        int index = 0;
        int r = 0;
        while (r < levelR) {
            int rval = 255 * r / (levelR - 1);
            int g = 0;
            while (g < levelG) {
                int gval = 255 * g / (levelR - 1);
                int b = 0;
                while (b < levelG) {
                    int bval = 255 * b / (levelR - 1);
                    int color = rval << 16 | gval << 8 | bval | 0xFF000000;
                    cmap[index++] = color;
                    ++b;
                }
                ++g;
            }
            ++r;
        }
        if (transparent) {
            cmap[index] = tcolor & 0xFFFFFF;
        }
        return cmap;
    }

    private int getBIndex(int input) {
        double denom = 255.0 / (double)(this.levelB - 1);
        double half = denom / 2.0;
        return (int)(((double)input + half) / denom);
    }

    @Override
    public int getFluctuatedIndex(int r, int g, int b, double factor) {
        int er = (int)(factor * this.spanR);
        int eg = (int)(factor * this.spanG);
        int eb = (int)(factor * this.spanB);
        int ir = r + er;
        int ig = g + eg;
        int ib = b + eb;
        ir = Math.max(0, Math.min(255, ir));
        ig = Math.max(0, Math.min(255, ig));
        ib = Math.max(0, Math.min(255, ib));
        return this.getNearestIndex(ir, ig, ib);
    }

    private int getGIndex(int input) {
        double denom = 255.0 / (double)(this.levelG - 1);
        double half = denom / 2.0;
        return (int)(((double)input + half) / denom);
    }

    @Override
    public int getNearestIndex(int r, int g, int b) {
        int ir = this.getRIndex(r);
        int ig = this.getGIndex(g);
        int ib = this.getBIndex(b);
        int index = ir * this.factorR + ig * this.factorG + ib;
        return index;
    }

    private int getRIndex(int input) {
        double denom = 255.0 / (double)(this.levelR - 1);
        double half = denom / 2.0;
        return (int)(((double)input + half) / denom);
    }
}

