/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.imagetool.internal.color;

import com.ibm.etools.webedit.imagetool.internal.color.IndexOp;
import com.ibm.etools.webedit.imagetool.internal.color.OrderedDither;
import com.ibm.etools.webedit.imagetool.internal.color.ReversibleColormap;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;

public class IndexOrderedDither
extends IndexOp {
    private ReversibleColormap myColormap = null;

    public IndexOrderedDither(int type, int ncolors, boolean transparent) {
        this.myColormap = IndexOrderedDither.createColormap(type, ncolors, transparent);
    }

    public IndexOrderedDither(ReversibleColormap colormap) {
        this.myColormap = colormap;
    }

    @Override
    BufferedImage filterIndex(BufferedImage bi) {
        int w = bi.getWidth();
        int h = bi.getHeight();
        BufferedImage bid = IndexOrderedDither.createIndexImage(w, h, this.myColormap);
        DataBufferByte ddbb = (DataBufferByte)bid.getRaster().getDataBuffer();
        byte[] dst = ddbb.getData();
        int dstw = bid.getWidth();
        OrderedDither od = new OrderedDither(this.myColormap);
        int y = 0;
        while (y < h) {
            int d0 = dstw * y;
            int x = 0;
            while (x < w) {
                int pixel = bi.getRGB(x, y);
                dst[d0 + x] = (byte)od.getDitheredIndex(pixel, x, y);
                ++x;
            }
            ++y;
        }
        return bid;
    }
}

