/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.imagetool.internal.color;

import com.ibm.etools.webedit.imagetool.internal.color.ErrorContext;
import com.ibm.etools.webedit.imagetool.internal.color.IndexOp;
import com.ibm.etools.webedit.imagetool.internal.color.ReversibleColormap;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;

public class IndexErrorDiffused
extends IndexOp {
    private ReversibleColormap myColormap = null;

    public IndexErrorDiffused(int type, int ncolors, boolean transparent) {
        this.myColormap = IndexErrorDiffused.createColormap(type, ncolors, transparent);
    }

    public IndexErrorDiffused(ReversibleColormap colormap) {
        this.myColormap = colormap;
    }

    @Override
    BufferedImage filterIndex(BufferedImage bi) {
        int w = bi.getWidth();
        int h = bi.getHeight();
        BufferedImage bid = IndexErrorDiffused.createIndexImage(w, h, this.myColormap);
        DataBufferByte ddbb = (DataBufferByte)bid.getRaster().getDataBuffer();
        byte[] dst = ddbb.getData();
        int dstw = bid.getWidth();
        ErrorContext errors = new ErrorContext(this.myColormap, 0.9);
        errors.initErrors(w);
        int y = 0;
        while (y < h) {
            int index;
            int pixel;
            int x;
            boolean backward = (y & 1) != 0;
            int d0 = dstw * y;
            if (!backward) {
                x = 0;
                errors.loadInitial(0, 1);
                pixel = bi.getRGB(x, y);
                index = errors.getErrorDiffused(pixel, 0);
                dst[d0 + x] = (byte)index;
                x = 1;
                while (x < w - 1) {
                    errors.loadError(x + 1);
                    pixel = bi.getRGB(x, y);
                    index = errors.getErrorDiffused(pixel, x);
                    dst[d0 + x] = (byte)index;
                    ++x;
                }
            } else {
                x = w - 1;
                errors.loadInitial(x, x - 1);
                pixel = bi.getRGB(x, y);
                index = errors.getErrorDiffused(pixel, x);
                dst[d0 + x] = (byte)index;
                x = w - 2;
                while (x > 0) {
                    errors.loadError(x - 1);
                    pixel = bi.getRGB(x, y);
                    index = errors.getErrorDiffused(pixel, x);
                    dst[d0 + x] = (byte)index;
                    --x;
                }
            }
            errors.loadFinal();
            pixel = bi.getRGB(x, y);
            index = errors.getErrorDiffused(pixel, x);
            dst[d0 + x] = (byte)index;
            ++y;
        }
        return bid;
    }
}

