/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.imagetool.internal.color;

import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;

public class HeckbertQuantizer {
    static final int R_BITS = 5;
    static final int G_BITS = 5;
    static final int B_BITS = 5;
    static final int R_ELEMS = 32;
    static final int G_ELEMS = 32;
    static final int B_ELEMS = 32;
    static final int R_SHIFT = 3;
    static final int G_SHIFT = 3;
    static final int B_SHIFT = 3;
    static final int R_SCALE = 2;
    static final int G_SCALE = 3;
    static final int B_SCALE = 1;
    static final int MAX_COUNT = 0x800000;
    HistogramCell[][][] histogram3D = null;
    int[] colorArray = null;

    private void _addStatistics(int r, int g, int b) {
        HistogramCell cell = this.histogram3D[r >> 3][g >> 3][b >> 3];
        if (cell.histogram >= 0x800000) {
            return;
        }
        cell.sumR += r;
        cell.sumG += g;
        cell.sumB += b;
        ++cell.histogram;
    }

    private int _computeColor(Box box) {
        long total = 0L;
        long c0total = 0L;
        long c1total = 0L;
        long c2total = 0L;
        int rmin = box.rmin;
        int rmax = box.rmax;
        int gmin = box.gmin;
        int gmax = box.gmax;
        int bmin = box.bmin;
        int bmax = box.bmax;
        int c0 = rmin;
        while (c0 <= rmax) {
            int c1 = gmin;
            while (c1 <= gmax) {
                int c2 = bmin;
                while (c2 <= bmax) {
                    HistogramCell hist = this.histogram3D[c0][c1][c2];
                    int count = hist.histogram;
                    if (count > 0) {
                        total += (long)count;
                        c0total += (long)hist.sumR;
                        c1total += (long)hist.sumG;
                        c2total += (long)hist.sumB;
                    }
                    ++c2;
                }
                ++c1;
            }
            ++c0;
        }
        int color = 0xFFFFFF;
        if (total > 0L) {
            int r = (int)((c0total + (total >> 1)) / total);
            int g = (int)((c1total + (total >> 1)) / total);
            int b = (int)((c2total + (total >> 1)) / total);
            r = Math.max(0, Math.min(255, r));
            g = Math.max(0, Math.min(255, g));
            b = Math.max(0, Math.min(255, b));
            color = r << 16 | g << 8 | b | 0xFF000000;
        }
        return color;
    }

    private Box _findBiggestColorPop(Box[] boxlist, int numboxes) {
        int maxc = 0;
        Box which = null;
        int i = 0;
        while (i < numboxes) {
            Box box = boxlist[i];
            if (box.colorcount > maxc && box.volume > 0) {
                which = box;
                maxc = box.colorcount;
            }
            ++i;
        }
        return which;
    }

    private Box _findBiggestVolume(Box[] boxlist, int numboxes) {
        int maxv = 0;
        Box which = null;
        int i = 0;
        while (i < numboxes) {
            Box box = boxlist[i];
            if (box.volume > maxv) {
                which = box;
                maxv = box.volume;
            }
            ++i;
        }
        return which;
    }

    private int _mediancut(Box[] boxlist, int numboxes, int ncolors) {
        while (numboxes < ncolors) {
            Box b1;
            Box box = b1 = numboxes * 2 <= ncolors ? this._findBiggestColorPop(boxlist, numboxes) : this._findBiggestVolume(boxlist, numboxes);
            if (b1 == null) break;
            Box b2 = boxlist[numboxes];
            b2.rmax = b1.rmax;
            b2.gmax = b1.gmax;
            b2.bmax = b1.bmax;
            b2.rmin = b1.rmin;
            b2.gmin = b1.gmin;
            b2.bmin = b1.bmin;
            int c0 = (b1.rmax - b1.rmin << 3) * 2;
            int c1 = (b1.gmax - b1.gmin << 3) * 3;
            int c2 = (b1.bmax - b1.bmin << 3) * 1;
            int cmax = c1;
            int n = 1;
            if (c0 > cmax) {
                cmax = c0;
                n = 0;
            }
            if (c2 > cmax) {
                n = 2;
            }
            switch (n) {
                case 0: {
                    int lb;
                    b1.rmax = lb = (b1.rmax + b1.rmin) / 2;
                    b2.rmin = lb + 1;
                    break;
                }
                case 1: {
                    int lb;
                    b1.gmax = lb = (b1.gmax + b1.gmin) / 2;
                    b2.gmin = lb + 1;
                    break;
                }
                case 2: {
                    int lb;
                    b1.bmax = lb = (b1.bmax + b1.bmin) / 2;
                    b2.bmin = lb + 1;
                }
            }
            this._updateBox(b1);
            this._updateBox(b2);
            ++numboxes;
        }
        return numboxes;
    }

    private void _updateBox(Box box) {
        int c2;
        int c1;
        int c0;
        int rmin = box.rmin;
        int rmax = box.rmax;
        int gmin = box.gmin;
        int gmax = box.gmax;
        int bmin = box.bmin;
        int bmax = box.bmax;
        if (rmax > rmin) {
            c0 = rmin;
            block0: while (c0 <= rmax) {
                c1 = gmin;
                while (c1 <= gmax) {
                    c2 = bmin;
                    while (c2 <= bmax) {
                        if (this.histogram3D[c0][c1][c2].histogram > 0) {
                            box.rmin = rmin = c0;
                            break block0;
                        }
                        ++c2;
                    }
                    ++c1;
                }
                ++c0;
            }
        }
        if (rmax > rmin) {
            c0 = rmax;
            block3: while (c0 >= rmin) {
                c1 = gmin;
                while (c1 <= gmax) {
                    c2 = bmin;
                    while (c2 <= bmax) {
                        if (this.histogram3D[c0][c1][c2].histogram > 0) {
                            box.rmax = rmax = c0;
                            break block3;
                        }
                        ++c2;
                    }
                    ++c1;
                }
                --c0;
            }
        }
        if (gmax > gmin) {
            c1 = gmin;
            block6: while (c1 <= gmax) {
                c0 = rmin;
                while (c0 <= rmax) {
                    c2 = bmin;
                    while (c2 <= bmax) {
                        if (this.histogram3D[c0][c1][c2].histogram > 0) {
                            box.gmin = gmin = c1;
                            break block6;
                        }
                        ++c2;
                    }
                    ++c0;
                }
                ++c1;
            }
        }
        if (gmax > gmin) {
            c1 = gmax;
            block9: while (c1 >= gmin) {
                c0 = rmin;
                while (c0 <= rmax) {
                    c2 = bmin;
                    while (c2 <= bmax) {
                        if (this.histogram3D[c0][c1][c2].histogram > 0) {
                            box.gmax = gmax = c1;
                            break block9;
                        }
                        ++c2;
                    }
                    ++c0;
                }
                --c1;
            }
        }
        if (bmax > bmin) {
            c2 = bmin;
            block12: while (c2 <= bmax) {
                c0 = rmin;
                while (c0 <= rmax) {
                    c1 = gmin;
                    while (c1 <= gmax) {
                        if (this.histogram3D[c0][c1][c2].histogram > 0) {
                            box.bmin = bmin = c2;
                            break block12;
                        }
                        ++c1;
                    }
                    ++c0;
                }
                ++c2;
            }
        }
        if (bmax > bmin) {
            c2 = bmax;
            block15: while (c2 >= bmin) {
                c0 = rmin;
                while (c0 <= rmax) {
                    c1 = gmin;
                    while (c1 <= gmax) {
                        if (this.histogram3D[c0][c1][c2].histogram > 0) {
                            box.bmax = bmax = c2;
                            break block15;
                        }
                        ++c1;
                    }
                    ++c0;
                }
                --c2;
            }
        }
        int dist0 = (rmax - rmin << 3) * 2;
        int dist1 = (gmax - gmin << 3) * 3;
        int dist2 = (bmax - bmin << 3) * 1;
        box.volume = dist0 * dist0 + dist1 * dist1 + dist2 * dist2;
        int ccount = 0;
        c0 = rmin;
        while (c0 <= rmax) {
            c1 = gmin;
            while (c1 <= gmax) {
                c2 = bmin;
                while (c2 <= bmax) {
                    if (this.histogram3D[c0][c1][c2].histogram > 0) {
                        ++ccount;
                    }
                    ++c2;
                }
                ++c1;
            }
            ++c0;
        }
        box.colorcount = ccount;
    }

    public void prescan(BufferedImage bi, Rectangle2D rect) {
        int xs = 0;
        int ys = 0;
        int xe = bi.getWidth();
        int ye = bi.getHeight();
        if (rect != null) {
            xs = (int)rect.getMinX();
            ys = (int)rect.getMinY();
            xe = (int)rect.getMaxX();
            ye = (int)rect.getMaxY();
        }
        int y = ys;
        while (y < ye) {
            int x = xs;
            while (x < xe) {
                int pixel = bi.getRGB(x, y);
                int a = pixel >> 24 & 0xFF;
                int r = pixel >> 16 & 0xFF;
                int g = pixel >> 8 & 0xFF;
                int b = pixel & 0xFF;
                if (a > 0) {
                    this._addStatistics(r, g, b);
                }
                ++x;
            }
            ++y;
        }
    }

    public void reset() {
        this.histogram3D = new HistogramCell[32][32][32];
        int r = 0;
        while (r < 32) {
            int g = 0;
            while (g < 32) {
                int b = 0;
                while (b < 32) {
                    this.histogram3D[r][g][b] = new HistogramCell();
                    ++b;
                }
                ++g;
            }
            ++r;
        }
    }

    public int[] selectColors(int ncolors) {
        Box[] boxlist = new Box[256];
        int i = 0;
        while (i < 256) {
            boxlist[i] = new Box();
            ++i;
        }
        boxlist[0].rmin = 0;
        boxlist[0].gmin = 0;
        boxlist[0].bmin = 0;
        boxlist[0].rmax = 31;
        boxlist[0].gmax = 31;
        boxlist[0].bmax = 31;
        this._updateBox(boxlist[0]);
        int numboxes = 1;
        numboxes = this._mediancut(boxlist, numboxes, ncolors);
        int[] colorarray = new int[numboxes];
        int i2 = 0;
        while (i2 < numboxes) {
            colorarray[i2] = this._computeColor(boxlist[i2]);
            ++i2;
        }
        return colorarray;
    }

    class Box {
        int rmin = 0;
        int rmax = 0;
        int gmin = 0;
        int gmax = 0;
        int bmin = 0;
        int bmax = 0;
        int volume;
        int colorcount;

        Box() {
        }
    }

    class HistogramCell {
        int sumR = 0;
        int sumG = 0;
        int sumB = 0;
        int histogram = 0;

        HistogramCell() {
        }
    }
}

