/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.imagetool.internal.color;

import com.ibm.etools.webedit.imagetool.internal.color.ReversibleColormap;
import com.ibm.etools.webedit.imagetool.internal.image.ImageError;

public class GrayColormap
extends ReversibleColormap {
    private int levelGray = 0;
    private double spanGray = 0.0;

    public GrayColormap(int level, boolean transparent) {
        this.myColormap = GrayColormap.createColorArray(level, transparent, 0xFFFFFF);
        this.levelGray = level;
        this.spanGray = 255.0 / (double)(level - 1);
    }

    public static int[] createColorArray(int level, boolean transparent, int tcolor) {
        int ncolors = level;
        if (transparent) {
            ++ncolors;
        }
        if (level < 2 || ncolors > 256) {
            ImageError.error(1);
        }
        int[] cmap = new int[ncolors];
        int index = 0;
        int i = 0;
        while (i < level) {
            int val = 255 * i / (level - 1);
            int color = val << 16 | val << 8 | val | 0xFF000000;
            cmap[index++] = color;
            ++i;
        }
        if (transparent) {
            cmap[index] = tcolor & 0xFFFFFF;
        }
        return cmap;
    }

    @Override
    public int getFluctuatedIndex(int r, int g, int b, double factor) {
        int gray = GrayColormap.getGray(r, g, b);
        int egray = (int)(factor * this.spanGray);
        int igray = gray + egray;
        igray = Math.max(0, Math.min(255, igray));
        return this.getIndex(igray);
    }

    public static int getGray(int r, int g, int b) {
        return (r * 5 + g * 9 + b * 2) / 16;
    }

    public int getIndex(int input) {
        double denom = 255.0 / (double)(this.levelGray - 1);
        double half = denom / 2.0;
        return (int)(((double)input + half) / denom);
    }

    @Override
    public int getNearestIndex(int r, int g, int b) {
        int gray = GrayColormap.getGray(r, g, b);
        int index = this.getIndex(gray);
        return index;
    }
}

