/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.imagetool.internal.color;

import com.ibm.etools.webedit.imagetool.internal.color.ReversibleColormap;

final class ErrorContext {
    private ReversibleColormap myColormap = null;
    private double errPropagation = 0.0;
    private int[] errRs = null;
    private int[] errGs = null;
    private int[] errBs = null;
    private int errRb = 0;
    private int errGb = 0;
    private int errBb = 0;
    private int errRu = 0;
    private int errGu = 0;
    private int errBu = 0;
    private int errRf = 0;
    private int errGf = 0;
    private int errBf = 0;
    private int errR = 0;
    private int errG = 0;
    private int errB = 0;

    ErrorContext(ReversibleColormap colormap) {
        this.myColormap = colormap;
        this.errPropagation = 0.0;
    }

    ErrorContext(ReversibleColormap colormap, double propagation) {
        this.myColormap = colormap;
        this.errPropagation = propagation;
    }

    int getErrorDiffused(int pixel, int ex) {
        int a = pixel >> 24 & 0xFF;
        int r = pixel >> 16 & 0xFF;
        int g = pixel >> 8 & 0xFF;
        int b = pixel & 0xFF;
        int cr = r + (this.errRb + this.errRu * 5 + this.errRf * 3 + this.errR * 7) / 16;
        int cg = g + (this.errGb + this.errGu * 5 + this.errGf * 3 + this.errG * 7) / 16;
        int cb = b + (this.errBb + this.errBu * 5 + this.errBf * 3 + this.errB * 7) / 16;
        int nr = Math.max(0, Math.min(255, cr));
        int ng = Math.max(0, Math.min(255, cg));
        int nb = Math.max(0, Math.min(255, cb));
        int index = this.myColormap.getNearestIndex(a, nr, ng, nb);
        int mcolor = this.myColormap.getColor(index);
        int mr = mcolor >> 16 & 0xFF;
        int mg = mcolor >> 8 & 0xFF;
        int mb = mcolor & 0xFF;
        int er = cr - mr;
        int eg = cg - mg;
        int eb = cb - mb;
        if (a == 0) {
            er = 0;
            eg = 0;
            eb = 0;
        } else if (this.errPropagation > 0.0) {
            er = (int)(this.errPropagation * (double)er);
            eg = (int)(this.errPropagation * (double)eg);
            eb = (int)(this.errPropagation * (double)eb);
        }
        er = Math.max(-255, Math.min(255, er));
        eg = Math.max(-255, Math.min(255, eg));
        eb = Math.max(-255, Math.min(255, eb));
        this.errR = er;
        this.errG = eg;
        this.errB = eb;
        this.errRs[ex] = er;
        this.errGs[ex] = eg;
        this.errBs[ex] = eb;
        return index;
    }

    void initErrors(int dw) {
        this.errRs = new int[dw];
        this.errGs = new int[dw];
        this.errBs = new int[dw];
        int i = 0;
        while (i < dw) {
            this.errRs[i] = 0;
            this.errGs[i] = 0;
            this.errBs[i] = 0;
            ++i;
        }
    }

    void loadError(int fx) {
        this.errRb = this.errRu;
        this.errGb = this.errGu;
        this.errBb = this.errBu;
        this.errRu = this.errRf;
        this.errGu = this.errGf;
        this.errBu = this.errBf;
        this.errRf = this.errRs[fx];
        this.errGf = this.errGs[fx];
        this.errBf = this.errBs[fx];
    }

    void loadFinal() {
        this.errRb = this.errRu;
        this.errGb = this.errGu;
        this.errBb = this.errBu;
        this.errRu = this.errRf;
        this.errGu = this.errGf;
        this.errBu = this.errBf;
        this.errRf = 0;
        this.errGf = 0;
        this.errBf = 0;
    }

    void loadInitial(int ex, int fx) {
        this.errRb = 0;
        this.errGb = 0;
        this.errBb = 0;
        this.errRu = this.errRs[ex];
        this.errGu = this.errGs[ex];
        this.errBu = this.errBs[ex];
        this.errRf = this.errRs[fx];
        this.errGf = this.errGs[fx];
        this.errBf = this.errBs[fx];
        this.errR = 0;
        this.errG = 0;
        this.errB = 0;
    }
}

