/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.imagetool;

import com.ibm.etools.webedit.imagetool.ImageAgent;
import com.ibm.etools.webedit.imagetool.ImageException;
import com.ibm.etools.webedit.imagetool.internal.color.IndexOp;
import com.ibm.etools.webedit.imagetool.internal.color.LatticeColormap;
import com.ibm.etools.webedit.imagetool.internal.gif.GIFEncodingOptions;
import com.ibm.etools.webedit.imagetool.internal.image.Frame;
import com.ibm.etools.webedit.imagetool.internal.image.ImageError;
import com.ibm.etools.webedit.imagetool.internal.image.IndexingOptionsSetter;
import com.ibm.etools.webedit.imagetool.internal.image.JPEGEncodingOptionsSetter;
import com.ibm.etools.webedit.imagetool.internal.io.EncodingOptions;
import com.ibm.etools.webedit.imagetool.internal.io.HandyImageReader;
import com.ibm.etools.webedit.imagetool.internal.jpeg.JPEGEncodingOptions;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class ImageFileConverter {
    private static JPEGEncodingOptions defaultJpegOptions = new JPEGEncodingOptions();
    private static GIFEncodingOptions defaultGifOptions = new GIFEncodingOptions();
    private static IndexOp defaultIndexingOptions = IndexOp.createIndexOp(2, new LatticeColormap(6, 6, 6, true));
    private static JPEGEncodingOptionsSetter myJpegOptionsSetter = null;
    private static IndexingOptionsSetter myIndexingOptionsSetter = null;

    public static void convert(ImageAgent ia, OutputStream out, int format) throws IOException {
        if (format == 4) {
            ImageFileConverter.convertToJpeg(ia, out);
        } else if (format == 2) {
            ImageFileConverter.convertToGif(ia, out);
        } else {
            ImageError.error(3);
        }
    }

    public static void convert(String infile, String outfile, int format) throws IOException, ImageException {
        ImageAgent ia = new ImageAgent(infile, true);
        FileOutputStream out = new FileOutputStream(outfile);
        ImageFileConverter.convert(ia, out, format);
        ((OutputStream)out).close();
    }

    static void convertToGif(ImageAgent ia, OutputStream out) throws IOException {
        GIFEncodingOptions options = defaultGifOptions;
        Frame fi = ia.getFrame();
        boolean index = fi.isIndexColor();
        if (!index) {
            IndexOp io = defaultIndexingOptions;
            if (myIndexingOptionsSetter != null) {
                io = myIndexingOptionsSetter.getIndexOp(fi);
            }
            ia.filter(io);
        }
        ia.saveImage(out, (EncodingOptions)options);
    }

    static void convertToJpeg(ImageAgent ia, OutputStream out) throws IOException {
        JPEGEncodingOptions jpegoptions = defaultJpegOptions;
        if (myJpegOptionsSetter != null) {
            Frame fi = ia.getFrame();
            jpegoptions = myJpegOptionsSetter.getJPEGEncodingOptions(fi);
        }
        ia.saveImage(out, (EncodingOptions)jpegoptions);
    }

    public static int getFormatConvertTo(String infile) {
        if (ImageFileConverter.isWebFormat(infile)) {
            return 0;
        }
        ImageAgent ia = null;
        try {
            ia = new ImageAgent(infile, true);
        }
        catch (Exception exception) {
            return 0;
        }
        Frame fi = ia.getFrame();
        boolean index = fi.isIndexColor();
        int posx = fi.getOffsetX();
        int posy = fi.getOffsetY();
        int outformat = 4;
        if (index || posx != 0 || posy != 0 || fi.hasTransparentPart()) {
            outformat = 2;
        }
        return outformat;
    }

    public static boolean isWebFormat(String infile) {
        int format = HandyImageReader.detectFormat(infile);
        return format == 4 || format == 2 || format == 5 || format == 17;
    }

    public static void replaceGifOptions(GIFEncodingOptions options) {
        defaultGifOptions = options;
    }

    public static void replaceIndexingOptions(IndexOp options) {
        defaultIndexingOptions = options;
    }

    public static void replaceJpegOptions(JPEGEncodingOptions options) {
        defaultJpegOptions = options;
    }

    public static IndexingOptionsSetter setIndexingOptionsSetter(IndexingOptionsSetter setter) {
        IndexingOptionsSetter old = myIndexingOptionsSetter;
        myIndexingOptionsSetter = setter;
        return old;
    }

    public static JPEGEncodingOptionsSetter setJpegOptionsSetter(JPEGEncodingOptionsSetter setter) {
        JPEGEncodingOptionsSetter old = myJpegOptionsSetter;
        myJpegOptionsSetter = setter;
        return old;
    }
}

