/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.frame;

public final class Length {
    public static final int PIXEL = 1;
    public static final int PERCENT = 2;
    public static final int REMAIN = 3;
    private String rawData;
    private boolean isValid = false;
    private int type;
    private int value;

    public Length() {
        this.reset();
    }

    public Length(int value, int type) {
        this.value = value;
        this.type = type;
        this.isValid = true;
    }

    public Length(String s) {
        this.setString(s);
    }

    public int getType() {
        return this.type;
    }

    public int getValue() {
        return this.value;
    }

    public String getString() {
        return this.rawData;
    }

    public boolean isValid() {
        return this.isValid;
    }

    private void reset() {
        this.value = 100;
        this.type = 2;
        this.rawData = null;
        this.isValid = false;
    }

    public void setString(String s) {
        this.reset();
        String sss = s.trim();
        int slen = sss.length();
        if (slen == 0) {
            return;
        }
        this.isValid = true;
        int i = 0;
        while (i < slen && Character.isDigit(sss.charAt(i))) {
            ++i;
        }
        if (i == 0) {
            if (sss.charAt(0) == '*') {
                this.type = 3;
                this.value = 1;
            } else {
                this.reset();
            }
        } else {
            String numPart = sss.substring(0, i);
            try {
                this.value = Integer.parseInt(numPart);
                if (i == slen) {
                    this.type = 1;
                } else {
                    String unitPart = sss.substring(i).trim();
                    if (unitPart.length() == 0) {
                        this.type = 1;
                    } else {
                        char unit = unitPart.charAt(0);
                        switch (unit) {
                            case '%': {
                                this.type = 2;
                                break;
                            }
                            case '*': {
                                this.type = 3;
                                break;
                            }
                            default: {
                                this.type = 1;
                                this.isValid = false;
                            }
                        }
                        if (unitPart.length() > 1) {
                            this.isValid = false;
                        }
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.reset();
            }
        }
        this.rawData = sss;
    }

    public String toString() {
        String s = Integer.toString(this.value);
        switch (this.type) {
            case 2: {
                s = String.valueOf(s) + "%";
                break;
            }
            case 3: {
                s = String.valueOf(s) + "*";
            }
        }
        return s;
    }
}

