/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.editparts.style;

import com.ibm.etools.webedit.editparts.ContextUtil;
import com.ibm.etools.webedit.editparts.DocumentEditPart;
import com.ibm.etools.webedit.editparts.HTMLGraphicalRootEditPart;
import com.ibm.etools.webedit.editparts.OffRenderingEditPart;
import com.ibm.etools.webedit.editparts.style.CSSQueryContext;
import com.ibm.etools.webedit.editparts.style.LinkStyleStore;
import com.ibm.etools.webedit.viewer.internal.utils.ModelManagerUtil;
import com.ibm.etools.webedit.viewer.internal.utils.WebComponent;
import com.ibm.etools.webedit.viewer.utils.HTMLModelChangeAdapter;
import com.ibm.etools.webedit.viewer.utils.IHTMLModelChangeListener;
import com.ibm.etools.webedit.viewer.utils.LinkUtil;
import com.ibm.etools.xve.renderer.utils.URLContext;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.gef.EditPart;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.css.core.internal.event.ICSSStyleListener;
import org.eclipse.wst.css.core.internal.provisional.adapters.IModelProvideAdapter;
import org.eclipse.wst.css.core.internal.provisional.contenttype.ContentTypeIdForCSS;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSModel;
import org.eclipse.wst.sse.core.internal.provisional.INodeAdapter;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.util.ProjectResolver;
import org.eclipse.wst.sse.core.internal.util.URIResolver;
import org.eclipse.wst.sse.ui.internal.editor.EditorModelUtil;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.stylesheets.StyleSheet;

public class LinkStyleStoreForLink
extends LinkStyleStore
implements IHTMLModelChangeListener {
    private static final String CSS_ID = ContentTypeIdForCSS.ContentTypeID_CSS;
    private ICSSModel model;
    private Object cachedResId;
    private boolean isBroken;

    public LinkStyleStoreForLink(OffRenderingEditPart part, ICSSStyleListener listener, boolean initialStyleUpdateCompleted) {
        super(part, listener, initialStyleUpdateCompleted);
        this.install();
    }

    @Override
    public StyleSheet getSheet() {
        return (StyleSheet)this.getModel().getDocument();
    }

    public Element getElement() {
        return (Element)this.getPart().getNode();
    }

    protected boolean isValidAttribute() {
        Element element = this.getElement();
        if (element == null) {
            return false;
        }
        String rel = element.getAttribute("rel");
        if (rel == null || !rel.equalsIgnoreCase("stylesheet")) {
            return false;
        }
        String type = element.getAttribute("type");
        if (type != null && !type.equalsIgnoreCase("text/css")) {
            return false;
        }
        String href = element.getAttribute("href");
        return href != null && href.length() != 0;
    }

    public ICSSModel getModel() {
        if (this.model != null) {
            return this.model;
        }
        ICSSModel retrieved = this.retrieveModel();
        if (retrieved != null) {
            this.model = retrieved;
            this.isBroken = false;
        } else {
            this.model = this.createBrokenModel();
            this.isBroken = true;
        }
        return this.model;
    }

    public ICSSModel retrieveModel() {
        IStructuredModel structuredModel;
        String location = this.calculateResFileName();
        if (location == null) {
            return null;
        }
        Path path = new Path(location);
        IFile file = WebComponent.getFileForLocation((IPath)path);
        Display dsp = Display.getCurrent();
        if (dsp == null) {
            dsp = Display.getDefault();
        }
        Shell shell = dsp.getActiveShell();
        ModelManagerUtil mmu = new ModelManagerUtil(shell, "");
        IStructuredModel iStructuredModel = structuredModel = file != null ? mmu.getModelForRead(file) : mmu.getModelForRead((IPath)path);
        if (structuredModel instanceof ICSSModel) {
            ((ICSSModel)structuredModel).addStyleListener((ICSSStyleListener)this);
            IModelProvideAdapter adapter = this.getModelProvideAdapter();
            if (adapter != null) {
                adapter.modelProvided(structuredModel);
            }
            EditorModelUtil.addFactoriesTo((IStructuredModel)structuredModel);
            return (ICSSModel)structuredModel;
        }
        if (structuredModel != null) {
            structuredModel.releaseFromRead();
        }
        return null;
    }

    private IModelProvideAdapter getModelProvideAdapter() {
        return (IModelProvideAdapter)((INodeNotifier)this.getElement()).getAdapterFor(IModelProvideAdapter.class);
    }

    private ICSSModel createBrokenModel() {
        if (this.getElement() == null) {
            return null;
        }
        DocumentEditPart docPart = ContextUtil.getLinkContext((EditPart)this.getPart());
        IDOMModel baseModel = ((IDOMNode)docPart.getNode()).getModel();
        ICSSModel newModel = (ICSSModel)baseModel.getModelManager().createUnManagedStructuredModelFor(CSS_ID);
        String ref = this.getElement().getAttribute("href");
        URLContext context = ContextUtil.getURLContext((EditPart)this.getPart());
        String absurl = LinkUtil.getAbsURL(context, ref, "LINK", "href");
        newModel.setBaseLocation(absurl);
        IProject baseModelProject = baseModel.getResolver() != null ? baseModel.getResolver().getProject() : null;
        newModel.setResolver((URIResolver)new ProjectResolver(baseModelProject));
        newModel.getResolver().setFileBaseLocation(absurl);
        newModel.addStyleListener((ICSSStyleListener)this);
        return newModel;
    }

    public Object getResId() {
        if (this.cachedResId == null) {
            this.cachedResId = this.calculateResId();
        }
        return this.cachedResId;
    }

    public String calculateResFileName() {
        if (!this.isValidAttribute()) {
            return null;
        }
        Element element = this.getElement();
        String href = element.getAttribute("href");
        if (href != null && CSSQueryContext.isExternalWithoutProtocol(href)) {
            return null;
        }
        URLContext context = ContextUtil.getURLContext((EditPart)this.getPart());
        return LinkUtil.getAbsURL(context, href, "LINK", "href");
    }

    public Object calculateResId() {
        String absUrl = this.calculateResFileName();
        return ModelManagerUtil.calculateModelId(absUrl);
    }

    private void install() {
        HTMLModelChangeAdapter modelChangeAdapter = (HTMLModelChangeAdapter)((IDOMNode)this.getPart().getNode()).getModel().getDocument().getAdapterFor(HTMLModelChangeAdapter.class);
        if (modelChangeAdapter != null) {
            modelChangeAdapter.addListener(this);
        }
        ((INodeNotifier)this.getElement()).addAdapter((INodeAdapter)this);
    }

    private void uninstall() {
        ((INodeNotifier)this.getElement()).removeAdapter((INodeAdapter)this);
        HTMLModelChangeAdapter modelChangeAdapter = (HTMLModelChangeAdapter)((IDOMNode)this.getPart().getNode()).getModel().getDocument().getAdapterFor(HTMLModelChangeAdapter.class);
        if (modelChangeAdapter != null) {
            modelChangeAdapter.removeListener(this);
        }
    }

    @Override
    public void attributeChanged(Node node, String attrName) {
        Object newId;
        if (node.equals(this.getPart().getNode()) && ((newId = this.calculateResId()) == null || !newId.equals(this.getResId()))) {
            this.refresh();
            this.getModel();
        }
    }

    @Override
    public void attributeRemoved(Node node, String attrName) {
        Object newId;
        if (node.equals(this.getPart().getNode()) && ((newId = this.calculateResId()) == null || !newId.equals(this.getResId()))) {
            this.refresh();
        }
    }

    @Override
    public void beginNotification() {
    }

    @Override
    public void endNotification() {
    }

    @Override
    public void nodeAdded(Node node) {
    }

    @Override
    public void nodeRemoved(Node node) {
        if (node.equals(this.getPart().getNode())) {
            this.dispose();
        }
    }

    public void refresh() {
        try {
            HTMLGraphicalRootEditPart root = (HTMLGraphicalRootEditPart)this.getPart().getRoot();
            root.fireStylesheetListChanged();
        }
        catch (NullPointerException nullPointerException) {}
        if (this.model != null) {
            IModelProvideAdapter adapter = this.getModelProvideAdapter();
            if (adapter != null) {
                adapter.modelRemoved((IStructuredModel)this.model);
            }
            this.model.removeStyleListener((ICSSStyleListener)this);
            this.model.releaseFromRead();
            this.model = null;
        }
        this.cachedResId = null;
    }

    @Override
    public void dispose() {
        this.refresh();
        this.uninstall();
        super.dispose();
    }

    public boolean isBroken() {
        return this.isBroken;
    }
}

