/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.editparts.style;

import com.ibm.etools.webedit.editparts.DocumentEditPart;
import com.ibm.etools.webedit.editparts.ElementEditPart;
import com.ibm.etools.webedit.editparts.HTMLGraphicalRootEditPart;
import com.ibm.etools.webedit.editparts.ViewingStyleListener;
import com.ibm.etools.webedit.editparts.style.CSSGraphicalSelectorMatcher;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.gef.EditPart;
import org.eclipse.swt.widgets.Display;
import org.eclipse.wst.css.core.internal.event.ICSSStyleListener;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSModel;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSSelector;
import org.eclipse.wst.html.core.internal.htmlcss.StyleListener;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.w3c.dom.stylesheets.DocumentStyle;
import org.w3c.dom.stylesheets.StyleSheetList;

public class EditPartStyleUpdater
implements ICSSStyleListener {
    private HTMLGraphicalRootEditPart owner;
    private Map mapModelToSeletors = new HashMap();
    private DocumentStyleUpdater updater;
    private final ViewingStyleListener[] refArray = new ViewingStyleListener[0];

    public EditPartStyleUpdater(HTMLGraphicalRootEditPart part) {
        this.owner = part;
    }

    public void styleChanged() {
        if (this.updater != null) {
            this.updater.cancel();
        }
        this.updater = new DocumentStyleUpdater(this.owner);
        Display display = Display.getCurrent();
        if (display != null) {
            display.timerExec(1000, (Runnable)this.updater);
        }
    }

    public void notifyChanged(INodeNotifier notifier, int eventType, Object changedFeature, Object oldValue, Object newValue, int pos) {
    }

    public boolean isAdapterForType(Object type) {
        return type.equals(StyleListener.class);
    }

    public void styleChanged(ICSSModel srcModel, ICSSSelector[] removed, ICSSSelector[] added, String media) {
        int i;
        int max;
        String mediaKey;
        ArrayList<ICSSSelector> cacheList;
        HashMap mapMediaToList;
        if (srcModel == null) {
            return;
        }
        if (this.owner != null) {
            this.owner.clearCSSGraphicalQueryTraverser();
        }
        if ((mapMediaToList = (HashMap)this.mapModelToSeletors.get(srcModel)) == null) {
            mapMediaToList = new HashMap();
            this.mapModelToSeletors.put(srcModel, mapMediaToList);
        }
        if ((cacheList = (ArrayList<ICSSSelector>)mapMediaToList.get(mediaKey = media == null ? "null" : media)) == null) {
            cacheList = new ArrayList<ICSSSelector>();
            mapMediaToList.put(mediaKey, cacheList);
        }
        if (removed != null) {
            max = removed.length;
            i = 0;
            while (i < max) {
                cacheList.add(removed[i]);
                ++i;
            }
        }
        if (added != null) {
            max = added.length;
            i = 0;
            while (i < max) {
                cacheList.add(added[i]);
                ++i;
            }
        }
    }

    private Set computeStyleChangedNodes(ICSSModel srcModel) {
        if (srcModel == null) {
            return null;
        }
        Map mapMediaToList = (Map)this.mapModelToSeletors.get(srcModel);
        if (mapMediaToList == null) {
            return null;
        }
        this.mapModelToSeletors.remove(srcModel);
        Set keySet = mapMediaToList.keySet();
        if (keySet == null) {
            return null;
        }
        HashSet styleChangedNodes = new HashSet();
        for (String media : keySet) {
            List cacheList = (List)mapMediaToList.get(media);
            int index = cacheList.size();
            while (--index >= 0) {
                ICSSSelector s1 = (ICSSSelector)cacheList.get(index);
                if (s1 == null || s1.getString() == null) {
                    cacheList.remove(index);
                    continue;
                }
                int prevIndex = index;
                while (--prevIndex >= 0) {
                    ICSSSelector s2 = (ICSSSelector)cacheList.get(prevIndex);
                    if (s2 == null || !s1.getString().equals(s2.getString())) continue;
                    cacheList.set(prevIndex, null);
                }
            }
            if (cacheList.size() == 0) continue;
            if (media == "null") {
                media = null;
            }
            this.internalStyleChanged((EditPart)this.owner, srcModel, styleChangedNodes, cacheList.toArray(new ICSSSelector[0]), media);
        }
        return styleChangedNodes;
    }

    private void internalStyleChanged(EditPart editPart, ICSSModel srcModel, Set styleChangedNodes, ICSSSelector[] changed, String media) {
        if (editPart instanceof ElementEditPart) {
            ElementEditPart eleEditPart = (ElementEditPart)editPart;
            if (styleChangedNodes != null && !styleChangedNodes.contains(editPart) && changed != null) {
                int max = changed.length;
                int i = 0;
                while (i < max) {
                    if (CSSGraphicalSelectorMatcher.match(changed[i], eleEditPart, null)) {
                        styleChangedNodes.add(editPart);
                    }
                    ++i;
                }
            }
        }
        if (editPart instanceof DocumentEditPart) {
            ElementEditPart implicitElePart;
            DocumentEditPart docPart = (DocumentEditPart)editPart;
            ElementEditPart htmlPart = docPart.getHtmlPart();
            if (htmlPart != null) {
                this.internalStyleChanged((EditPart)htmlPart, srcModel, styleChangedNodes, changed, media);
            }
            if ((implicitElePart = docPart.getImplicitElementEditPart()) != null) {
                this.internalStyleChanged((EditPart)implicitElePart, srcModel, styleChangedNodes, changed, media);
            }
        }
        List children = editPart.getChildren();
        int size = children.size();
        int i = 0;
        while (i < size) {
            Object obj = children.get(i);
            if (obj instanceof EditPart) {
                this.internalStyleChanged((EditPart)obj, srcModel, styleChangedNodes, changed, media);
            }
            ++i;
        }
    }

    public void styleUpdate(ICSSModel srcModel) {
        Set styleChangedNodes = this.computeStyleChangedNodes(srcModel);
        if (styleChangedNodes != null) {
            ViewingStyleListener[] elements = styleChangedNodes.toArray(this.refArray);
            if (elements != null) {
                int i = 0;
                while (i < elements.length) {
                    elements[i].styleChanged();
                    ++i;
                }
            }
            styleChangedNodes.clear();
        }
    }

    class DocumentStyleUpdater
    implements Runnable {
        private boolean canceled = false;
        private DocumentStyle document = null;

        public DocumentStyleUpdater(DocumentStyle document) {
            this.document = document;
        }

        public void cancel() {
            this.canceled = true;
        }

        @Override
        public void run() {
            if (this.canceled) {
                return;
            }
            if (this.document == null) {
                return;
            }
            StyleSheetList styleSheets = this.document.getStyleSheets();
            if (styleSheets == null) {
                return;
            }
            int length = styleSheets.getLength();
            int i = 0;
            while (i < length) {
                styleSheets.item(i);
                ++i;
            }
        }
    }
}

