/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.editparts.style;

import com.ibm.etools.xve.renderer.internal.style.CSSColorUtil;
import java.util.Vector;

public class CSSPropertyValidatorUtil {
    private static final Vector fontProperties = new Vector();
    private static final Vector backgroundProperties;
    private static final Vector textProperties;
    private static final Vector boxProperties;
    private static final Vector classificationProperties;
    private static final Vector positioningProperties;
    private static final Vector printingProperties;
    private static final Vector tablesProperties;
    private static final Vector miscProperties;
    private static final Vector audioProperties;
    private static final Vector colorProperties;

    static {
        fontProperties.add("font-style");
        fontProperties.add("font-variant");
        fontProperties.add("font-weight");
        backgroundProperties = new Vector();
        backgroundProperties.add("background-repeat");
        backgroundProperties.add("background-attachment");
        textProperties = new Vector();
        textProperties.add("text-decoration");
        textProperties.add("text-transform");
        textProperties.add("text-align");
        textProperties.add("white-space");
        boxProperties = new Vector();
        boxProperties.add("border-style");
        boxProperties.add("border-top-style");
        boxProperties.add("border-right-style");
        boxProperties.add("border-bottom-style");
        boxProperties.add("border-left-style");
        boxProperties.add("float");
        boxProperties.add("clear");
        boxProperties.add("outline-style");
        classificationProperties = new Vector();
        classificationProperties.add("display");
        classificationProperties.add("list-style-type");
        classificationProperties.add("list-style-position");
        positioningProperties = new Vector();
        positioningProperties.add("overflow");
        positioningProperties.add("position");
        positioningProperties.add("visibility");
        printingProperties = new Vector();
        printingProperties.add("page-break-before");
        printingProperties.add("page-break-after");
        printingProperties.add("page-break-inside");
        tablesProperties = new Vector();
        tablesProperties.add("border-collapse");
        tablesProperties.add("caption-side");
        tablesProperties.add("empty-cells");
        tablesProperties.add("table-layout");
        miscProperties = new Vector();
        miscProperties.add("direction");
        miscProperties.add("unicode-bidi");
        audioProperties = new Vector();
        audioProperties.add("speak");
        audioProperties.add("speak-header");
        audioProperties.add("speak-numeral");
        audioProperties.add("speak-punctuation");
        colorProperties = new Vector();
        colorProperties.add("color");
        colorProperties.add("background-color");
        colorProperties.add("border-color");
        colorProperties.add("border-top-color");
        colorProperties.add("border-bottom-color");
        colorProperties.add("border-right-color");
        colorProperties.add("border-left-color");
        colorProperties.add("outline-color");
    }

    public static boolean isValidationRequired(String property) {
        if (fontProperties.contains(property) || backgroundProperties.contains(property) || textProperties.contains(property) || boxProperties.contains(property) || classificationProperties.contains(property) || positioningProperties.contains(property) || printingProperties.contains(property) || miscProperties.contains(property) || tablesProperties.contains(property) || audioProperties.contains(property)) {
            return true;
        }
        return CSSPropertyValidatorUtil.isColorProperty(property);
    }

    public static boolean isValidColor(String value) {
        if (value == null) {
            return false;
        }
        return CSSColorUtil.isValidColorName((String)value) || CSSColorUtil.isValidRGBString((String)value, (boolean)true);
    }

    public static boolean isColorProperty(String property) {
        return colorProperties.contains(property);
    }
}

