/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.editparts.style;

import com.ibm.icu.util.StringTokenizer;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.stylesheets.MediaList;

public class CSSMediaType {
    private static final String MEDIATYPE_ALL = "all";
    private static final String MEDIATYPE_SCREEN = "screen";
    private static final String MEDIATYPE_DELIMITER = ",";

    public static final boolean isMediaScreen(Node node) {
        if (node instanceof Element) {
            String media = ((Element)node).getAttribute("media");
            if (media == null) {
                return true;
            }
            if (media.trim().length() == 0) {
                return true;
            }
            StringTokenizer st = new StringTokenizer(media, MEDIATYPE_DELIMITER);
            while (st.hasMoreTokens()) {
                String medium = st.nextToken().trim();
                if (!MEDIATYPE_ALL.equalsIgnoreCase(medium) && !MEDIATYPE_SCREEN.equalsIgnoreCase(medium)) continue;
                return true;
            }
        }
        return false;
    }

    public static final boolean containsScreenMedium(MediaList ml) {
        int index = ml.getLength();
        while (--index >= 0) {
            String medium = ml.item(index);
            if (!MEDIATYPE_ALL.equalsIgnoreCase(medium) && !MEDIATYPE_SCREEN.equalsIgnoreCase(medium)) continue;
            return true;
        }
        return false;
    }
}

