/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.editparts.style;

import com.ibm.etools.webedit.editparts.ElementEditPart;
import com.ibm.etools.webedit.editparts.style.CSSGraphicalSelectorMatcher;
import com.ibm.etools.webedit.editparts.style.CSSMediaType;
import com.ibm.etools.webedit.editparts.style.OrderSensitiveCSSQueryContext;
import com.ibm.etools.webedit.viewer.internal.utils.ElementAliasUtil;
import com.ibm.etools.xve.renderer.utils.URLContext;
import com.ibm.icu.text.UnicodeSet;
import com.ibm.icu.util.StringTokenizer;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSMediaRule;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSNode;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSSelector;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSSelectorItem;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSSelectorList;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSSimpleSelector;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSStyleDeclaration;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSStyleRule;
import org.eclipse.wst.css.core.internal.util.AbstractCssTraverser;
import org.eclipse.wst.css.core.internal.util.CSSStyleDeclarationFactory;
import org.w3c.dom.Element;
import org.w3c.dom.css.ElementCSSInlineStyle;
import org.w3c.dom.stylesheets.MediaList;

public class CSSGraphicalQueryTraverser
extends AbstractCssTraverser {
    private ElementEditPart element;
    private String pseudoName;
    private OrderSensitiveCSSQueryContext context;
    private URLContext urlContext;
    private HashMap idStyles = new HashMap(10);
    private HashMap classStyles = new HashMap(50);
    private HashMap tagStyles = new HashMap(30);
    private ArrayList otherStyles = new ArrayList(10);
    private int order = 0;
    private int numPair = 0;

    public int getCacheCount() {
        return this.numPair;
    }

    private void register(ICSSSelector selector, NodeContextPair pair) {
        ICSSSelectorItem item;
        ++this.numPair;
        if (selector != null && selector.getLength() > 0 && (item = selector.getItem(selector.getLength() - 1)) != null && item.getItemType() == 1) {
            String clazz;
            String id;
            ICSSSimpleSelector lastSelector = (ICSSSimpleSelector)item;
            String string = id = lastSelector.getNumOfIDs() == 1 ? lastSelector.getID(0) : null;
            if (id != null && id.length() > 0) {
                ArrayList<NodeContextPair> array = (ArrayList<NodeContextPair>)this.idStyles.get(id.toLowerCase());
                if (array == null) {
                    array = new ArrayList<NodeContextPair>(20);
                    this.idStyles.put(id.toLowerCase(), array);
                }
                array.add(pair);
                return;
            }
            String string2 = clazz = lastSelector.getNumOfClasses() > 0 ? lastSelector.getClass(0) : null;
            if (clazz != null && clazz.length() > 0) {
                ArrayList<NodeContextPair> array = (ArrayList<NodeContextPair>)this.classStyles.get(clazz.toLowerCase());
                if (array == null) {
                    array = new ArrayList<NodeContextPair>(20);
                    this.classStyles.put(clazz.toLowerCase(), array);
                }
                array.add(pair);
                return;
            }
            String tag = lastSelector.getName();
            if (!lastSelector.isUniversal() && tag != null && tag.length() > 0) {
                ArrayList<NodeContextPair> array = (ArrayList<NodeContextPair>)this.tagStyles.get(tag.toLowerCase());
                if (array == null) {
                    array = new ArrayList<NodeContextPair>(20);
                    this.tagStyles.put(tag.toLowerCase(), array);
                }
                array.add(pair);
                return;
            }
        }
        this.otherStyles.add(pair);
    }

    private ICSSStyleDeclaration getDeclaration() {
        try {
            ICSSStyleDeclaration inlineStyle = this.element.getContainerStyle();
            if (inlineStyle == null) {
                inlineStyle = (ICSSStyleDeclaration)((ElementCSSInlineStyle)((Object)this.element.getElement())).getStyle();
            }
            if (inlineStyle != null) {
                if (this.context == null) {
                    this.context = new OrderSensitiveCSSQueryContext(this.urlContext);
                }
                this.context.overrideWithExpand(inlineStyle, 10000, this.order);
            }
        }
        catch (ClassCastException classCastException) {}
        if (this.context == null) {
            return null;
        }
        ICSSStyleDeclaration decl = CSSStyleDeclarationFactory.getInstance().createStyleDeclaration();
        this.context.applyFull(decl);
        return decl;
    }

    private void overwriteDeclaration(ICSSStyleDeclaration d, int specificity, int order) {
        if (d == null) {
            return;
        }
        if (this.context == null) {
            this.context = new OrderSensitiveCSSQueryContext(this.urlContext);
        }
        this.context.overrideWithExpand(d, specificity, order);
    }

    protected short postNode(ICSSNode node) {
        return TRAV_CONT;
    }

    protected short preNode(ICSSNode node) {
        if (node == null) {
            return TRAV_CONT;
        }
        if (node.getNodeType() == 1) {
            ICSSStyleRule style = (ICSSStyleRule)node;
            ICSSSelectorList list = style.getSelectors();
            int size = list.getLength();
            int i = 0;
            while (i < size) {
                ICSSSelector selector = list.getSelector(i);
                NodeContextPair pair = new NodeContextPair(style, selector, this.urlContext, this.order);
                this.register(selector, pair);
                ++this.order;
                ++i;
            }
            return TRAV_PRUNE;
        }
        if (node.getNodeType() == 12 ? !CSSMediaType.containsScreenMedium((MediaList)node) : node.getNodeType() == 4 && !CSSMediaType.containsScreenMedium(((ICSSMediaRule)node).getMedia())) {
            return TRAV_PRUNE;
        }
        return TRAV_CONT;
    }

    public void setUrlContext(URLContext urlContext) {
        this.urlContext = urlContext;
    }

    public ICSSStyleDeclaration getDeclaration(ElementEditPart ele, String pseudo_name, URLContext url_context) {
        this.element = ele;
        this.pseudoName = pseudo_name;
        this.context = null;
        this.traverseNodes();
        this.setUrlContext(url_context);
        return this.getDeclaration();
    }

    private void traverseNodes() {
        NodeContextPair pair;
        int size;
        ArrayList array;
        Element e;
        String nodeName = null;
        String attrId = null;
        String attrClass = null;
        String aliasName = null;
        if (this.element != null && (e = this.element.getElement()) != null) {
            nodeName = e.getNodeName();
            attrId = e.getAttribute("id");
            attrClass = e.getAttribute("class");
            aliasName = ElementAliasUtil.aliasName(e);
            String string = nodeName = aliasName != null ? aliasName : nodeName;
        }
        if (attrId != null && attrId.length() > 0 && (array = (ArrayList)this.idStyles.get(attrId.toLowerCase())) != null) {
            size = array.size();
            int i = 0;
            while (i < size) {
                pair = (NodeContextPair)array.get(i);
                this.setUrlContext(pair.pairContext);
                if (CSSGraphicalSelectorMatcher.match(pair.selector, this.element, this.pseudoName, nodeName, attrId, attrClass)) {
                    this.overwriteDeclaration((ICSSStyleDeclaration)pair.style.getStyle(), pair.selector.getSpecificity(), pair.order);
                }
                ++i;
            }
        }
        if (attrClass != null && attrClass.length() > 0) {
            StringTokenizer tokenizer = new StringTokenizer(attrClass, new UnicodeSet("[ \t\n\r\f<>]", false));
            while (tokenizer.hasMoreTokens()) {
                ArrayList array2;
                String clazz = tokenizer.nextToken();
                if (clazz == null || clazz.length() <= 0 || (array2 = (ArrayList)this.classStyles.get(clazz.toLowerCase())) == null) continue;
                int size2 = array2.size();
                int i = 0;
                while (i < size2) {
                    NodeContextPair pair2 = (NodeContextPair)array2.get(i);
                    this.setUrlContext(pair2.pairContext);
                    if (CSSGraphicalSelectorMatcher.match(pair2.selector, this.element, this.pseudoName, nodeName, attrId, attrClass)) {
                        this.overwriteDeclaration((ICSSStyleDeclaration)pair2.style.getStyle(), pair2.selector.getSpecificity(), pair2.order);
                    }
                    ++i;
                }
            }
        }
        if (nodeName != null && nodeName.length() > 0 && (array = (ArrayList)this.tagStyles.get(nodeName.toLowerCase())) != null) {
            size = array.size();
            int i = 0;
            while (i < size) {
                pair = (NodeContextPair)array.get(i);
                this.setUrlContext(pair.pairContext);
                if (CSSGraphicalSelectorMatcher.match(pair.selector, this.element, this.pseudoName, nodeName, attrId, attrClass)) {
                    this.overwriteDeclaration((ICSSStyleDeclaration)pair.style.getStyle(), pair.selector.getSpecificity(), pair.order);
                }
                ++i;
            }
        }
        if (this.otherStyles != null) {
            int size3 = this.otherStyles.size();
            int i = 0;
            while (i < size3) {
                NodeContextPair pair3 = (NodeContextPair)this.otherStyles.get(i);
                this.setUrlContext(pair3.pairContext);
                if (CSSGraphicalSelectorMatcher.match(pair3.selector, this.element, this.pseudoName, nodeName, attrId, attrClass)) {
                    this.overwriteDeclaration((ICSSStyleDeclaration)pair3.style.getStyle(), pair3.selector.getSpecificity(), pair3.order);
                }
                ++i;
            }
        }
    }

    private class NodeContextPair {
        private ICSSStyleRule style = null;
        private ICSSSelector selector = null;
        private URLContext pairContext = null;
        private int order;

        private NodeContextPair(ICSSStyleRule style, ICSSSelector selector, URLContext context, int order) {
            this.style = style;
            this.selector = selector;
            this.pairContext = context;
            this.order = order;
        }
    }
}

