/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.editparts.adapter;

import com.ibm.etools.webedit.editparts.ContextUtil;
import com.ibm.etools.webedit.editparts.NodeEditPart;
import com.ibm.etools.webedit.editparts.adapter.JSPActionFactoryContribution;
import com.ibm.etools.webedit.editparts.adapter.JSPDirectiveFactoryContribution;
import com.ibm.etools.webedit.editparts.adapter.SubModelAdapter;
import com.ibm.etools.webedit.editparts.adapter.SubModelFactoryContribution;
import com.ibm.etools.webedit.viewer.internal.utils.ModelManagerUtil;
import com.ibm.etools.webedit.viewer.utils.LinkUtil;
import com.ibm.etools.xve.renderer.utils.URLContext;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Path;
import org.eclipse.gef.EditPart;
import org.w3c.dom.Node;

public class SubModelAdapterFactory {
    private static SubModelAdapterFactory instance;
    private List contributions;

    static SubModelAdapterFactory getInstance() {
        if (instance == null) {
            instance = new SubModelAdapterFactory();
            instance.addSubModelFactoryContribution(new JSPDirectiveFactoryContribution());
            instance.addSubModelFactoryContribution(new JSPActionFactoryContribution());
        }
        return instance;
    }

    private SubModelAdapterFactory() {
    }

    public void addSubModelFactoryContribution(SubModelFactoryContribution contrib) {
        if (this.contributions == null) {
            this.contributions = new ArrayList();
        }
        if (!this.contributions.contains(contrib)) {
            this.contributions.add(contrib);
        }
    }

    public void removeSubModelFactoryContribution(SubModelFactoryContribution contrib) {
        if (this.contributions != null) {
            this.contributions.remove(contrib);
        }
    }

    public SubModelFactoryContribution[] getContributions() {
        SubModelFactoryContribution[] contribs = new SubModelFactoryContribution[this.contributions != null ? this.contributions.size() : 0];
        this.contributions.toArray(contribs);
        return contribs;
    }

    boolean hasSubModel(Node node) {
        return this.getContrib(node) != null;
    }

    SubModelFactoryContribution getContrib(Node node) {
        SubModelFactoryContribution[] contribs = this.getContributions();
        int i = 0;
        while (i < contribs.length) {
            if (contribs[i].canContribute(node)) {
                return contribs[i];
            }
            ++i;
        }
        return null;
    }

    public Object getRawResId(NodeEditPart part) {
        if (part == null) {
            return null;
        }
        String fileName = this.getRawResFileName(part);
        if (fileName != null) {
            Path path = new Path(fileName);
            return ModelManagerUtil.calculateModelId(path.toString());
        }
        return null;
    }

    public String getRawResFileName(NodeEditPart part) {
        if (part == null) {
            return null;
        }
        SubModelFactoryContribution contrib = this.getContrib(part.getNode());
        if (contrib != null) {
            SubModelFactoryContribution.SubModelLinkInfo info = contrib.getLinkInfo(part.getNode());
            URLContext context = ContextUtil.getURLContext((EditPart)part);
            return LinkUtil.getAbsURL(context, info.getRawURI(), info.getTagName(), info.getAttrName());
        }
        return null;
    }

    public static SubModelAdapter createSubModelAdapterFor(NodeEditPart part) {
        if (part != null && SubModelAdapterFactory.getInstance().hasSubModel(part.getNode())) {
            return new SubModelAdapter(part);
        }
        return null;
    }
}

