/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.editparts.adapter;

import com.ibm.etools.webedit.editparts.HTMLGraphicalViewer;
import com.ibm.etools.webedit.editparts.NodeEditPart;
import com.ibm.etools.webedit.editparts.adapter.SubModelAdapterFactory;
import com.ibm.etools.webedit.editparts.adapter.SubModelOwner;
import com.ibm.etools.webedit.viewer.internal.utils.ModelManagerUtil;
import com.ibm.etools.webedit.viewer.internal.utils.WebComponent;
import com.ibm.etools.webedit.viewer.utils.HTMLModelChangeAdapter;
import com.ibm.etools.webedit.viewer.utils.IHTMLModelChangeListener;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Node;

public class SubModelAdapter
implements IHTMLModelChangeListener {
    private NodeEditPart part;
    private IDOMModel model;
    private Object cachedResId;
    private String cachedResFileName;

    public SubModelAdapter(NodeEditPart part) {
        this.part = part;
        this.install();
    }

    public IDOMModel getModel() {
        SubModelOwner owner;
        Shell shell;
        ModelManagerUtil mmu;
        IStructuredModel structuredModel;
        if (this.model != null) {
            return this.model;
        }
        String url = this.getResFileName();
        if (url == null) {
            return null;
        }
        Path path = new Path(url);
        IFile file = WebComponent.getFileForLocation((IPath)path);
        if (file == null) {
            return null;
        }
        Display dsp = Display.getCurrent();
        if (dsp == null) {
            dsp = Display.getDefault();
        }
        if ((structuredModel = (mmu = new ModelManagerUtil(shell = dsp.getActiveShell(), "")).getModelForRead(file)) == null) {
            String sseId = ModelManagerUtil.calculateSSEModelId(file);
            structuredModel = StructuredModelManager.getModelManager().getExistingModelForRead((Object)sseId);
        }
        if (!ModelManagerUtil.isHTMLFamily(structuredModel)) {
            if (structuredModel != null) {
                structuredModel.releaseFromRead();
            }
        } else {
            this.model = (IDOMModel)structuredModel;
        }
        if (this.part.getViewer() != null && (owner = ((HTMLGraphicalViewer)this.part.getViewer()).getSubModelOwner()) != null) {
            owner.subModelChanged();
        }
        return this.model;
    }

    public Object getResId() {
        if (this.cachedResId == null) {
            this.cachedResId = SubModelAdapterFactory.getInstance().getRawResId(this.part);
        }
        return this.cachedResId;
    }

    public String getResFileName() {
        if (this.cachedResFileName == null) {
            this.cachedResFileName = this.model != null ? ModelManagerUtil.getBaseLocation((IStructuredModel)this.model) : SubModelAdapterFactory.getInstance().getRawResFileName(this.part);
        }
        return this.cachedResFileName;
    }

    protected void install() {
        HTMLModelChangeAdapter modelChangeAdapter = (HTMLModelChangeAdapter)((IDOMNode)this.part.getNode()).getModel().getDocument().getAdapterFor(HTMLModelChangeAdapter.class);
        if (modelChangeAdapter != null) {
            modelChangeAdapter.addListener(this);
        }
    }

    protected void uninstall() {
        HTMLModelChangeAdapter modelChangeAdapter = (HTMLModelChangeAdapter)((IDOMNode)this.part.getNode()).getModel().getDocument().getAdapterFor(HTMLModelChangeAdapter.class);
        if (modelChangeAdapter != null) {
            modelChangeAdapter.removeListener(this);
        }
    }

    @Override
    public void attributeChanged(Node node, String attrName) {
        Object newId;
        if (node.equals(this.part.getNode()) && ((newId = SubModelAdapterFactory.getInstance().getRawResId(this.part)) == null || !newId.equals(this.getResId()))) {
            this.refresh();
        }
    }

    @Override
    public void attributeRemoved(Node node, String attrName) {
        Object newId;
        if (node.equals(this.part.getNode()) && ((newId = SubModelAdapterFactory.getInstance().getRawResId(this.part)) == null || !newId.equals(this.getResId()))) {
            this.refresh();
        }
    }

    @Override
    public void beginNotification() {
    }

    @Override
    public void endNotification() {
    }

    @Override
    public void nodeAdded(Node node) {
    }

    @Override
    public void nodeRemoved(Node node) {
        if (node.equals(this.part.getNode())) {
            this.dispose();
        }
    }

    public void refresh() {
        SubModelOwner owner;
        if (this.model != null) {
            this.model.releaseFromRead();
            this.model = null;
        }
        this.cachedResId = null;
        this.cachedResFileName = null;
        if (this.part.getViewer() != null && (owner = ((HTMLGraphicalViewer)this.part.getViewer()).getSubModelOwner()) != null) {
            owner.subModelChanged();
        }
    }

    public void dispose() {
        this.uninstall();
        this.refresh();
    }

    public boolean isLoop() {
        String baseLocation = this.getResFileName();
        if (baseLocation != null) {
            NodeEditPart current = this.part;
            while (current != null) {
                NodeEditPart nodePart;
                Node node;
                if (!((current = current.getParent()) instanceof NodeEditPart) || (node = (nodePart = current).getNode()) == null || node.getNodeType() != 9 || !baseLocation.equals(ModelManagerUtil.getBaseLocation((IStructuredModel)((IDOMDocument)node).getModel()))) continue;
                return true;
            }
        }
        return false;
    }
}

