/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.editparts;

import com.ibm.etools.webedit.editparts.DocumentEditPart;
import com.ibm.etools.webedit.editparts.DragTrackerProvider;
import com.ibm.etools.webedit.editparts.HTMLGraphicalViewerImpl;
import com.ibm.etools.webedit.editparts.NodeEditPart;
import com.ibm.etools.webedit.editparts.PartAnalyzer;
import com.ibm.etools.webedit.editparts.SelectionHandler;
import com.ibm.etools.webedit.editparts.SelectionHandlerFactory;
import com.ibm.etools.webedit.editparts.SelectionOwner;
import com.ibm.etools.webedit.editparts.ViewerUtil;
import com.ibm.etools.xve.renderer.style.ContainerStyle;
import com.ibm.etools.xve.viewer.EditPolicyFactoryRegistry;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.editparts.AbstractEditPart;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.wst.sse.core.internal.provisional.INodeAdapter;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public abstract class VisibleNodeEditPart
extends NodeEditPart
implements SelectionOwner,
INodeAdapter {
    private boolean isVisualizedEditPart = false;
    private boolean resetVisualizedFlag = true;

    public void activate() {
        super.activate();
        Node node = this.getNode();
        if (node instanceof INodeNotifier) {
            ((INodeNotifier)node).addAdapter((INodeAdapter)this);
        }
        if (this.resetVisualizedFlag) {
            this.resetVisualizedEditPartFlag();
            this.resetVisualizedFlag = false;
        }
    }

    protected void createEditPolicies() {
        HTMLGraphicalViewerImpl viewer = ViewerUtil.getHTMLGraphicalViewerImpl((EditPart)this);
        if (viewer != null) {
            EditPolicyFactoryRegistry reg = viewer.getPolicyFactoryRegistry();
            reg.installEditPolicies((EditPart)this);
        }
    }

    @Override
    public void deactivate() {
        super.deactivate();
        Node node = this.getNode();
        if (node instanceof INodeNotifier) {
            ((INodeNotifier)node).removeAdapter((INodeAdapter)this);
        }
    }

    @Override
    public SelectionHandler getSelectionHandler() {
        HTMLGraphicalViewerImpl viewer = ViewerUtil.getHTMLGraphicalViewerImpl((EditPart)this);
        if (viewer == null) {
            return null;
        }
        SelectionHandlerFactory factory = viewer.getSelectionHandlerFactory();
        return factory != null ? factory.createSelectionHandler((EditPart)this) : null;
    }

    public boolean isVisualizedEditPart() {
        if (this.resetVisualizedFlag) {
            this.resetVisualizedEditPartFlag();
            this.resetVisualizedFlag = false;
        }
        return this.isVisualizedEditPart;
    }

    private void resetVisualizedEditPartFlag() {
        Document myDoc;
        DocumentEditPart part = PartAnalyzer.getDocumentEditPart((EditPart)this);
        if (part == null) {
            this.isVisualizedEditPart = true;
            return;
        }
        Document orgDoc = (Document)part.getNode();
        Node node = this.getNode();
        Document document = myDoc = node != null ? node.getOwnerDocument() : null;
        if (orgDoc == null || myDoc == null) {
            this.isVisualizedEditPart = true;
            return;
        }
        this.isVisualizedEditPart = !orgDoc.equals(myDoc);
    }

    public String toString() {
        return "Node(" + this.getNode().getNodeName() + ")";
    }

    public abstract void updateVisual(boolean var1, boolean var2, boolean var3, boolean var4);

    public abstract void resetStyles(boolean var1);

    public abstract void updateContainer(ContainerStyle var1);

    public Cursor getCursor() {
        return null;
    }

    protected boolean hasOriginalChildNode() {
        List childParts = this.getChildren();
        if (childParts == null) {
            return false;
        }
        int size = childParts.size();
        int i = 0;
        while (i < size) {
            Object child = childParts.get(i);
            if (child instanceof VisibleNodeEditPart && !((VisibleNodeEditPart)child).isVisualizedEditPart()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean hasOriginal() {
        if (this.hasOriginalChildNode()) {
            return true;
        }
        if (this.children == null) {
            return false;
        }
        int size = this.children.size();
        int i = 0;
        while (i < size) {
            Object child = this.children.get(i);
            if (child instanceof VisibleNodeEditPart && ((VisibleNodeEditPart)child).hasOriginal()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void updateEditPolicies() {
        AbstractEditPart.EditPolicyIterator itr = this.getEditPolicyIterator();
        ArrayList<EditPolicy> policies = new ArrayList<EditPolicy>();
        while (itr.hasNext()) {
            policies.add(itr.next());
        }
        int i = 0;
        while (i < policies.size()) {
            this.removeEditPolicy(policies.get(i));
            ++i;
        }
        List childParts = this.getChildren();
        if (childParts == null) {
            return;
        }
        int j = 0;
        while (j < childParts.size()) {
            Object child = childParts.get(j);
            if (child instanceof VisibleNodeEditPart) {
                ((VisibleNodeEditPart)child).updateEditPolicies();
            }
            ++j;
        }
        this.createEditPolicies();
    }

    public void updateEditPoliciesExceptChildren() {
        AbstractEditPart.EditPolicyIterator itr = this.getEditPolicyIterator();
        ArrayList<EditPolicy> policies = new ArrayList<EditPolicy>();
        while (itr.hasNext()) {
            policies.add(itr.next());
        }
        int i = 0;
        while (i < policies.size()) {
            this.removeEditPolicy(policies.get(i));
            ++i;
        }
        this.createEditPolicies();
    }

    public DragTracker getDragTracker(Request request) {
        DragTrackerProvider provider;
        DragTracker tracker = null;
        HTMLGraphicalViewerImpl viewer = ViewerUtil.getHTMLGraphicalViewerImpl((EditPart)this);
        if (viewer != null && (provider = viewer.getDragTrackerProvider()) != null && (tracker = provider.getDragTracker((EditPart)this)) != null) {
            return tracker;
        }
        if ("selection".equals(request.getType())) {
            tracker = super.getDragTracker(request);
        }
        return tracker;
    }

    public void addNotify() {
        DocumentEditPart doc;
        super.addNotify();
        if (this.maybeRenderingRoot() && (doc = PartAnalyzer.getDocumentEditPart((EditPart)this)) != null) {
            doc.addRenderingRoot((EditPart)this);
        }
    }

    public void removeNotify() {
        DocumentEditPart doc;
        if (this.maybeRenderingRoot() && (doc = PartAnalyzer.getDocumentEditPart((EditPart)this)) != null) {
            doc.removeRenderingRoot((EditPart)this);
        }
        super.removeNotify();
    }

    private boolean maybeRenderingRoot() {
        return !(this.getParent() instanceof VisibleNodeEditPart);
    }
}

