/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.editparts;

import com.ibm.etools.webedit.editparts.ElementEditPart;
import com.ibm.etools.webedit.editparts.HTMLGraphicalViewer;
import com.ibm.etools.webedit.editparts.ViewerUtil;
import com.ibm.etools.webedit.viewer.internal.utils.Logger;
import com.ibm.etools.xve.renderer.figures.IFlowFigure;
import com.ibm.etools.xve.renderer.style.FontAttr;
import com.ibm.etools.xve.renderer.style.RenderOption;
import com.ibm.etools.xve.renderer.style.XMLStyle;
import java.util.List;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FigureListener;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class SubModelLabel
extends Figure
implements FigureListener {
    private ElementEditPart editPart;
    private Rectangle boundsRect = new Rectangle();
    private Font textFont;
    private static final int PADDING = 2;
    private static final int BORDER_WIDTH = 2;

    public SubModelLabel(ElementEditPart editPart) {
        try {
            this.editPart = editPart;
            editPart.getFigure().addFigureListener((FigureListener)this);
            this.setOpaque(true);
            this.setBorder((Border)new LineBorder(this.getStaticColor(23), 2));
            this.setForegroundColor(this.getStaticColor(21));
            this.setBackgroundColor(this.getStaticColor(22));
            this.updateFont();
        }
        catch (NullPointerException e) {
            Logger.log(e);
        }
    }

    public void dispose() {
        if (this.editPart != null && this.editPart.getFigure() != null) {
            this.editPart.getFigure().removeFigureListener((FigureListener)this);
            this.editPart = null;
        }
        if (this.textFont != null) {
            this.textFont.dispose();
            this.textFont = null;
        }
    }

    public void updateFont() {
        Font prevFont = this.textFont;
        HTMLGraphicalViewer viewer = ViewerUtil.getHTMLGraphicalViewer((EditPart)this.editPart);
        if (viewer == null) {
            return;
        }
        RenderOption viewOption = viewer.getRenderOption();
        if (viewOption == null) {
            return;
        }
        FontAttr fontAttr = viewOption.getBaseFontPropotional();
        if (fontAttr == null) {
            return;
        }
        FontData fontData = new FontData(fontAttr.getFace(), fontAttr.getPoints(), 0);
        this.textFont = new Font((Device)Display.getDefault(), fontData);
        this.setFont(this.textFont);
        if (prevFont != null) {
            prevFont.dispose();
        }
    }

    public void figureMoved(IFigure source) {
        this.setBoundsLocation();
    }

    protected void paintFigure(Graphics graphics) {
        int y;
        String text;
        Dimension textDim;
        Rectangle rect;
        Rectangle imageRect = null;
        Image image = this.getImage();
        if (image != null) {
            imageRect = new Rectangle(image.getBounds());
        }
        if ((rect = this.calculateBoundsSize(imageRect, textDim = this.getTextExtents(text = this.getText()))) == null || rect.isEmpty()) {
            return;
        }
        graphics.fillRectangle(rect);
        int x = 0;
        if (image != null) {
            y = rect.y + (rect.height - image.getBounds().height) / 2;
            graphics.drawImage(image, x += rect.x + 2, y);
            x += image.getBounds().width;
        }
        if (text != null && text.length() > 0) {
            y = rect.y + (rect.height - textDim.height) / 2;
            graphics.drawString(text, x, y);
        }
        this.setBounds(rect);
    }

    private Color getStaticColor(int value) {
        return Display.getCurrent().getSystemColor(value);
    }

    private Image getImage() {
        if (this.editPart == null) {
            return null;
        }
        XMLStyle style = this.editPart.getStyle();
        return style != null ? style.getImage(0) : null;
    }

    private String getText() {
        if (this.editPart == null) {
            return null;
        }
        XMLStyle style = this.editPart.getStyle();
        return style != null ? style.getText(0) : null;
    }

    private void setBoundsLocation() {
        if (this.editPart == null) {
            return;
        }
        if (!(this.editPart.getFigure() instanceof IFlowFigure)) {
            return;
        }
        IFlowFigure figure = (IFlowFigure)this.editPart.getFigure();
        List list = figure.getFragments();
        if (list == null || list.isEmpty()) {
            return;
        }
        Object rect = list.get(0);
        if (rect instanceof Rectangle) {
            this.boundsRect.setLocation(((Rectangle)rect).getTopLeft());
        }
    }

    private Dimension getTextExtents(String text) {
        Dimension textDim = null;
        if (text != null && text.length() > 0 && this.getFont() != null) {
            textDim = FigureUtilities.getStringExtents((String)text, (Font)this.getFont());
        }
        return textDim;
    }

    private Rectangle calculateBoundsSize(Rectangle imageRect, Dimension textDim) {
        if (imageRect == null && textDim == null) {
            this.boundsRect.setSize(0, 0);
        } else {
            int width = imageRect != null ? imageRect.width : 0;
            width += textDim != null ? textDim.width : 0;
            int height = imageRect != null ? imageRect.height : 0;
            height = Math.max(height, textDim != null ? textDim.height : 0);
            this.boundsRect.setSize(width += 4, height += 4);
        }
        return this.boundsRect;
    }
}

