/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.editparts;

import com.ibm.etools.webedit.editparts.DocumentEditPart;
import com.ibm.etools.webedit.editparts.ElementEditPart;
import com.ibm.etools.webedit.editparts.PartAnalyzer;
import com.ibm.etools.webedit.render.style.ViewOption;
import com.ibm.etools.xve.renderer.internal.VisualCueUtil;
import com.ibm.etools.xve.renderer.style.StyleOwner;
import java.util.BitSet;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FigureListener;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Display;

public class SubModelHighlighter
extends Figure
implements FigureListener {
    private ElementEditPart editPart;
    private ViewOption viewOption;
    private boolean drawBorder;
    private Color color;
    private Color staticColor;
    private int lineStyle;
    private int lineWidth;
    private VisualCueUtil.EdgeInfo edgeInfo;
    private BitSet state = new BitSet();
    private static final int STYLE_UNSELECTED = 3;
    private static final int LINE_WIDTH_UNSELECTED = 1;
    private static final int LINE_WIDTH_SELECTED = 3;
    public static final int STATE_SELECTED = 0;
    public static final int STATE_EDITING = 1;

    public SubModelHighlighter(ElementEditPart editPart, ViewOption viewOption) {
        this.editPart = editPart;
        this.viewOption = viewOption;
        if (editPart != null && editPart.getFigure() != null) {
            editPart.getFigure().addFigureListener((FigureListener)this);
        }
        this.staticColor = this.getStaticColor(18);
        this.lineStyle = 3;
        this.lineWidth = 1;
    }

    public void dispose() {
        if (this.editPart != null && this.editPart.getFigure() != null) {
            this.editPart.getFigure().removeFigureListener((FigureListener)this);
        }
        this.editPart = null;
        this.viewOption = null;
        if (this.color != null && !this.color.isDisposed()) {
            this.color.dispose();
            this.color = null;
        }
    }

    public void setSelection(boolean selected) {
        if (selected) {
            this.state.set(0);
            this.staticColor = this.getStaticColor(21);
            this.lineStyle = 1;
            this.lineWidth = 3;
        } else {
            this.state.clear(0);
            this.staticColor = this.getStaticColor(18);
            this.lineStyle = 3;
            this.lineWidth = 1;
        }
        this.setBoundsRect();
        this.update(true);
    }

    public void setEditingState(boolean editingState) {
        if (editingState) {
            this.state.set(1);
        } else {
            this.state.clear(1);
        }
        this.update(true);
    }

    public void update(boolean redraw) {
        if (this.viewOption == null) {
            return;
        }
        this.drawBorder = this.state.get(0) ? this.viewOption.showEmbeddedDocument() && this.editPart != null && this.editPart.hasSubModel() : !this.state.get(1) && this.checkViewOption();
        if (redraw) {
            this.repaint();
        }
    }

    public void figureMoved(IFigure source) {
        this.updateEdgeInfo();
        this.setBoundsRect();
        this.update(true);
    }

    private boolean checkViewOption() {
        DocumentEditPart childPart;
        if (!this.viewOption.showEmbeddedDocument() || !this.viewOption.isExtraBorder(8)) {
            return false;
        }
        if (this.editPart == null || !this.editPart.hasSubModel()) {
            return false;
        }
        return !this.viewOption.isExtraBorder(10) || !((childPart = PartAnalyzer.getChildDocumentEditPart((EditPart)this.editPart)) instanceof StyleOwner) || !((StyleOwner)childPart).isMaskedPart();
    }

    private void updateEdgeInfo() {
        if (this.editPart != null) {
            this.edgeInfo = VisualCueUtil.getEdgeInfo((IFigure)this.editPart.getFigure(), (int)1);
        }
    }

    private void setBoundsRect() {
        if (this.edgeInfo != null && this.edgeInfo.clip != null) {
            Rectangle rect = this.edgeInfo.clip.getCopy();
            if (this.lineWidth > 1) {
                rect.expand(this.lineWidth, this.lineWidth);
            }
            this.setBounds(rect);
        }
    }

    private Color getStaticColor(int value) {
        return Display.getCurrent().getSystemColor(value);
    }

    public boolean containsPoint(int x, int y) {
        return false;
    }

    public void paint(Graphics graphics) {
        if (graphics == null || this.edgeInfo == null) {
            return;
        }
        if (this.drawBorder) {
            graphics.pushState();
            graphics.setForegroundColor(this.staticColor);
            graphics.setLineWidth(this.lineWidth);
            graphics.setLineStyle(this.lineStyle);
            VisualCueUtil.drawPolyline((Graphics)graphics, (VisualCueUtil.EdgeInfo)this.edgeInfo);
            graphics.popState();
        }
    }

    public boolean isSelected() {
        return this.state.get(0);
    }
}

