/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.editparts;

import com.ibm.etools.webedit.editparts.ElementEditPart;
import com.ibm.etools.webedit.editparts.HTMLGraphicalViewerImpl;
import com.ibm.etools.webedit.editparts.SubModelHighlighter;
import com.ibm.etools.webedit.editparts.SubModelLabel;
import com.ibm.etools.webedit.viewer.internal.utils.Logger;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.draw2d.IFigure;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.editparts.LayerManager;

public class SubModelDecoratorFactory {
    private HTMLGraphicalViewerImpl viewer;
    private Map subModelHighlighters;
    private Map subModelLabels;

    public SubModelDecoratorFactory(HTMLGraphicalViewerImpl viewer) {
        this.viewer = viewer;
    }

    private Map getHighlighters() {
        if (this.subModelHighlighters == null) {
            this.subModelHighlighters = new HashMap();
        }
        return this.subModelHighlighters;
    }

    private Map getLabels() {
        if (this.subModelLabels == null) {
            this.subModelLabels = new HashMap();
        }
        return this.subModelLabels;
    }

    private IFigure getLayer(Object key) {
        try {
            Map registry = this.viewer.getEditPartRegistry();
            LayerManager manager = (LayerManager)registry.get(LayerManager.ID);
            return manager.getLayer(key);
        }
        catch (NullPointerException e) {
            Logger.log(e);
            return null;
        }
    }

    public SubModelHighlighter getSubModelHighlighter(ElementEditPart editPart) {
        if (this.viewer == null || this.viewer.getControl() == null || this.viewer.getControl().isDisposed()) {
            return null;
        }
        Map highlighters = this.getHighlighters();
        if (highlighters.containsKey(editPart)) {
            return (SubModelHighlighter)((Object)highlighters.get(editPart));
        }
        SubModelHighlighter highlighter = new SubModelHighlighter(editPart, this.viewer.getViewOption());
        highlighters.put(editPart, highlighter);
        IFigure layer = this.getLayer("Feedback Layer");
        if (layer != null) {
            layer.add((IFigure)highlighter);
        }
        return highlighter;
    }

    public SubModelHighlighter getExistingSubModelHighlighter(EditPart editPart) {
        Map highlighters = this.getHighlighters();
        if (highlighters.containsKey(editPart)) {
            return (SubModelHighlighter)((Object)highlighters.get(editPart));
        }
        return null;
    }

    public void releaseSubModelHighlighter(ElementEditPart editPart) {
        Map highlighters = this.getHighlighters();
        if (highlighters.containsKey(editPart)) {
            SubModelHighlighter highlighter = (SubModelHighlighter)((Object)highlighters.remove(editPart));
            highlighter.setVisible(false);
            IFigure layer = this.getLayer("Feedback Layer");
            if (layer != null) {
                layer.remove((IFigure)highlighter);
            }
            highlighter.dispose();
        }
    }

    public void updateSubModelHighlighters() {
        if (this.subModelHighlighters != null) {
            Collection values = this.subModelHighlighters.values();
            for (Object object : values) {
                if (!(object instanceof SubModelHighlighter)) continue;
                ((SubModelHighlighter)((Object)object)).update(true);
            }
        }
    }

    public void dispose() {
        this.disposeSubModelHighlighters();
    }

    public void disposeSubModelHighlighters() {
        if (this.subModelHighlighters != null) {
            IFigure layer = this.getLayer("Feedback Layer");
            Collection values = this.subModelHighlighters.values();
            for (Object object : values) {
                if (!(object instanceof SubModelHighlighter)) continue;
                SubModelHighlighter highlighter = (SubModelHighlighter)((Object)object);
                highlighter.setVisible(false);
                if (layer != null) {
                    layer.remove((IFigure)highlighter);
                }
                highlighter.dispose();
            }
            this.subModelHighlighters.clear();
            this.subModelHighlighters = null;
        }
    }

    public SubModelLabel getSubModelLabels(ElementEditPart editPart) {
        if (this.viewer == null || this.viewer.getControl() == null || this.viewer.getControl().isDisposed()) {
            return null;
        }
        Map labels = this.getLabels();
        if (labels.containsKey(editPart)) {
            return (SubModelLabel)((Object)labels.get(editPart));
        }
        SubModelLabel label = new SubModelLabel(editPart);
        labels.put(editPart, label);
        IFigure layer = this.getLayer("Feedback Layer");
        if (layer != null) {
            layer.add((IFigure)label);
        }
        return label;
    }

    public void releaseSubModelLabel(ElementEditPart editPart) {
        Map labels = this.getLabels();
        if (labels.containsKey(editPart)) {
            SubModelLabel label = (SubModelLabel)((Object)labels.remove(editPart));
            label.setVisible(false);
            IFigure layer = this.getLayer("Feedback Layer");
            if (layer != null) {
                layer.remove((IFigure)label);
            }
            label.dispose();
        }
    }
}

