/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.editparts;

import com.ibm.etools.webedit.editparts.DocumentEditPart;
import com.ibm.etools.webedit.editparts.ElementEditPart;
import com.ibm.etools.webedit.editparts.NodeEditPart;
import com.ibm.etools.webedit.editparts.OffRenderingEditPart;
import com.ibm.etools.webedit.editparts.ViewerUtil;
import com.ibm.etools.webedit.editparts.VisibleNodeEditPart;
import com.ibm.etools.webedit.editparts.design.IDesignTimeTagAdapterInContext;
import com.ibm.etools.webedit.viewer.internal.utils.ElementAliasUtil;
import com.ibm.etools.xve.renderer.figures.IFlowFigure;
import com.ibm.etools.xve.renderer.style.Style;
import com.ibm.etools.xve.renderer.style.XMLStyle;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.RootEditPart;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class PartAnalyzer {
    public static boolean canHaveCursor(EditPart part) {
        Object obj;
        IDesignTimeTagAdapterInContext dta;
        String tagName;
        EditPart parent;
        if (part == null) {
            return false;
        }
        Node node = PartAnalyzer.getNode(part);
        if (node == null) {
            return false;
        }
        if (part instanceof OffRenderingEditPart) {
            return false;
        }
        if (PartAnalyzer.isStable(part) && !PartAnalyzer.isVisible(part)) {
            return false;
        }
        if (PartAnalyzer.isCaretRoot(part)) {
            return true;
        }
        switch (node.getNodeType()) {
            case 3: 
            case 8: {
                return PartAnalyzer.isDataEditable(part);
            }
        }
        if (PartAnalyzer.isReadOnly(part) && ((parent = part.getParent()) == null || PartAnalyzer.isReadOnly(parent))) {
            return false;
        }
        int style = PartAnalyzer.getDisplayType(part);
        if (style < 0 || style == 14) {
            return false;
        }
        if (style == 23) {
            tagName = node.getNodeName();
            if (tagName.equalsIgnoreCase("BUTTON")) {
                return true;
            }
        } else if (style == 1 && (tagName = node.getNodeName()).equalsIgnoreCase("DL")) {
            return false;
        }
        if (style == 31 && (dta = ((ElementEditPart)part).getDesignTimeTagAdapter()) != null && (obj = dta.getAttribute("canHaveCursor")) instanceof String) {
            return ((String)obj).equalsIgnoreCase("true");
        }
        return style != 20 && style != 4 && style != 6 && style != 7 && style != 8 && style != 9 && style != 10 && style != 11 && style != 21 && style != 22;
    }

    public static boolean canSelectMultiply(EditPart part) {
        int style = PartAnalyzer.getDisplayType(part);
        if (style < 0) {
            return false;
        }
        return PartAnalyzer.isVisible(part);
    }

    public static boolean canSetCaretToChild(EditPart part) {
        String tagName;
        if (part == null) {
            return false;
        }
        if (part instanceof OffRenderingEditPart) {
            return true;
        }
        if (part instanceof DocumentEditPart) {
            return ((DocumentEditPart)part).acceptsCaret();
        }
        if (PartAnalyzer.isStable(part) && !PartAnalyzer.isVisible(part)) {
            return false;
        }
        if (PartAnalyzer.isCaretRoot(part)) {
            return true;
        }
        int style = PartAnalyzer.getDisplayType(part);
        if (style < 0 || style == 14) {
            return false;
        }
        Node node = PartAnalyzer.getNode(part);
        if (node.getNodeType() == 5) {
            return false;
        }
        if (PartAnalyzer.isSubModelContainer(part)) {
            return false;
        }
        if (style == 23 && (tagName = node.getNodeName()).equalsIgnoreCase("BUTTON")) {
            return true;
        }
        return style != 10 && style != 11 && style != 15 && style != 16 && style != 18 && style != 20 && style != 21 && style != 23 && style != 27 && style != 28 && style != 30;
    }

    public static boolean canInsert(EditPart part) {
        return PartAnalyzer.isText(part) || PartAnalyzer.canHaveCursor(part) && PartAnalyzer.canSetCaretToChild(part);
    }

    public static boolean canShowFocusFrame(EditPart part) {
        switch (PartAnalyzer.getDisplayType(part)) {
            case 20: {
                return false;
            }
            case 23: {
                switch (PartAnalyzer.getUIType(part)) {
                    case 43: 
                    case 44: {
                        return false;
                    }
                }
                break;
            }
        }
        return true;
    }

    private static final EditPart getCaretRootFromChild(EditPart part) {
        for (EditPart p : part.getChildren()) {
            if (PartAnalyzer.isCaretRoot(p)) {
                return p;
            }
            if ((p = PartAnalyzer.getCaretRootFromChild(p)) == null) continue;
            return p;
        }
        return null;
    }

    private static final int getUIType(EditPart part) {
        Style style = PartAnalyzer.getStyle(part);
        return style != null ? style.getUIType(110) : -1;
    }

    public static final int getDisplayType(EditPart part) {
        Style style = PartAnalyzer.getStyle(part);
        return style != null ? style.getDisplayType() : -1;
    }

    private static final int getPositionType(EditPart part) {
        Style style = PartAnalyzer.getStyle(part);
        return style != null ? style.getPositionType() : -1;
    }

    private static final Style getStyle(EditPart part) {
        return part instanceof ElementEditPart ? ((ElementEditPart)part).getStyle() : null;
    }

    public static EditPart getTableCel(EditPart part) {
        while (part != null) {
            if (PartAnalyzer.isTableCel(part)) {
                return part;
            }
            part = part.getParent();
        }
        return null;
    }

    public static EditPart getTableRoot(EditPart part) {
        while (part != null) {
            if (PartAnalyzer.isTableRoot(part)) {
                return part;
            }
            part = part.getParent();
        }
        return null;
    }

    public static EditPart getTableSelectionRoot(EditPart part) {
        while (part != null) {
            if (PartAnalyzer.isTableSelectionRoot(part)) {
                return part;
            }
            part = part.getParent();
        }
        return null;
    }

    public static boolean isAbsolute(EditPart part) {
        int position = PartAnalyzer.getPositionType(part);
        return position == 2 || position == 3;
    }

    public static boolean isBlock(EditPart part) {
        if (part instanceof OffRenderingEditPart) {
            return false;
        }
        return !PartAnalyzer.isInline(part);
    }

    public static boolean isInlineBlock(EditPart part) {
        Node node = PartAnalyzer.getNode(part);
        if (node == null) {
            return false;
        }
        if (part instanceof OffRenderingEditPart) {
            return false;
        }
        if (node.getNodeType() == 1) {
            int style = PartAnalyzer.getDisplayType(part);
            if (style < 0) {
                return false;
            }
            if (style == 23 && PartAnalyzer.getUIType(part) == 39) {
                return true;
            }
            return style == 13 || style == 27;
        }
        return false;
    }

    private static boolean acceptCaret(EditPart part) {
        if (part instanceof OffRenderingEditPart) {
            return false;
        }
        if (part instanceof VisibleNodeEditPart) {
            return true;
        }
        if (part instanceof DocumentEditPart) {
            return ((DocumentEditPart)part).acceptsCaret();
        }
        return false;
    }

    public static boolean isCaretRoot(EditPart part) {
        if (part == null) {
            return false;
        }
        if (!PartAnalyzer.acceptCaret(part)) {
            return false;
        }
        if (part instanceof DocumentEditPart) {
            return true;
        }
        part = part.getParent();
        while (part != null) {
            if (PartAnalyzer.acceptCaret(part)) {
                return false;
            }
            if (part instanceof DocumentEditPart) break;
            part = part.getParent();
        }
        return true;
    }

    public static boolean isTrackerRoot(EditPart part) {
        if (part == null) {
            return false;
        }
        return PartAnalyzer.isCaretRoot(part) || PartAnalyzer.isTableCaption(part);
    }

    public static boolean isCaretVisible(EditPart part) {
        if (part == null) {
            return false;
        }
        Node node = PartAnalyzer.getNode(part);
        if (node == null) {
            return false;
        }
        if (PartAnalyzer.getDisplayType(part) == 16) {
            return true;
        }
        return node.getNodeType() == 3 || PartAnalyzer.canHaveCursor(part) && PartAnalyzer.canSetCaretToChild(part);
    }

    public static boolean isFloat(EditPart part) {
        int position = PartAnalyzer.getPositionType(part);
        return position == 5 || position == 6;
    }

    public static boolean isImplicit(EditPart part) {
        Node node = PartAnalyzer.getNode(part);
        if (node == null) {
            return false;
        }
        return node.getNodeType() == 1 && ((IDOMElement)node).isImplicitTag();
    }

    public static boolean isInline(EditPart part) {
        Node node = PartAnalyzer.getNode(part);
        if (node == null) {
            return false;
        }
        if (part instanceof OffRenderingEditPart) {
            return false;
        }
        switch (node.getNodeType()) {
            case 3: 
            case 8: {
                return true;
            }
            case 1: {
                int style = PartAnalyzer.getDisplayType(part);
                if (style < 0) {
                    return false;
                }
                return style == 2 || style == 13 || style == 15 || style == 16 || style == 17 || style == 18 || style == 19 || style == 33 || style == 20 || style == 23 || style == 26 || style == 28 || style == 29 || style == 31;
            }
        }
        return false;
    }

    public static boolean isText(EditPart part) {
        Node node = PartAnalyzer.getNode(part);
        return node != null ? node.getNodeType() == 3 : false;
    }

    public static boolean isLink(EditPart part) {
        Node node = PartAnalyzer.getNode(part);
        if (node == null) {
            return false;
        }
        switch (node.getNodeType()) {
            case 3: {
                return false;
            }
            case 1: {
                return node.getNodeName().equalsIgnoreCase("A");
            }
        }
        return false;
    }

    public static boolean isInlineText(EditPart part) {
        Node node = PartAnalyzer.getNode(part);
        if (node == null) {
            return false;
        }
        switch (node.getNodeType()) {
            case 3: {
                return true;
            }
            case 1: {
                int style = PartAnalyzer.getDisplayType(part);
                if (style < 0) {
                    return false;
                }
                return style == 2 || style == 29 || style == 31;
            }
        }
        return false;
    }

    public static boolean isLineBreak(EditPart part) {
        return PartAnalyzer.getDisplayType(part) == 20;
    }

    public static boolean isLogical(EditPart part) {
        return false;
    }

    public static boolean isSolid(EditPart part) {
        return !PartAnalyzer.isText(part) && !PartAnalyzer.canSetCaretToChild(part);
    }

    public static boolean isTableCaption(EditPart part) {
        return PartAnalyzer.getDisplayType(part) == 12;
    }

    public static boolean isTableRow(EditPart part) {
        return PartAnalyzer.getDisplayType(part) == 6;
    }

    public static boolean isTableCel(EditPart part) {
        return PartAnalyzer.getDisplayType(part) == 5;
    }

    public static boolean isTableBody(EditPart part) {
        return PartAnalyzer.getDisplayType(part) == 9;
    }

    public static boolean isTableHead(EditPart part) {
        return PartAnalyzer.getDisplayType(part) == 7;
    }

    public static boolean isTableFoot(EditPart part) {
        return PartAnalyzer.getDisplayType(part) == 8;
    }

    public static boolean isTableRoot(EditPart part) {
        return PartAnalyzer.getDisplayType(part) == 4;
    }

    public static boolean isBottomCaption(EditPart part) {
        if (!PartAnalyzer.isTableCaption(part)) {
            return false;
        }
        Node node = PartAnalyzer.getNode(part);
        NamedNodeMap attr = node.getAttributes();
        if (attr == null || attr.getLength() == 0) {
            return false;
        }
        Node align = attr.getNamedItem("align");
        return align != null && align.getNodeValue().equalsIgnoreCase("bottom");
    }

    public static boolean isTableSelectionRoot(EditPart part) {
        int style = PartAnalyzer.getDisplayType(part);
        return style == 4;
    }

    public static boolean isTableParts(EditPart part) {
        int style = PartAnalyzer.getDisplayType(part);
        return style == 4 || style == 5 || style == 6 || style == 7 || style == 8 || style == 9 || style == 10 || style == 11 || style == 12;
    }

    public static boolean isList(EditPart part) {
        return PartAnalyzer.getDisplayType(part) == 22;
    }

    public static boolean isListItem(EditPart part) {
        return PartAnalyzer.getDisplayType(part) == 3;
    }

    public static boolean isVisible(EditPart part) {
        if (PartAnalyzer.isOrphan(part)) {
            return false;
        }
        if (part instanceof OffRenderingEditPart) {
            return false;
        }
        IFigure figure = ((GraphicalEditPart)part).getFigure();
        if (figure == null) {
            return false;
        }
        return figure.isVisible();
    }

    public static boolean matchType(EditPart part1, EditPart part2) {
        if (part1 == null || part2 == null) {
            return false;
        }
        return PartAnalyzer.getDisplayType(part1) == PartAnalyzer.getDisplayType(part2);
    }

    public static EditPart validate(EditPart part) {
        EditPart validPart = null;
        EditPart p = part;
        while (p != null) {
            if (PartAnalyzer.isCaretRoot(p)) {
                return validPart == null ? part : validPart;
            }
            if (!PartAnalyzer.canSetCaretToChild(p)) {
                validPart = p;
            }
            if (p instanceof DocumentEditPart) {
                if (!(part instanceof OffRenderingEditPart)) break;
                part = p;
                break;
            }
            p = p.getParent();
        }
        if (part != null) {
            validPart = PartAnalyzer.getCaretRootFromChild(part);
        }
        if (validPart != null) {
            return validPart;
        }
        try {
            return part.getRoot().getContents();
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    public static boolean isStable(EditPart part) {
        IFigure figure;
        if (part != null && (figure = ((GraphicalEditPart)part).getFigure()) instanceof IFlowFigure) {
            List fragments = ((IFlowFigure)figure).getFragments();
            return fragments != null && !fragments.isEmpty();
        }
        return false;
    }

    public static boolean isImageIconHidden(EditPart part) {
        if (part != null) {
            Image img;
            Node n = PartAnalyzer.getNode(part);
            if (n == null) {
                return false;
            }
            if (n.getNodeType() == 1 && (PartAnalyzer.getDisplayType(part) == 16 || PartAnalyzer.getDisplayType(part) == 18) && (img = PartAnalyzer.getStyle(part).getImage(0)) == null) {
                return true;
            }
        }
        return false;
    }

    public static boolean isOrphan(EditPart part) {
        while (part != null) {
            if (part instanceof RootEditPart) {
                return false;
            }
            part = part.getParent();
        }
        return true;
    }

    public static boolean isCard(EditPart part) {
        int type;
        return part != null && (type = PartAnalyzer.getDisplayType(part)) == 32;
    }

    public static boolean isReadOnly(EditPart part) {
        return !PartAnalyzer.isChildEditable(part) && !PartAnalyzer.isDataEditable(part);
    }

    private static boolean isDataEditable(EditPart editPart) {
        IDOMNode xmlNode = PartAnalyzer.getIDOMNode(editPart);
        return xmlNode != null ? xmlNode.isDataEditable() : false;
    }

    private static boolean isChildEditable(EditPart editPart) {
        IDOMNode xmlNode = PartAnalyzer.getIDOMNode(editPart);
        return xmlNode != null ? xmlNode.isChildEditable() : false;
    }

    private static Node getNode(EditPart editPart) {
        try {
            return ((NodeEditPart)editPart).getNode();
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
        catch (ClassCastException classCastException) {
            return null;
        }
    }

    private static IDOMNode getIDOMNode(EditPart editPart) {
        try {
            return (IDOMNode)((NodeEditPart)editPart).getNode();
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
        catch (ClassCastException classCastException) {
            return null;
        }
    }

    public static DocumentEditPart getDocumentEditPart(EditPart editPart) {
        EditPart part = editPart;
        while (part != null) {
            if (part instanceof DocumentEditPart) {
                return (DocumentEditPart)part;
            }
            part = part.getParent();
        }
        return null;
    }

    public static DocumentEditPart getRootDocumentEditPart(EditPart editPart) {
        EditPart part = editPart;
        while (part != null) {
            DocumentEditPart documentEditPart = PartAnalyzer.getDocumentEditPart(part);
            if (documentEditPart == null) {
                return null;
            }
            if (!documentEditPart.isEmbeddedDocument()) {
                return documentEditPart;
            }
            part = documentEditPart.getParent();
        }
        return null;
    }

    public static DocumentEditPart getChildDocumentEditPart(EditPart editPart) {
        List children;
        if (editPart == null) {
            return null;
        }
        if (!PartAnalyzer.isSubModelContainer(editPart)) {
            ElementEditPart elementEditPart;
            try {
                elementEditPart = (ElementEditPart)editPart;
            }
            catch (ClassCastException classCastException) {
                elementEditPart = null;
            }
            if (elementEditPart == null) {
                return null;
            }
            if (elementEditPart.hasVisualizer()) {
                List children2 = editPart.getChildren();
                int length = children2 != null ? children2.size() : 0;
                int i = 0;
                while (i < length) {
                    EditPart part = (EditPart)children2.get(i);
                    if (PartAnalyzer.isSubModelContainer(part)) {
                        editPart = part;
                        break;
                    }
                    ++i;
                }
                if (i == length) {
                    return null;
                }
            }
        }
        if ((children = editPart.getChildren()) != null) {
            for (NodeEditPart childPart : children) {
                if (!(childPart instanceof DocumentEditPart) || !childPart.isEmbeddedDocument()) continue;
                return (DocumentEditPart)childPart;
            }
        }
        return null;
    }

    public static EditPart getParentOfEmbeddedDocumentEditPart(EditPart editPart) {
        DocumentEditPart documentEditPart = PartAnalyzer.getDocumentEditPart(editPart);
        if (documentEditPart == null || !documentEditPart.isEmbeddedDocument()) {
            return null;
        }
        return documentEditPart.getParent();
    }

    public static boolean isDesignTimePart(EditPart editPart) {
        DocumentEditPart docPart = PartAnalyzer.getDocumentEditPart(editPart);
        if (docPart == null) {
            return false;
        }
        Node node = PartAnalyzer.getNode(editPart);
        if (node == null) {
            return false;
        }
        Document doc = node.getOwnerDocument();
        if (doc == null) {
            return false;
        }
        return doc != docPart.getNode();
    }

    public static boolean isStyleSheetTarget(EditPart editPart) {
        IDOMElement ele = null;
        try {
            ele = (IDOMElement)((NodeEditPart)editPart).getNode();
        }
        catch (ClassCastException classCastException) {}
        if (ele != null) {
            return ele.isGlobalTag() && !ele.isJSPTag() || ElementAliasUtil.aliasName((Element)ele) != null;
        }
        return false;
    }

    public static boolean isAncestor(EditPart targetPart, EditPart childPart) {
        while (childPart != null) {
            if (targetPart == childPart) {
                return true;
            }
            childPart = childPart.getParent();
        }
        return false;
    }

    public static boolean isSubModelContainer(EditPart editPart) {
        return editPart instanceof NodeEditPart ? ((NodeEditPart)editPart).getSubModelAdapter() != null : false;
    }

    public static boolean isActiveEditPart(EditPart editPart) {
        DocumentEditPart documentEditPart = PartAnalyzer.getDocumentEditPart(editPart);
        return documentEditPart != null && documentEditPart == ViewerUtil.getActiveDocumentEditPart(editPart);
    }

    public static EditPart getActiveParent(EditPart editPart) {
        while (editPart != null) {
            if (PartAnalyzer.isActiveEditPart(editPart)) {
                return editPart;
            }
            editPart = PartAnalyzer.getParentOfEmbeddedDocumentEditPart(editPart);
        }
        return null;
    }

    public static boolean isRightToLeft(EditPart editPart) {
        XMLStyle style;
        if (editPart instanceof ElementEditPart && (style = ((ElementEditPart)editPart).getStyle()) != null) {
            return style.getBidiType(111) == 4;
        }
        return false;
    }

    public static boolean isSecretInline(EditPart editPart) {
        return PartAnalyzer.getDisplayType(editPart) == 34;
    }
}

