/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.editparts;

import java.util.List;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;

public class EditPartIterator {
    EditPart parent;
    int index;

    public EditPartIterator(EditPartViewer viewer) {
        this.parent = viewer.getRootEditPart();
        this.index = 0;
    }

    public EditPartIterator(EditPart parent, int index) {
        this.parent = parent;
        this.index = index;
    }

    public EditPartIterator(EditPart part) {
        if (part != null) {
            this.parent = part.getParent();
            if (this.parent != null) {
                this.index = this.parent.getChildren().indexOf(part);
            }
        }
    }

    public boolean hasNext() {
        return this.parent != null && this.parent.getChildren() != null && this.index < this.parent.getChildren().size();
    }

    public boolean hasPrev() {
        return this.parent != null && this.parent.getChildren() != null && this.index >= 0 && this.index < this.parent.getChildren().size();
    }

    public EditPart next() {
        if (!this.hasNext()) {
            return null;
        }
        EditPart ret = (EditPart)this.parent.getChildren().get(this.index);
        List children = ret.getChildren();
        if (children != null && children.size() > 0) {
            this.parent = ret;
            this.index = 0;
        } else {
            EditPart up = this.parent;
            int i = this.index;
            while (up != null) {
                if (i + 1 < up.getChildren().size()) {
                    this.parent = up;
                    this.index = i + 1;
                    break;
                }
                EditPart current = up;
                if ((up = current.getParent()) == null) {
                    this.parent = null;
                    break;
                }
                i = up.getChildren().indexOf(current);
            }
        }
        return ret;
    }

    public EditPart prev() {
        if (!this.hasPrev()) {
            return null;
        }
        EditPart ret = (EditPart)this.parent.getChildren().get(this.index);
        List children = ret.getChildren();
        if (children != null && children.size() > 0) {
            this.parent = ret;
            this.index = children.size() - 1;
        } else {
            EditPart up = this.parent;
            int i = this.index;
            while (up != null) {
                if (i - 1 >= 0 && i - 1 < up.getChildren().size()) {
                    this.parent = up;
                    this.index = i - 1;
                    break;
                }
                EditPart current = up;
                if ((up = current.getParent()) == null) {
                    this.parent = null;
                    break;
                }
                i = up.getChildren().indexOf(current);
            }
        }
        return ret;
    }
}

