/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.editparts;

import com.ibm.etools.webedit.editparts.DocumentEditPart;
import com.ibm.etools.webedit.editparts.NodeEditPart;
import com.ibm.etools.webedit.editparts.PartAnalyzer;
import com.ibm.etools.webedit.editparts.ViewerUtil;
import com.ibm.etools.webedit.viewer.internal.utils.ModelManagerUtil;
import com.ibm.etools.webedit.viewer.utils.LinkUtil;
import com.ibm.etools.xve.renderer.utils.URLContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.gef.EditPart;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.contentmodel.CMElementDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.modelquery.ModelQuery;
import org.eclipse.wst.xml.core.internal.modelquery.ModelQueryUtil;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ContextUtil {
    public static final int CONTEXT_LINK = 1;
    public static final int CONTEXT_PAGE = 2;
    public static final int CONTEXT_FILE = 3;

    public static DocumentEditPart getFileContext(EditPart part) {
        return PartAnalyzer.getDocumentEditPart(part);
    }

    public static DocumentEditPart getPageContext(EditPart part) {
        DocumentEditPart docPart = PartAnalyzer.getDocumentEditPart(part);
        while (docPart != null) {
            EditPart refPart = docPart.getParent();
            if (!(refPart instanceof NodeEditPart)) break;
            Node node = ((NodeEditPart)refPart).getNode();
            if (node.getNodeType() == 1) {
                if (ContextUtil.isJspInclude(node)) {
                    return docPart;
                }
                if (node.getNodeName().equalsIgnoreCase("OBJECT") || node.getNodeName().equalsIgnoreCase("IFRAME")) {
                    return docPart;
                }
            }
            docPart = PartAnalyzer.getDocumentEditPart(refPart);
        }
        return docPart;
    }

    public static DocumentEditPart getLinkContext(EditPart part) {
        DocumentEditPart docPart = PartAnalyzer.getDocumentEditPart(part);
        while (docPart != null) {
            EditPart refPart = docPart.getParent();
            if (!(refPart instanceof NodeEditPart)) break;
            Node node = ((NodeEditPart)refPart).getNode();
            if (node.getNodeType() == 1 && (node.getNodeName().equalsIgnoreCase("OBJECT") || node.getNodeName().equalsIgnoreCase("IFRAME"))) {
                return docPart;
            }
            docPart = PartAnalyzer.getDocumentEditPart(refPart);
        }
        return docPart;
    }

    public static boolean isJspInclude(Node node) {
        CMElementDeclaration decl;
        ModelQuery query;
        if (node.getNodeType() == 1 && node.getNodeName().equals("jsp:include") && (query = ModelQueryUtil.getModelQuery((Document)node.getOwnerDocument())) != null && (decl = query.getCMElementDeclaration((Element)node)) != null && decl.supports("isJSP")) {
            Boolean value = (Boolean)decl.getProperty("isJSP");
            return value != null && value != false;
        }
        return false;
    }

    public static boolean isJspInclude(EditPart editPart) {
        if (editPart == null || !(editPart instanceof NodeEditPart)) {
            return false;
        }
        Node node = ((NodeEditPart)editPart).getNode();
        return node != null ? ContextUtil.isJspInclude(node) : false;
    }

    public static List getTaglibRelatedDocuments(EditPart editPart) {
        if (editPart == null) {
            return Collections.EMPTY_LIST;
        }
        DocumentEditPart baseEditPart = ContextUtil.getPageContext(editPart);
        ArrayList taglibDocs = new ArrayList();
        ContextUtil.getTaglibRelatedDocuments(baseEditPart, taglibDocs);
        return taglibDocs;
    }

    private static void getTaglibRelatedDocuments(DocumentEditPart documentEditPart, List taglibDocs) {
        if (documentEditPart == null) {
            return;
        }
        taglibDocs.add(documentEditPart);
        List editParts = documentEditPart.getDocumentEditPartRegistry();
        if (editParts == null) {
            return;
        }
        for (Object object : editParts) {
            DocumentEditPart editPart;
            if (!(object instanceof DocumentEditPart) || ContextUtil.isJspInclude((editPart = (DocumentEditPart)object).getParent())) continue;
            ContextUtil.getTaglibRelatedDocuments(editPart, taglibDocs);
        }
    }

    private static boolean isSameModel(IDOMModel model1, IDOMModel model2) {
        if (model1 == null) {
            return model2 == null;
        }
        return model1.equals(model2);
    }

    public static URLContext getURLContext(EditPart part) {
        if (!(part instanceof NodeEditPart)) {
            return null;
        }
        DocumentEditPart docPart = ContextUtil.getFileContext(part);
        IDOMModel model = docPart != null ? ((IDOMNode)docPart.getNode()).getModel() : ((IDOMNode)((NodeEditPart)part).getNode().getOwnerDocument()).getModel();
        String baseLocation = ModelManagerUtil.getBaseLocation((IStructuredModel)model);
        Path fileBase = new Path(baseLocation);
        docPart = ContextUtil.getPageContext(part);
        IDOMModel prevModel = model;
        model = docPart != null ? ((IDOMNode)docPart.getNode()).getModel() : ((IDOMNode)((NodeEditPart)part).getNode().getOwnerDocument()).getModel();
        Path pageBase = ContextUtil.isSameModel(prevModel, model) ? fileBase : new Path(ModelManagerUtil.getBaseLocation((IStructuredModel)model));
        docPart = ContextUtil.getLinkContext(part);
        IDOMModel iDOMModel = model = docPart != null ? ((IDOMNode)docPart.getNode()).getModel() : ((IDOMNode)((NodeEditPart)part).getNode().getOwnerDocument()).getModel();
        Path linkBase = ContextUtil.isSameModel(prevModel, model) ? new Path(LinkUtil.resolveBaseLocation((EditPart)(docPart != null ? docPart : part), baseLocation)) : new Path(LinkUtil.resolveBaseLocation((EditPart)(docPart != null ? docPart : part)));
        return new URLContext((IPath)fileBase, (IPath)pageBase, (IPath)linkBase){
            private final /* synthetic */ IPath val$fileBase;
            private final /* synthetic */ IPath val$pageBase;
            private final /* synthetic */ IPath val$linkBase;
            {
                this.val$fileBase = iPath;
                this.val$pageBase = iPath2;
                this.val$linkBase = iPath3;
            }

            public IPath getFileBase() {
                return this.val$fileBase;
            }

            public IPath getPageBase() {
                return this.val$pageBase;
            }

            public IPath getLinkBase() {
                return this.val$linkBase;
            }
        };
    }

    public static DocumentEditPart getEmbeddedContext(DocumentEditPart doc, Node node) {
        List children;
        EditPart part = (EditPart)ViewerUtil.getEditPartFor(doc, node);
        if (PartAnalyzer.isSubModelContainer(part) && (children = part.getChildren()) != null && children.size() == 1 && (part = (EditPart)children.get(0)) instanceof DocumentEditPart) {
            return (DocumentEditPart)part;
        }
        return null;
    }

    public static DocumentEditPart getEmbeddingContext(EditPart part) {
        if (part != null && PartAnalyzer.isSubModelContainer(part = part.getParent())) {
            return PartAnalyzer.getDocumentEditPart(part);
        }
        return null;
    }

    public static Node getEmbeddingNode(EditPart part) {
        if (part != null && PartAnalyzer.isSubModelContainer(part = part.getParent())) {
            return ((NodeEditPart)part).getNode();
        }
        return null;
    }
}

