/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.palette.view;

import com.ibm.etools.webedit.common.editdomain.HTMLPaletteTarget;
import com.ibm.etools.webedit.palette.HTMLPaletteViewer;
import com.ibm.etools.webedit.palette.model.PaletteItem;
import org.eclipse.draw2d.Clickable;
import org.eclipse.draw2d.IFigure;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.palette.ToolEntry;
import org.eclipse.gef.tools.SelectionTool;
import org.eclipse.gef.ui.palette.PaletteViewer;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.MouseEvent;

class PaletteSelectionTool
extends SelectionTool {
    private static final boolean invokeOnDoubleClick = true;

    PaletteSelectionTool() {
    }

    protected boolean handleKeyUp(KeyEvent e) {
        EditPartViewer viewer;
        if (e != null && e.keyCode == 27 && (viewer = this.getCurrentViewer()) instanceof HTMLPaletteViewer) {
            ((HTMLPaletteViewer)viewer).setCreationLock(false);
            HTMLPaletteTarget paletteTarget = ((HTMLPaletteViewer)viewer).getPaletteTarget();
            if (paletteTarget != null) {
                paletteTarget.loadDefaultTool();
            }
            ((HTMLPaletteViewer)viewer).deselectAllEntries();
            return true;
        }
        return super.handleKeyUp(e);
    }

    protected boolean handleButtonDown(int button) {
        EditPart part;
        EditPartViewer viewer;
        if (button == 1 && (viewer = this.getCurrentViewer()) instanceof HTMLPaletteViewer && (part = this.getTargetEditPart()) != null) {
            IFigure fig;
            if (part instanceof GraphicalEditPart && (fig = ((GraphicalEditPart)part).getFigure()) instanceof Clickable && ((Clickable)fig).isSelected()) {
                HTMLPaletteTarget paletteTarget = ((HTMLPaletteViewer)viewer).getPaletteTarget();
                if (paletteTarget != null) {
                    paletteTarget.loadDefaultTool();
                }
                ((HTMLPaletteViewer)viewer).deselectAllEntries();
                return true;
            }
            Object item = part.getModel();
            if (item instanceof PaletteItem && "WebEditPlugin.layout.pointer".equalsIgnoreCase(((PaletteItem)item).getId())) {
                HTMLPaletteTarget paletteTarget = ((HTMLPaletteViewer)viewer).getPaletteTarget();
                if (paletteTarget != null) {
                    paletteTarget.loadDefaultTool();
                }
                ((HTMLPaletteViewer)viewer).deselectAllEntries();
                return true;
            }
        }
        return super.handleButtonDown(button);
    }

    protected boolean handleButtonUp(int button) {
        return super.handleButtonUp(button);
    }

    public boolean handleNativeDragStarted(DragSourceEvent event) {
        EditPartViewer viewer = this.getCurrentViewer();
        if (viewer instanceof HTMLPaletteViewer) {
            ((HTMLPaletteViewer)viewer).setCreationLock(true);
            ((HTMLPaletteViewer)viewer).setOpaqueActiveEntry();
        }
        return super.handleNativeDragStarted(event);
    }

    public boolean handleNativeDragFinished(DragSourceEvent event) {
        EditPartViewer viewer = this.getCurrentViewer();
        if (viewer instanceof HTMLPaletteViewer) {
            ((HTMLPaletteViewer)viewer).setCreationLock(false);
            HTMLPaletteTarget paletteTarget = ((HTMLPaletteViewer)viewer).getPaletteTarget();
            if (paletteTarget != null) {
                paletteTarget.loadDefaultTool();
            }
            ((HTMLPaletteViewer)viewer).deselectAllEntries();
        }
        return super.handleNativeDragFinished(event);
    }

    public void mouseDoubleClick(MouseEvent e, EditPartViewer viewer) {
        if (viewer instanceof HTMLPaletteViewer && viewer instanceof PaletteViewer) {
            Object item;
            EditPart part = this.getTargetEditPart();
            if (part != null && (item = part.getModel()) instanceof ToolEntry) {
                ((PaletteViewer)viewer).setActiveTool((ToolEntry)item);
                if (((HTMLPaletteViewer)viewer).invokeQuickAction()) {
                    HTMLPaletteTarget paletteTarget = ((HTMLPaletteViewer)viewer).getPaletteTarget();
                    if (paletteTarget != null) {
                        paletteTarget.loadDefaultTool();
                    }
                    ((HTMLPaletteViewer)viewer).deselectAllEntries();
                }
            }
            return;
        }
        super.mouseDoubleClick(e, viewer);
    }
}

