/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.palette.model;

import com.ibm.etools.palette.model.IVisibilityHelper;
import com.ibm.etools.palette.model.PaletteData;
import com.ibm.etools.palette.model.PaletteVisibilityData;
import com.ibm.etools.webedit.palette.HTMLPaletteViewer;
import com.ibm.etools.webedit.palette.PaletteContextRegistryReader;
import com.ibm.etools.webedit.palette.view.AbstractHTMLPaletteVisibilityInspector;
import com.ibm.etools.webedit.palette.view.HTMLPaletteVisibilityInspector;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.ui.IEditorInput;

public class PaletteVisibilityHelper
implements IVisibilityHelper {
    private static PaletteVisibilityHelper instance = new PaletteVisibilityHelper();

    private PaletteVisibilityHelper() {
    }

    public static IVisibilityHelper getInstance() {
        return instance;
    }

    @Override
    public boolean isVisible(PaletteData data, HTMLPaletteViewer viewer) {
        IFile file;
        PaletteVisibilityData visibility = data.getVisibilityData();
        if (visibility == null) {
            return true;
        }
        List<PaletteVisibilityData.FacetData[]> orList = visibility.getOrList();
        List<PaletteVisibilityData.FacetData> requireFacets = visibility.getRequiredFacets();
        IProject proj = null;
        IEditorInput input = null;
        if (viewer != null) {
            input = viewer.getContributingEditorInput();
        }
        if (input != null && (file = (IFile)input.getAdapter(IFile.class)) != null) {
            proj = file.getProject();
        }
        if (proj != null) {
            HTMLPaletteVisibilityInspector inspector;
            int i = 0;
            while (requireFacets != null && i < requireFacets.size()) {
                if (!PaletteVisibilityHelper.isFacetPresent(requireFacets.get(i), proj)) {
                    return false;
                }
                ++i;
            }
            i = 0;
            while (orList != null && i < orList.size()) {
                PaletteVisibilityData.FacetData[] ordFacets = orList.get(i);
                if (!PaletteVisibilityHelper.isOrListSatisfied(ordFacets, proj)) {
                    return false;
                }
                ++i;
            }
            if (visibility.hasInspector() && (inspector = visibility.getInspector()) != null) {
                boolean itemVisible = true;
                itemVisible = inspector instanceof AbstractHTMLPaletteVisibilityInspector ? ((AbstractHTMLPaletteVisibilityInspector)inspector).isItemVisible(data, viewer.getHtmlEditDomain()) : inspector.isItemVisible(viewer.getHtmlEditDomain());
                if (!itemVisible) {
                    return false;
                }
            }
        }
        return true;
    }

    private static boolean isFacetPresent(PaletteVisibilityData.FacetData facet, IProject proj) {
        boolean exists;
        boolean shouldExist;
        boolean visible = true;
        String id = facet.id;
        String version = facet.version;
        String existsString = facet.existsString;
        if (version == "") {
            version = null;
        }
        if ((shouldExist = existsString == null ? true : Boolean.valueOf(existsString)) != (exists = PaletteContextRegistryReader.projectHasFacet(proj, id, version))) {
            visible = false;
        }
        return visible;
    }

    private static boolean isOrListSatisfied(PaletteVisibilityData.FacetData[] facets, IProject proj) {
        boolean satisfied = false;
        int i = 0;
        while (i < facets.length) {
            PaletteVisibilityData.FacetData facet = facets[i];
            if (PaletteVisibilityHelper.isFacetPresent(facet, proj)) {
                satisfied = true;
                break;
            }
            ++i;
        }
        return satisfied;
    }
}

