/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.palette.customize;

import com.ibm.etools.palette.model.PaletteItemData;
import com.ibm.etools.palette.model.PaletteItemDataImpl;
import com.ibm.etools.webedit.palette.ResourceHandler;
import com.ibm.etools.webedit.palette.customize.AttributeMenu;
import com.ibm.etools.webedit.palette.customize.HTMLPaletteCustomizer;
import com.ibm.etools.webedit.palette.customize.HTMLPaletteViewerPreferences;
import com.ibm.etools.webedit.palette.model.PaletteCategoryItem;
import com.ibm.etools.webedit.palette.model.PaletteItem;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.gef.ui.palette.customize.DefaultEntryPage;
import org.eclipse.gef.ui.palette.customize.EntryPage;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

class PaletteEntryPage
extends DefaultEntryPage {
    protected String description = null;
    protected boolean visible = true;
    protected boolean visibleChanged = false;
    protected String label = null;
    protected String tagname = null;
    protected HashMap newAttrs = null;
    protected Map oldAttrs = null;
    protected boolean attrsChanged = false;
    protected int nameOffset = 0;
    protected boolean isModifiable = false;
    protected TableViewer attrViewer = null;
    protected Button deleteAttrButton = null;
    protected Label tagAttributesLabel = null;
    protected HTMLPaletteViewerPreferences prefs = null;
    protected HTMLPaletteCustomizer customizer = null;
    protected boolean dirty = false;
    public final String newNameTextFormat = "({0} {1})";
    public final String newValueTextFormat = "({0})";
    public final String newNameText = ResourceHandler._UI_New_Name_7;
    public final String newValueText = ResourceHandler._UI_New_Value_8;
    public static final String NAME_PROPERTY = "name";
    public static final String VALUE_PROPERTY = "value";

    public PaletteEntryPage(HTMLPaletteCustomizer customizer) {
        this.customizer = customizer;
    }

    public void createControl(Composite parentPanel, PaletteEntry entry) {
        super.createControl(parentPanel, entry);
        if (entry instanceof PaletteItem) {
            Object template = ((PaletteItem)entry).getTemplate();
            if (template instanceof PaletteItemDataImpl) {
                this.isModifiable = ((PaletteItemDataImpl)template).isModifiable();
            }
            Composite panel = (Composite)this.getControl();
            Control[] oldTablist = panel.getTabList();
            Control[] tablist = new Control[oldTablist.length + 2];
            int cnt = 0;
            while (cnt < oldTablist.length) {
                tablist[cnt] = oldTablist[cnt];
                ++cnt;
            }
            this.createLabel(panel, 0, ResourceHandler._UI_Tag_Name_9);
            tablist[cnt] = this.createTagNameText(panel);
            this.tagAttributesLabel = this.createLabel(panel, 0, ResourceHandler._UI_Attributes_1);
            tablist[++cnt] = this.createAttributeTable(panel);
            panel.setTabList(tablist);
        }
    }

    protected Text createTagNameText(Composite panel) {
        String name = ((PaletteItemDataImpl)((PaletteItem)this.getEntry()).getTemplate()).getTagName();
        if (name == null) {
            name = "";
        }
        int style = 2052;
        if (!this.isModifiable) {
            style |= 8;
        }
        Text tagName = this.createText(panel, style, name);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)tagName, "com.ibm.etools.webedit.palette.csti1000");
        tagName.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                String newVal = ((Text)e.getSource()).getText();
                PaletteEntryPage.this.handleTagNameChanged(newVal);
            }
        });
        tagName.setVisible(true);
        return tagName;
    }

    protected Composite createAttributeTable(Composite parent) {
        Composite panel = new Composite(parent, 0);
        GridData gd = new GridData();
        gd.verticalAlignment = 4;
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        panel.setLayoutData((Object)gd);
        GridLayout gl = new GridLayout();
        gl.numColumns = 2;
        gl.marginWidth = 0;
        panel.setLayout((Layout)gl);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)panel, "com.ibm.etools.webedit.palette.csti1100");
        this.attrViewer = new TableViewer(new Table(panel, 67586));
        Table attrControl = this.attrViewer.getTable();
        attrControl.setHeaderVisible(true);
        attrControl.setLinesVisible(true);
        TableColumn nameColumn = new TableColumn(attrControl, 0);
        nameColumn.setText(ResourceHandler._UI_Name_3);
        TableColumn valueColumn = new TableColumn(attrControl, 0);
        valueColumn.setText(ResourceHandler._UI_Value_4);
        TableLayout layout = new TableLayout();
        ColumnWeightData nameData = new ColumnWeightData(50, true);
        layout.addColumnData((ColumnLayoutData)nameData);
        ColumnWeightData valueData = new ColumnWeightData(50, true);
        layout.addColumnData((ColumnLayoutData)valueData);
        attrControl.setLayout((Layout)layout);
        String[] columnProperties = new String[]{NAME_PROPERTY, VALUE_PROPERTY};
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.widthHint = 200;
        gd.grabExcessVerticalSpace = true;
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.verticalSpan = 2;
        gd.heightHint = 60;
        attrControl.setLayoutData((Object)gd);
        IStructuredContentProvider attrContentProvider = new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                Object[] ret = null;
                if (inputElement instanceof Map) {
                    ret = ((Map)inputElement).entrySet().toArray();
                }
                return ret;
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        };
        this.attrViewer.setContentProvider((IContentProvider)attrContentProvider);
        ITableLabelProvider attrLabelProvider = new ITableLabelProvider(){

            public Image getColumnImage(Object element, int columnIndex) {
                return null;
            }

            public String getColumnText(Object element, int columnIndex) {
                String ret = null;
                if (element instanceof Map.Entry) {
                    if (columnIndex == 0) {
                        ret = ((Map.Entry)element).getKey().toString();
                    } else if (columnIndex == 1) {
                        ret = ((Map.Entry)element).getValue().toString();
                    }
                }
                return ret;
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public void dispose() {
            }

            public boolean isLabelProperty(Object element, String property) {
                return true;
            }

            public void removeListener(ILabelProviderListener listener) {
            }
        };
        this.attrViewer.setLabelProvider((IBaseLabelProvider)attrLabelProvider);
        Button button = new Button(panel, 8);
        button.setText(ResourceHandler._UI_New_5);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        button.setLayoutData((Object)gd);
        button.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                PaletteEntryPage.this.attrNewButtonSelected();
            }
        });
        this.deleteAttrButton = new Button(panel, 8);
        this.deleteAttrButton.setText(ResourceHandler._UI_Delete_6);
        gd = new GridData();
        gd.verticalAlignment = 1;
        gd.horizontalAlignment = 4;
        this.deleteAttrButton.setLayoutData((Object)gd);
        this.deleteAttrButton.setEnabled(false);
        this.deleteAttrButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                PaletteEntryPage.this.attrDeleteButtonSelected();
            }
        });
        final boolean attrsEditable = ((PaletteItemData)((PaletteItem)this.getEntry()).getTemplate()).isTagAttributesEditable();
        if (attrsEditable) {
            AttributeMenu attrMenu = new AttributeMenu(this.attrViewer);
            attrMenu.createContextMenu((Control)attrControl);
            attrControl.setMenu(attrMenu.getMenu());
            CellEditor[] cellEditors = new CellEditor[]{new TextCellEditor((Composite)attrControl), new TextCellEditor((Composite)attrControl)};
            this.attrViewer.setCellEditors(cellEditors);
            this.attrViewer.setCellModifier((ICellModifier)new PEPCellModifier());
        } else {
            Table table;
            Display disp = Display.getCurrent();
            if (disp != null && (table = this.attrViewer.getTable()) != null) {
                table.setVisible(false);
                this.deleteAttrButton.setVisible(false);
                button.setVisible(false);
                this.tagAttributesLabel.setVisible(false);
            }
        }
        this.attrViewer.setColumnProperties(columnProperties);
        if (!attrsEditable) {
            button.setEnabled(false);
            this.deleteAttrButton.setEnabled(false);
        }
        this.attrViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (attrsEditable) {
                    StructuredSelection ss;
                    boolean enableDelete = false;
                    ISelection s = event.getSelection();
                    if (s instanceof StructuredSelection && (ss = (StructuredSelection)s).size() > 0) {
                        enableDelete = true;
                    }
                    PaletteEntryPage.this.deleteAttrButton.setEnabled(enableDelete);
                }
            }
        });
        if (attrsEditable) {
            this.newAttrs = (HashMap)((PaletteItemData)((PaletteItem)this.getEntry()).getTemplate()).getTagAttributes();
            this.oldAttrs = (Map)this.newAttrs.clone();
            this.attrViewer.setInput((Object)this.newAttrs);
        }
        return panel;
    }

    protected void attrNewButtonSelected() {
        boolean done = false;
        String newName = null;
        String newValue = null;
        Object[] inserts = new Object[2];
        while (!done) {
            inserts[0] = this.newNameText;
            inserts[1] = new Integer(this.nameOffset++);
            newName = MessageFormat.format("({0} {1})", inserts);
            if (this.newAttrs.get(newName) != null) continue;
            inserts[0] = this.newValueText;
            inserts[1] = null;
            newValue = MessageFormat.format("({0})", inserts);
            this.newAttrs.put(newName, newValue);
            this.attrsChanged = true;
            done = true;
        }
        this.attrViewer.refresh(false);
        this.addToChangedPages();
    }

    protected void attrDeleteButtonSelected() {
        ISelection sel = this.attrViewer.getSelection();
        if (sel instanceof StructuredSelection) {
            StructuredSelection ss = (StructuredSelection)sel;
            for (Object o : ss) {
                if (!(o instanceof Map.Entry)) continue;
                this.newAttrs.remove(((Map.Entry)o).getKey());
                this.attrsChanged = true;
            }
        }
        this.attrViewer.refresh(false);
        this.addToChangedPages();
    }

    protected void handleDescriptionChanged(String text) {
        PaletteEntry entry = this.getEntry();
        if (this.description == null) {
            this.description = entry.getDescription();
        }
        entry.setDescription(text);
        this.addToChangedPages();
    }

    private void addToChangedPages() {
        if (!this.dirty) {
            this.customizer.addToChangedPages((EntryPage)this);
            this.dirty = true;
        }
    }

    protected void handleHiddenSelected(boolean isChecked) {
        PaletteEntry entry = this.getEntry();
        if (!this.visibleChanged) {
            this.visible = entry.isVisible();
            this.visibleChanged = true;
        }
        if (entry instanceof PaletteCategoryItem) {
            ((PaletteCategoryItem)entry).setVisible(!isChecked, this.prefs.getContext());
        } else {
            entry.setVisible(!isChecked);
        }
        this.addToChangedPages();
    }

    protected void handleNameChanged(String text) {
        PaletteEntry entry = this.getEntry();
        if (this.label == null) {
            this.label = entry.getLabel();
        }
        entry.setLabel(text);
        this.addToChangedPages();
    }

    protected void handleTagNameChanged(String text) {
        PaletteEntry entry = this.getEntry();
        if (this.tagname == null) {
            this.tagname = ((PaletteItemDataImpl)((PaletteItem)entry).getTemplate()).getTagName();
        }
        ((PaletteItemDataImpl)((PaletteItem)entry).getTemplate()).setTagName(text);
        this.addToChangedPages();
    }

    public void doChanges() {
        this.description = null;
        this.visibleChanged = false;
        this.label = null;
        this.tagname = null;
        if (this.attrsChanged) {
            this.oldAttrs = (Map)this.newAttrs.clone();
            this.attrsChanged = false;
        }
        this.dirty = false;
    }

    public void undoChanges() {
        PaletteEntry entry = this.getEntry();
        if (this.description != null) {
            entry.setDescription(this.description);
            this.description = null;
        }
        if (this.visibleChanged) {
            if (entry instanceof PaletteCategoryItem) {
                ((PaletteCategoryItem)entry).setVisible(this.visible, this.prefs.getContext());
            } else {
                entry.setVisible(this.visible);
            }
            this.visibleChanged = false;
        }
        if (this.label != null) {
            entry.setLabel(this.label);
            this.label = null;
        }
        if (this.tagname != null) {
            ((PaletteItemDataImpl)((PaletteItem)entry).getTemplate()).setTagName(this.tagname);
            this.tagname = null;
        }
        if (this.attrsChanged) {
            this.newAttrs.clear();
            this.newAttrs.putAll(this.oldAttrs);
            this.attrsChanged = false;
        }
        this.dirty = false;
    }

    public void setPreferences(HTMLPaletteViewerPreferences newPrefs) {
        if (this.prefs != newPrefs) {
            this.prefs = newPrefs;
        }
    }

    public Element mergeItemElement(Document document) {
        Element itemElement = null;
        NodeList nodeList = document.getElementsByTagName("item");
        int j = 0;
        while (j < nodeList.getLength()) {
            String elementId = ((Element)nodeList.item(j)).getAttribute("id");
            if (elementId.equals(this.getEntry().getId())) {
                itemElement = (Element)nodeList.item(j);
                break;
            }
            ++j;
        }
        if (itemElement == null) {
            itemElement = document.createElement("item");
            document.getDocumentElement().appendChild(itemElement);
        }
        itemElement.setAttribute("id", this.getEntry().getId());
        itemElement.setAttribute("category", this.getEntry().getParent().getId());
        if (this.label != null) {
            itemElement.setAttribute(NAME_PROPERTY, this.getEntry().getLabel());
        }
        if (this.description != null) {
            itemElement.setAttribute("description", this.getEntry().getDescription());
        }
        if (this.visibleChanged) {
            itemElement.setAttribute("visible", Boolean.toString(this.getEntry().isVisible()));
        }
        if (this.attrsChanged) {
            NodeList oldTagAttributes = itemElement.getElementsByTagName("tagAttribute");
            if (oldTagAttributes != null) {
                int length = oldTagAttributes.getLength();
                int i = 0;
                while (i < length) {
                    itemElement.removeChild(oldTagAttributes.item(0));
                    ++i;
                }
            }
            for (String name : this.newAttrs.keySet()) {
                String value = (String)this.newAttrs.get(name);
                Element tagAttElement = document.createElement("tagAttribute");
                itemElement.appendChild(tagAttElement);
                tagAttElement.setAttribute(NAME_PROPERTY, name);
                tagAttElement.setAttribute(VALUE_PROPERTY, value);
            }
        }
        return itemElement;
    }

    protected class PEPCellModifier
    implements ICellModifier {
        public boolean canModify(Object element, String property) {
            return true;
        }

        public void modify(Object element, String property, Object value) {
            if (element instanceof TableItem) {
                TableItem ti = (TableItem)element;
                Object data = ti.getData();
                if (data instanceof Map.Entry) {
                    Map.Entry entry = (Map.Entry)data;
                    if (property.equals(PaletteEntryPage.NAME_PROPERTY)) {
                        if (!value.equals(entry.getKey()) && PaletteEntryPage.this.newAttrs.get(value) == null) {
                            Object oldValue = entry.getValue();
                            PaletteEntryPage.this.newAttrs.remove(entry.getKey());
                            PaletteEntryPage.this.newAttrs.put(value, oldValue);
                            PaletteEntryPage.this.attrsChanged = true;
                            PaletteEntryPage.this.attrViewer.refresh();
                        }
                    } else if (property.equals(PaletteEntryPage.VALUE_PROPERTY) && !value.equals(entry.getValue())) {
                        entry.setValue(value);
                        PaletteEntryPage.this.attrsChanged = true;
                        PaletteEntryPage.this.attrViewer.refresh((Object)entry);
                    }
                }
            } else if (element instanceof Map.Entry) {
                Map.Entry entry = (Map.Entry)element;
                if (!property.equals(PaletteEntryPage.NAME_PROPERTY) && property.equals(PaletteEntryPage.VALUE_PROPERTY)) {
                    entry.setValue(value);
                    PaletteEntryPage.this.attrsChanged = true;
                    PaletteEntryPage.this.attrViewer.refresh((Object)entry);
                }
            }
            PaletteEntryPage.this.addToChangedPages();
        }

        public Object getValue(Object element, String property) {
            Object retVal = element;
            if (element instanceof Map.Entry) {
                Map.Entry entry = (Map.Entry)element;
                if (property.equals(PaletteEntryPage.NAME_PROPERTY)) {
                    retVal = entry.getKey();
                } else if (property.equals(PaletteEntryPage.VALUE_PROPERTY)) {
                    retVal = entry.getValue();
                }
            }
            return retVal;
        }
    }
}

