/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.palette.customize;

import com.ibm.etools.webedit.palette.customize.HTMLPaletteCustomizer;
import com.ibm.etools.webedit.palette.customize.HTMLPaletteViewerPreferences;
import com.ibm.etools.webedit.palette.model.PaletteCategory;
import org.eclipse.gef.palette.PaletteDrawer;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.gef.ui.palette.customize.DrawerEntryPage;
import org.eclipse.gef.ui.palette.customize.EntryPage;
import org.eclipse.swt.widgets.Composite;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class PaletteDrawerEntryPage
extends DrawerEntryPage {
    protected String description = null;
    protected String label = null;
    protected boolean isVisible = false;
    protected int initialState = 1;
    protected boolean visibleChanged = false;
    protected boolean initialStateChanged = false;
    protected HTMLPaletteViewerPreferences prefs = null;
    protected HTMLPaletteCustomizer customizer = null;
    private boolean dirty = false;

    public PaletteDrawerEntryPage(HTMLPaletteCustomizer customizer) {
        this.customizer = customizer;
    }

    public void createControl(Composite parent, PaletteEntry entry) {
        super.createControl(parent, entry);
    }

    protected void handleNameChanged(String text) {
        PaletteEntry entry = this.getEntry();
        if (this.label == null) {
            this.label = entry.getLabel();
        }
        super.handleNameChanged(text);
        this.addToChangedPages();
    }

    protected void handleDescriptionChanged(String text) {
        PaletteEntry entry = this.getEntry();
        if (this.description == null) {
            this.description = entry.getDescription();
        }
        super.handleDescriptionChanged(text);
        this.addToChangedPages();
    }

    protected void handleHiddenSelected(boolean selection) {
        PaletteDrawer entry = (PaletteDrawer)this.getEntry();
        if (!this.visibleChanged) {
            this.isVisible = entry.isVisible();
            this.visibleChanged = true;
        }
        if (entry instanceof PaletteCategory && this.prefs != null) {
            ((PaletteCategory)entry).setVisible(!selection, this.prefs.getContext());
        } else {
            super.handleHiddenSelected(selection);
        }
        this.addToChangedPages();
    }

    protected void handleOpenSelected(boolean selection) {
        PaletteCategory category = (PaletteCategory)this.getEntry();
        if (!this.initialStateChanged) {
            this.initialState = category.getInitialState();
            this.initialStateChanged = true;
        }
        int status = selection ? 0 : 1;
        category.setInitialState(status, this.prefs.getContext());
        this.getPinDrawerInitiallyButton().setEnabled(selection);
        if (!selection) {
            this.getPinDrawerInitiallyButton().setSelection(false);
        }
        this.addToChangedPages();
    }

    protected void handlePinSelected(boolean selection) {
        PaletteCategory category = (PaletteCategory)this.getEntry();
        if (!this.initialStateChanged) {
            this.initialState = category.getInitialState();
            this.initialStateChanged = true;
        }
        int status = selection ? 2 : 0;
        category.setInitialState(status, this.prefs.getContext());
        this.addToChangedPages();
    }

    public void doChanges() {
        this.label = null;
        this.description = null;
        this.visibleChanged = false;
        this.initialStateChanged = false;
        this.dirty = false;
    }

    public void undoChanges() {
        PaletteCategory category = (PaletteCategory)this.getEntry();
        if (this.label != null) {
            category.setLabel(this.label);
            this.label = null;
        }
        if (this.description != null) {
            category.setDescription(this.description);
            this.description = null;
        }
        if (this.visibleChanged) {
            category.setVisible(this.isVisible, this.prefs.getContext());
            this.visibleChanged = false;
        }
        if (this.initialStateChanged) {
            category.setInitialState(this.initialState, this.prefs.getContext());
            this.initialStateChanged = false;
        }
    }

    public void setPreferences(HTMLPaletteViewerPreferences newPrefs) {
        if (this.prefs != newPrefs) {
            this.prefs = newPrefs;
        }
    }

    public String getEntryId() {
        return this.getEntry().getId();
    }

    private void addToChangedPages() {
        if (!this.dirty) {
            this.customizer.addToChangedPages((EntryPage)this);
            this.dirty = true;
        }
    }

    public Element mergeDrawerElement(Document document) {
        Element drawerElement = null;
        NodeList nodeList = document.getElementsByTagName("category");
        int j = 0;
        while (j < nodeList.getLength()) {
            String elementId = ((Element)nodeList.item(j)).getAttribute("id");
            if (elementId.equals(this.getEntry().getId())) {
                drawerElement = (Element)nodeList.item(j);
                break;
            }
            ++j;
        }
        if (drawerElement == null) {
            drawerElement = document.createElement("category");
            document.getDocumentElement().appendChild(drawerElement);
        }
        drawerElement.setAttribute("id", this.getEntry().getId());
        if (this.label != null) {
            drawerElement.setAttribute("name", this.getEntry().getLabel());
        }
        if (this.description != null) {
            drawerElement.setAttribute("description", this.getEntry().getDescription());
        }
        if (this.visibleChanged) {
            drawerElement.setAttribute("visible", Boolean.toString(this.getEntry().isVisible()));
        }
        if (this.initialStateChanged) {
            int initialState = ((PaletteCategory)this.getEntry()).getInitialState();
            if (initialState == 0) {
                drawerElement.setAttribute("initiallyopen", "true");
            } else if (initialState == 2) {
                drawerElement.setAttribute("initiallypinned", "true");
                drawerElement.setAttribute("initiallyopen", "true");
            } else if (initialState == 1) {
                drawerElement.setAttribute("initiallypinned", "false");
                drawerElement.setAttribute("initiallyopen", "false");
            }
        }
        return drawerElement;
    }
}

