/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.palette.customize;

import com.ibm.etools.palette.model.PaletteItemDataImpl;
import com.ibm.etools.webedit.palette.HTMLPaletteViewer;
import com.ibm.etools.webedit.palette.PalettePlugin;
import com.ibm.etools.webedit.palette.customize.AbstractPaletteViewerPreferences;
import com.ibm.etools.webedit.palette.model.PaletteCategory;
import com.ibm.etools.webedit.palette.model.PaletteCategoryItem;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.gef.palette.PaletteDrawer;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.ui.palette.PaletteViewer;
import org.eclipse.jface.preference.IPreferenceStore;

public class HTMLPaletteViewerPreferences
extends AbstractPaletteViewerPreferences {
    protected static final Integer MAP_ENTRY_PINNED_OPEN = new Integer(2);
    protected static final Integer MAP_ENTRY_OPEN = new Integer(0);
    protected static final Integer MAP_ENTRY_CLOSED = new Integer(1);
    protected String context;
    protected PaletteRoot root = null;
    protected Map mapState = new HashMap();
    protected HTMLPaletteViewer viewer = null;

    public HTMLPaletteViewerPreferences() {
        this(PalettePlugin.getDefault().getPreferenceStore());
    }

    public HTMLPaletteViewerPreferences(IPreferenceStore store) {
        super(store);
    }

    public String getContext() {
        return this.context;
    }

    public void setContext(String newContext) {
        if (newContext != null && !newContext.equals(this.context)) {
            this.context = newContext;
            this.updateContextValues((PaletteEntry)this.root);
        }
    }

    public void setPaletteRoot(PaletteRoot newRoot) {
        if (this.root != newRoot) {
            this.root = newRoot;
            this.updateContextValues((PaletteEntry)this.root);
        }
    }

    public void refreshContext() {
        if (this.root != null) {
            this.updateContextValues((PaletteEntry)this.root);
            this.restoreStateValues();
        }
    }

    public void backupStateValues(PaletteViewer paletteViewer) {
        if (paletteViewer != null && this.root != null && this.mapState != null) {
            this.mapState.clear();
            List children = this.root.getChildren();
            Iterator i = children.iterator();
            Object o = null;
            while (i.hasNext()) {
                PaletteCategory pc;
                o = i.next();
                if (!(o instanceof PaletteCategory) || (pc = (PaletteCategory)o) == null) continue;
                if (paletteViewer.isExpanded((PaletteDrawer)pc)) {
                    if (paletteViewer.isPinned((PaletteDrawer)pc)) {
                        this.mapState.put(pc, MAP_ENTRY_PINNED_OPEN);
                        continue;
                    }
                    this.mapState.put(pc, MAP_ENTRY_OPEN);
                    continue;
                }
                this.mapState.put(pc, MAP_ENTRY_CLOSED);
            }
        }
    }

    protected void restoreStateValues() {
        if (this.root != null && this.mapState != null && !this.mapState.isEmpty()) {
            List children = this.root.getChildren();
            Iterator i = children.iterator();
            Object o = null;
            while (i.hasNext()) {
                PaletteCategory pc;
                o = i.next();
                if (!(o instanceof PaletteCategory) || (pc = (PaletteCategory)o) == null) continue;
                Integer state = (Integer)this.mapState.get((Object)pc);
                if (state != null) {
                    pc.refreshStateValues(state);
                    continue;
                }
                pc.refreshStateValues(1);
            }
        }
    }

    protected void updateContextValues(PaletteEntry pe) {
        PaletteCategoryItem pci;
        Object o;
        if (pe instanceof PaletteRoot) {
            if (pe == this.root) {
                List children = this.root.getChildren();
                Iterator i = children.iterator();
                Object o2 = null;
                while (i.hasNext()) {
                    o2 = i.next();
                    if (!(o2 instanceof PaletteEntry)) continue;
                    this.updateContextValues(o2);
                }
            }
        } else if (pe instanceof PaletteCategory) {
            PaletteCategory pc = (PaletteCategory)pe;
            pc.updateContextValues(this.context, this.viewer);
            List children = pc.getChildren();
            Iterator i = children.iterator();
            Object o3 = null;
            while (i.hasNext()) {
                o3 = i.next();
                if (!(o3 instanceof PaletteEntry)) continue;
                this.updateContextValues(o3);
            }
        } else if (pe instanceof PaletteCategoryItem && (o = (pci = (PaletteCategoryItem)pe).getTemplate()) instanceof PaletteItemDataImpl) {
            pci.updateVisible(this.context, this.viewer);
        }
    }

    public void setHTMLPaletteViewer(HTMLPaletteViewer viewer) {
        this.viewer = viewer;
    }

    public HTMLPaletteViewer getHTMLPaletteViewer() {
        return this.viewer;
    }
}

